/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.ConvertContext;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.idea.maven.dom.converters.MavenArtifactCoordinatesConverter;
import org.jetbrains.idea.maven.indices.MavenProjectIndicesManager;
import org.jetbrains.idea.maven.project.MavenId;

public class MavenArtifactCoordinatesVersionConverter
extends MavenArtifactCoordinatesConverter {
    @Override
    protected boolean doIsValid(MavenId id, MavenProjectIndicesManager manager, ConvertContext context) {
        if (StringUtil.isEmpty((String)id.getGroupId()) || StringUtil.isEmpty((String)id.getArtifactId()) || StringUtil.isEmpty((String)id.getVersion())) {
            return false;
        }
        if (this.isVersionRange(id)) {
            return true;
        }
        return manager.hasVersion(id.getGroupId(), id.getArtifactId(), id.getVersion());
    }

    private boolean isVersionRange(MavenId id) {
        String version = id.getVersion().trim();
        return version.startsWith("(") || version.startsWith("[");
    }

    @Override
    protected Set<String> doGetVariants(MavenId id, MavenProjectIndicesManager manager) {
        if (StringUtil.isEmpty((String)id.getGroupId()) || StringUtil.isEmpty((String)id.getArtifactId())) {
            return Collections.emptySet();
        }
        return manager.getVersions(id.getGroupId(), id.getArtifactId());
    }
}

