/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerUIUtil {
    @NonNls
    public static final String FULL_VALUE_POPUP_DIMENSION_KEY = "XDebugger.FullValuePopup";

    private DebuggerUIUtil() {
    }

    public static void enableEditorOnCheck(final JCheckBox checkbox, final JComponent textfield) {
        checkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = checkbox.isSelected();
                textfield.setEnabled(selected);
            }
        });
        textfield.setEnabled(checkbox.isSelected());
    }

    public static void focusEditorOnCheck(final JCheckBox checkbox, final JComponent component) {
        final Runnable runnable = new Runnable(){

            @Override
            public void run() {
                component.requestFocus();
            }
        };
        checkbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (checkbox.isSelected()) {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        });
    }

    public static void invokeLater(Runnable runnable) {
        ApplicationManager.getApplication().invokeLater(runnable);
    }

    public static void invokeOnEventDispatch(Runnable runnable) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable);
        }
    }

    public static RelativePoint calcPopupLocation(Editor editor, int line) {
        Point p = editor.logicalPositionToXY(new LogicalPosition(line + 1, 0));
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        if (!visibleArea.contains(p)) {
            p = new Point((visibleArea.x + visibleArea.width) / 2, (visibleArea.y + visibleArea.height) / 2);
        }
        return new RelativePoint((Component)editor.getContentComponent(), p);
    }

    public static void showValuePopup(@NotNull XFullValueEvaluator text, @NotNull MouseEvent event, @NotNull Project project) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/DebuggerUIUtil.showValuePopup must not be null");
        }
        if (event == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/xdebugger/impl/ui/DebuggerUIUtil.showValuePopup must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/xdebugger/impl/ui/DebuggerUIUtil.showValuePopup must not be null");
        }
        JTextArea textArea = new JTextArea("Evaluating...");
        final FullValueEvaluationCallbackImpl callback = new FullValueEvaluationCallbackImpl(textArea);
        text.startEvaluation((XFullValueEvaluator.XFullValueEvaluationCallback)callback);
        textArea.setEditable(false);
        textArea.setBackground(HintUtil.INFORMATION_COLOR);
        textArea.setLineWrap(false);
        JScrollPane component = ScrollPaneFactory.createScrollPane((JComponent)textArea);
        Dimension frameSize = WindowManager.getInstance().getFrame(project).getSize();
        Dimension size = DimensionService.getInstance().getSize(FULL_VALUE_POPUP_DIMENSION_KEY, project);
        if (size == null) {
            size = new Dimension(frameSize.width / 2, frameSize.height / 2);
        }
        component.setPreferredSize(size);
        component.setBorder(null);
        JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component, null).setResizable(true).setMovable(true).setDimensionServiceKey(project, FULL_VALUE_POPUP_DIMENSION_KEY, false).setRequestFocus(false).setCancelCallback((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                callback.setObsolete();
                return true;
            }
        }).createPopup();
        Component parentComponent = event.getComponent();
        RelativePoint point = new RelativePoint(parentComponent, new Point(event.getX() - size.width, event.getY() - size.height));
        popup.show(point);
    }

    private static class FullValueEvaluationCallbackImpl
    implements XFullValueEvaluator.XFullValueEvaluationCallback {
        private final AtomicBoolean myObsolete = new AtomicBoolean(false);
        private final JTextArea myTextArea;

        public FullValueEvaluationCallbackImpl(JTextArea textArea) {
            this.myTextArea = textArea;
        }

        public void evaluated(@NotNull String fullValue) {
            if (fullValue == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/DebuggerUIUtil$FullValueEvaluationCallbackImpl.evaluated must not be null");
            }
            this.evaluated(fullValue, null);
        }

        public void evaluated(final @NotNull String fullValue, final @Nullable Font font) {
            if (fullValue == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/DebuggerUIUtil$FullValueEvaluationCallbackImpl.evaluated must not be null");
            }
            DebuggerUIUtil.invokeOnEventDispatch(new Runnable(){

                @Override
                public void run() {
                    FullValueEvaluationCallbackImpl.this.myTextArea.setText(fullValue);
                    if (font != null) {
                        FullValueEvaluationCallbackImpl.this.myTextArea.setFont(font);
                    }
                    FullValueEvaluationCallbackImpl.this.myTextArea.setCaretPosition(0);
                }
            });
        }

        public void errorOccurred(final @NotNull String errorMessage) {
            if (errorMessage == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/ui/DebuggerUIUtil$FullValueEvaluationCallbackImpl.errorOccurred must not be null");
            }
            DebuggerUIUtil.invokeOnEventDispatch(new Runnable(){

                @Override
                public void run() {
                    FullValueEvaluationCallbackImpl.this.myTextArea.setForeground(XDebuggerUIConstants.ERROR_MESSAGE_ATTRIBUTES.getFgColor());
                    FullValueEvaluationCallbackImpl.this.myTextArea.setText(errorMessage);
                }
            });
        }

        private void setObsolete() {
            this.myObsolete.set(true);
        }

        public boolean isObsolete() {
            return this.myObsolete.get();
        }
    }
}

