/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomManagerImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvaluatedXmlNameImpl
implements EvaluatedXmlName {
    private static final Key<CachedValue<FactoryMap<String, List<String>>>> NAMESPACE_PROVIDER_KEY = Key.create((String)"NamespaceProvider");
    private static final Map<EvaluatedXmlNameImpl, EvaluatedXmlNameImpl> ourInterned = new ConcurrentHashMap();
    private final XmlName myXmlName;
    private final String myNamespaceKey;
    private final boolean myEqualToParent;

    private EvaluatedXmlNameImpl(@NotNull XmlName xmlName, @Nullable String namespaceKey, boolean equalToParent) {
        if (xmlName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/EvaluatedXmlNameImpl.<init> must not be null");
        }
        this.myXmlName = xmlName;
        this.myNamespaceKey = namespaceKey;
        this.myEqualToParent = equalToParent;
    }

    @NotNull
    public final String getLocalName() {
        String string = this.myXmlName.getLocalName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/EvaluatedXmlNameImpl.getLocalName must not return null");
        }
        return string;
    }

    public final XmlName getXmlName() {
        return this.myXmlName;
    }

    public final EvaluatedXmlName evaluateChildName(@NotNull XmlName name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/EvaluatedXmlNameImpl.evaluateChildName must not be null");
        }
        String namespaceKey = name.getNamespaceKey();
        boolean equalToParent = Comparing.equal((String)namespaceKey, (String)this.myNamespaceKey);
        if (namespaceKey == null) {
            namespaceKey = this.myNamespaceKey;
        }
        return EvaluatedXmlNameImpl.createEvaluatedXmlName(name, namespaceKey, equalToParent);
    }

    public String toString() {
        return (this.myNamespaceKey == null ? "" : this.myNamespaceKey + " : ") + this.myXmlName.getLocalName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluatedXmlNameImpl that = (EvaluatedXmlNameImpl)o;
        if (this.myEqualToParent != that.myEqualToParent) {
            return false;
        }
        if (this.myNamespaceKey != null ? !this.myNamespaceKey.equals(that.myNamespaceKey) : that.myNamespaceKey != null) {
            return false;
        }
        return !(this.myXmlName != null ? !this.myXmlName.equals((Object)that.myXmlName) : that.myXmlName != null);
    }

    public int hashCode() {
        int result = this.myXmlName != null ? this.myXmlName.hashCode() : 0;
        result = 31 * result + (this.myNamespaceKey != null ? this.myNamespaceKey.hashCode() : 0);
        result = 31 * result + (this.myEqualToParent ? 1 : 0);
        return result;
    }

    public final boolean isNamespaceAllowed(DomFileElementImpl element, String namespace) {
        if (this.myNamespaceKey == null || this.myEqualToParent) {
            return true;
        }
        XmlFile file = element.getFile();
        return EvaluatedXmlNameImpl.isNamespaceAllowed(namespace, this.getAllowedNamespaces(file));
    }

    @NotNull
    private List<String> getAllowedNamespaces(final XmlFile file) {
        CachedValue value = (CachedValue)file.getUserData(NAMESPACE_PROVIDER_KEY);
        if (value == null) {
            value = CachedValuesManager.getManager((Project)file.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<FactoryMap<String, List<String>>>(){

                public CachedValueProvider.Result<FactoryMap<String, List<String>>> compute() {
                    ConcurrentFactoryMap<String, List<String>> map = new ConcurrentFactoryMap<String, List<String>>(){

                        protected List<String> create(String key) {
                            DomFileDescription<?> description = DomManagerImpl.getDomManager(file.getProject()).getDomFileDescription(file);
                            if (description == null) {
                                return Collections.emptyList();
                            }
                            return description.getAllowedNamespaces(key, file);
                        }
                    };
                    return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{file});
                }
            }, false);
            file.putUserData(NAMESPACE_PROVIDER_KEY, (Object)value);
        }
        List list = (List)((FactoryMap)value.getValue()).get((Object)this.myNamespaceKey);
        assert (list != null);
        List list2 = list;
        if (list2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/EvaluatedXmlNameImpl.getAllowedNamespaces must not return null");
        }
        return list2;
    }

    private static boolean isNamespaceAllowed(String namespace, List<String> list) {
        return list.contains(namespace) || StringUtil.isEmpty((String)namespace) && list.isEmpty();
    }

    public final boolean isNamespaceAllowed(String namespace, XmlFile file) {
        return this.myNamespaceKey == null || this.myEqualToParent || EvaluatedXmlNameImpl.isNamespaceAllowed(namespace, this.getNamespaceList(file));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    @NonNls
    public final String getNamespace(@NotNull XmlElement parentElement, XmlFile file) {
        String string;
        List<String> strings;
        if (parentElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/EvaluatedXmlNameImpl.getNamespace must not be null");
        }
        String xmlElementNamespace = EvaluatedXmlNameImpl.getXmlElementNamespace(parentElement);
        if (!(this.myNamespaceKey == null || this.myEqualToParent || (strings = this.getAllowedNamespaces(file)).isEmpty() || strings.contains(xmlElementNamespace))) {
            string = strings.get(0);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/EvaluatedXmlNameImpl.getNamespace must not return null");
            return string;
        }
        string = xmlElementNamespace;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/util/xml/impl/EvaluatedXmlNameImpl.getNamespace must not return null");
    }

    private static String getXmlElementNamespace(XmlElement parentElement) {
        if (parentElement instanceof XmlTag) {
            return ((XmlTag)parentElement).getNamespace();
        }
        if (parentElement instanceof XmlAttribute) {
            return ((XmlAttribute)parentElement).getNamespace();
        }
        if (parentElement instanceof XmlFile) {
            XmlTag tag;
            XmlDocument document = ((XmlFile)parentElement).getDocument();
            if (document != null && (tag = document.getRootTag()) != null) {
                return tag.getNamespace();
            }
            return "";
        }
        throw new AssertionError((Object)("Can't get namespace of " + parentElement));
    }

    private List<String> getNamespaceList(XmlFile file) {
        return this.getAllowedNamespaces(file);
    }

    protected static EvaluatedXmlNameImpl createEvaluatedXmlName(@NotNull XmlName xmlName, @Nullable String namespaceKey, boolean equalToParent) {
        if (xmlName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/impl/EvaluatedXmlNameImpl.createEvaluatedXmlName must not be null");
        }
        EvaluatedXmlNameImpl name = new EvaluatedXmlNameImpl(xmlName, namespaceKey, equalToParent);
        EvaluatedXmlNameImpl interned = ourInterned.get(name);
        if (interned != null) {
            return interned;
        }
        ourInterned.put(name, name);
        return name;
    }
}

