/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.classpath;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.util.OrderEntryCellAppearanceUtils;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.WeightBasedComparator;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Icons;
import com.intellij.util.Processor;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChooseLibrariesDialog
extends DialogWrapper {
    private SimpleTree myTree = new SimpleTree();
    private AbstractTreeBuilder myBuilder;
    private List<Library> myResult;
    private Map<Object, Object> myLibraryMap = new THashMap();

    protected ChooseLibrariesDialog(Project project, String title) {
        super(project, false);
        this.setTitle(title);
        this.init();
        this.updateOKAction();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.javaee.module.view.dataSource.ChooseLibrariesDialog";
    }

    protected void doOKAction() {
        this.myResult = new ArrayList<Library>();
        this.processSelection((Processor<Library>)new CommonProcessors.CollectProcessor(this.myResult));
        super.doOKAction();
    }

    private void updateOKAction() {
        this.setOKActionEnabled(!this.processSelection((Processor<Library>)new CommonProcessors.FindFirstProcessor()));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    @NotNull
    public List<Library> getSelectedLibraries() {
        List<Object> list = this.myResult == null ? Collections.emptyList() : this.myResult;
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/classpath/ChooseLibrariesDialog.getSelectedLibraries must not return null");
        }
        return list;
    }

    private boolean processSelection(Processor<Library> processor) {
        for (Object element : this.myBuilder.getSelectedElements()) {
            if (!(element instanceof Library) || processor.process((Object)((Library)element))) continue;
            return false;
        }
        return true;
    }

    protected boolean acceptsElement(Object element) {
        return true;
    }

    protected JComponent createNorthPanel() {
        DefaultActionGroup group = new DefaultActionGroup();
        DefaultTreeExpander expander = new DefaultTreeExpander((JTree)this.myTree);
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        group.add(actionsManager.createExpandAllAction((TreeExpander)expander, (JComponent)this.myTree));
        group.add(actionsManager.createCollapseAllAction((TreeExpander)expander, (JComponent)this.myTree));
        JComponent component = ActionManager.getInstance().createActionToolbar("ProjectViewToolbar", (ActionGroup)group, true).getComponent();
        component.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.darkGray), component.getBorder()));
        return component;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myBuilder = new AbstractTreeBuilder((JTree)this.myTree, new DefaultTreeModel(new DefaultMutableTreeNode()), (AbstractTreeStructure)new MyStructure(ProjectManager.getInstance().getDefaultProject()), (Comparator)WeightBasedComparator.FULL_INSTANCE);
        this.myBuilder.initRootNode();
        this.myTree.setDragEnabled(false);
        this.myTree.getSelectionModel().setSelectionMode(0);
        this.myTree.setRowHeight(Icons.CLASS_ICON.getIconHeight());
        this.myTree.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        this.myTree.setRootVisible(false);
        this.myTree.getSelectionModel().setSelectionMode(2);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ChooseLibrariesDialog.this.updateOKAction();
            }
        });
        this.myTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                if (ChooseLibrariesDialog.this.isOKActionEnabled()) {
                    ChooseLibrariesDialog.this.doOKAction();
                }
            }
        });
        this.myTree.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "ENTER");
        this.myTree.getActionMap().put("ENTER", this.getOKAction());
        return ScrollPaneFactory.createScrollPane((JComponent)this.myTree);
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.myBuilder);
        super.dispose();
    }

    private class MyStructure
    extends AbstractTreeStructure {
        private final Project myProject;

        public MyStructure(Project project) {
            this.myProject = project;
        }

        public Object getRootElement() {
            return ApplicationManager.getApplication();
        }

        /*
         * WARNING - void declaration
         */
        public Object[] getChildElements(Object element) {
            ArrayList<Object> result = new ArrayList<Object>();
            if (element instanceof Application) {
                Collections.addAll(result, ProjectManager.getInstance().getOpenProjects());
                LibraryTablesRegistrar instance = LibraryTablesRegistrar.getInstance();
                result.add(instance.getLibraryTable());
                result.addAll(instance.getCustomLibraryTables());
            } else if (element instanceof Project) {
                Collections.addAll(result, ModuleManager.getInstance((Project)((Project)element)).getModules());
                result.add(LibraryTablesRegistrar.getInstance().getLibraryTable((Project)element));
            } else if (element instanceof LibraryTable) {
                Collections.addAll(result, ((LibraryTable)element).getLibraries());
            } else if (element instanceof Module) {
                void var5_7;
                OrderEntry[] arr$ = ModuleRootManager.getInstance((Module)((Module)element)).getOrderEntries();
                int len$ = arr$.length;
                boolean bl = false;
                while (var5_7 < len$) {
                    LibraryOrderEntry libraryOrderEntry;
                    OrderEntry entry = arr$[var5_7];
                    if (entry instanceof LibraryOrderEntry && "module".equals((libraryOrderEntry = (LibraryOrderEntry)entry).getLibraryLevel())) {
                        Library library = libraryOrderEntry.getLibrary();
                        result.add(library);
                    }
                    ++var5_7;
                }
            }
            Iterator it = result.iterator();
            while (it.hasNext()) {
                if (ChooseLibrariesDialog.this.acceptsElement(it.next())) continue;
                it.remove();
            }
            for (Object e : result) {
                ChooseLibrariesDialog.this.myLibraryMap.put(e, element);
            }
            return result.toArray();
        }

        public Object getParentElement(Object element) {
            if (element instanceof Application) {
                return null;
            }
            if (element instanceof Project) {
                return ApplicationManager.getApplication();
            }
            if (element instanceof Module) {
                return ((Module)element).getProject();
            }
            if (element instanceof LibraryTable) {
                return ChooseLibrariesDialog.this.myLibraryMap.get(element);
            }
            if (element instanceof Library) {
                return ChooseLibrariesDialog.this.myLibraryMap.get(element);
            }
            throw new AssertionError();
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
            MyNode myNode;
            if (element instanceof Application) {
                myNode = new RootDescriptor(this.myProject);
                if (myNode == null) throw new IllegalStateException("@NotNull method com/intellij/util/ui/classpath/ChooseLibrariesDialog$MyStructure.createDescriptor must not return null");
                return myNode;
            }
            if (element instanceof Project) {
                myNode = new ProjectDescriptor(this.myProject, (Project)element);
                if (myNode == null) throw new IllegalStateException("@NotNull method com/intellij/util/ui/classpath/ChooseLibrariesDialog$MyStructure.createDescriptor must not return null");
                return myNode;
            }
            if (element instanceof Module) {
                myNode = new ModuleDescriptor(this.myProject, parentDescriptor, (Module)element);
                if (myNode == null) throw new IllegalStateException("@NotNull method com/intellij/util/ui/classpath/ChooseLibrariesDialog$MyStructure.createDescriptor must not return null");
                return myNode;
            }
            if (element instanceof LibraryTable) {
                myNode = new NamedDescriptor(this.myProject, parentDescriptor, (LibraryTable)element, 0);
                if (myNode == null) throw new IllegalStateException("@NotNull method com/intellij/util/ui/classpath/ChooseLibrariesDialog$MyStructure.createDescriptor must not return null");
                return myNode;
            }
            if (!(element instanceof Library)) {
                throw new AssertionError();
            }
            myNode = new LibraryDescriptor(this.myProject, parentDescriptor, (Library)element);
            if (myNode != null) return myNode;
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/classpath/ChooseLibrariesDialog$MyStructure.createDescriptor must not return null");
        }

        public void commit() {
        }

        public boolean hasSomethingToCommit() {
            return false;
        }
    }

    private static class NamedDescriptor
    extends MyNode<LibraryTable> {
        private final int myWeight;

        protected NamedDescriptor(Project project, NodeDescriptor parentDescriptor, LibraryTable table, int weight) {
            super(project, parentDescriptor, table);
            this.myWeight = weight;
        }

        protected void doUpdate() {
            this.setIcons(Icons.DIRECTORY_CLOSED_ICON, Icons.DIRECTORY_OPEN_ICON);
            String nodeText = ((LibraryTable)this.getElement()).getPresentation().getDisplayName(true);
            this.setNodeText(StringUtil.isNotEmpty((String)nodeText) ? nodeText : "<unnamed>", null, false);
        }

        @Override
        public int getWeight() {
            return this.myWeight;
        }
    }

    private static class LibraryDescriptor
    extends MyNode<Library> {
        private final Icon myIcon;

        protected LibraryDescriptor(Project project, NodeDescriptor parentDescriptor, Library element) {
            super(project, parentDescriptor, element);
            SimpleColoredComponent coloredComponent = new SimpleColoredComponent();
            OrderEntryCellAppearanceUtils.forLibrary((Library)((Library)this.getElement())).customize(coloredComponent);
            this.myIcon = coloredComponent.getIcon();
        }

        protected void doUpdate() {
            this.setIcons(this.myIcon, this.myIcon);
            String nodeText = OrderEntryCellAppearanceUtils.forLibrary((Library)((Library)this.getElement())).getText();
            this.setNodeText(StringUtil.isNotEmpty((String)nodeText) ? nodeText : "<unnamed>", null, false);
        }
    }

    private static class ModuleDescriptor
    extends MyNode<Module> {
        protected ModuleDescriptor(Project project, NodeDescriptor parentDescriptor, Module element) {
            super(project, parentDescriptor, element);
        }

        protected void doUpdate() {
            this.setIcons(((Module)this.getElement()).getModuleType().getNodeIcon(false), ((Module)this.getElement()).getModuleType().getNodeIcon(true));
            String nodeText = ((Module)this.getElement()).getName();
            this.setNodeText(StringUtil.isNotEmpty((String)nodeText) ? nodeText : "<unnamed>", null, false);
        }

        @Override
        public int getWeight() {
            return 1;
        }
    }

    private static class ProjectDescriptor
    extends MyNode<Project> {
        protected ProjectDescriptor(Project project, Project element) {
            super(project, null, element);
        }

        protected void doUpdate() {
            this.setIcons(Icons.PROJECT_ICON, Icons.PROJECT_ICON);
            String nodeText = ((Project)this.getElement()).getName();
            this.setNodeText(StringUtil.isNotEmpty((String)nodeText) ? nodeText : "<unnamed>", null, false);
        }
    }

    private static class RootDescriptor
    extends MyNode<Object> {
        protected RootDescriptor(Project project) {
            super(project, null, ApplicationManager.getApplication());
        }
    }

    private static class MyNode<T>
    extends SimpleNode {
        private final T myElement;

        private MyNode(Project project, NodeDescriptor parentDescriptor, T element) {
            super(project, parentDescriptor);
            this.myElement = element;
        }

        public T getElement() {
            return this.myElement;
        }

        public SimpleNode[] getChildren() {
            return NO_CHILDREN;
        }

        public int getWeight() {
            return 0;
        }

        public Object[] getEqualityObjects() {
            return new Object[]{this.myElement};
        }
    }
}

