/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.caches.CacheUpdater;
import com.intellij.ide.caches.FileContent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CollectingContentIterator;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexingStamp;
import java.util.Collection;
import java.util.List;

public class UnindexedFilesUpdater
implements CacheUpdater {
    private final FileBasedIndex myIndex;
    private final Project myProject;

    public UnindexedFilesUpdater(Project project, FileBasedIndex index) {
        this.myIndex = index;
        this.myProject = project;
    }

    public int getNumberOfPendingUpdateJobs() {
        return this.myIndex.getNumberOfPendingInvalidations();
    }

    public VirtualFile[] queryNeededFiles() {
        CollectingContentIterator finder = this.myIndex.createContentIterator();
        FileBasedIndex.iterateIndexableFiles((ContentIterator)finder, this.myProject);
        List files = finder.getFiles();
        return VfsUtil.toVirtualFileArray((Collection)files);
    }

    public void processFile(FileContent fileContent) {
        this.myIndex.indexFileContent(this.myProject, fileContent);
        IndexingStamp.flushCache();
    }

    public void updatingDone() {
    }

    public void canceled() {
    }
}

