/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.util.Function;
import java.awt.event.ActionListener;

public class JavaReferenceEditorUtil {
    private JavaReferenceEditorUtil() {
    }

    public static ReferenceEditorWithBrowseButton createReferenceEditorWithBrowseButton(ActionListener browseActionListener, String text, final PsiManager manager, final boolean toAcceptClasses) {
        return new ReferenceEditorWithBrowseButton(browseActionListener, manager.getProject(), new Function<String, Document>(){

            public Document fun(String s) {
                return JavaReferenceEditorUtil.createDocument(s, manager, toAcceptClasses);
            }
        }, text);
    }

    public static Document createDocument(String text, PsiManager manager, boolean isClassesAccepted) {
        PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage("");
        PsiJavaCodeReferenceCodeFragment fragment = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createReferenceCodeFragment(text, (PsiElement)defaultPackage, true, isClassesAccepted);
        fragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
        return PsiDocumentManager.getInstance((Project)manager.getProject()).getDocument((PsiFile)fragment);
    }

    public static Document createTypeDocument(String text, PsiManager manager) {
        PsiPackage defaultPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage("");
        PsiTypeCodeFragment fragment = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createTypeCodeFragment(text, (PsiElement)defaultPackage, false, true, false);
        fragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
        return PsiDocumentManager.getInstance((Project)manager.getProject()).getDocument((PsiFile)fragment);
    }
}

