/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.Hint;
import com.intellij.ui.HintListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NotNull;

public class HeavyweightHint
implements Hint {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.LightweightHint");
    private final JComponent myComponent;
    private final boolean myFocusableWindowState;
    private final EventListenerList myListenerList;
    private JWindow myWindow;

    public HeavyweightHint(JComponent component) {
        this(component, true);
    }

    public HeavyweightHint(@NotNull JComponent component, boolean focusableWindowState) {
        if (component == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/HeavyweightHint.<init> must not be null");
        }
        this.myComponent = component;
        this.myFocusableWindowState = focusableWindowState;
        this.myListenerList = new EventListenerList();
    }

    @Override
    public void show(@NotNull JComponent parentComponent, int x, int y, JComponent focusBackComponent) {
        if (parentComponent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ui/HeavyweightHint.show must not be null");
        }
        Dimension preferredSize = this.myComponent.getPreferredSize();
        LOG.assertTrue(parentComponent.isShowing());
        Window windowAncestor = SwingUtilities.getWindowAncestor(parentComponent);
        LOG.assertTrue(windowAncestor != null);
        this.myWindow = new JWindow(windowAncestor);
        this.myWindow.setFocusableWindowState(this.myFocusableWindowState);
        Point locationOnScreen = parentComponent.getLocationOnScreen();
        this.myWindow.getContentPane().setLayout(new BorderLayout());
        this.myWindow.getContentPane().add((Component)this.myComponent, "Center");
        this.myWindow.setBounds(locationOnScreen.x + x, locationOnScreen.y + y, preferredSize.width, preferredSize.height);
        this.myWindow.pack();
        this.myWindow.setVisible(true);
    }

    protected void fireHintHidden() {
        EventListener[] listeners;
        for (EventListener listener1 : listeners = this.myListenerList.getListeners(HintListener.class)) {
            HintListener listener = (HintListener)listener1;
            listener.hintHidden(new EventObject(this));
        }
    }

    public Dimension getPreferredSize() {
        return this.myComponent.getPreferredSize();
    }

    @Override
    public boolean isVisible() {
        return this.myComponent.isShowing();
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    @Override
    public void hide() {
        if (this.myWindow != null) {
            this.myWindow.dispose();
            this.myWindow = null;
        }
        this.fireHintHidden();
    }

    @Override
    public void addHintListener(HintListener listener) {
        this.myListenerList.add(HintListener.class, listener);
    }

    @Override
    public void removeHintListener(HintListener listener) {
        this.myListenerList.remove(HintListener.class, listener);
    }
}

