/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.psi;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.psi.ArrayIterable;

public class SearchUtils {
    private SearchUtils() {
    }

    public static Iterable<PsiReference> findAllReferences(PsiElement element, SearchScope scope) {
        return new ArrayIterable<Object>(ReferencesSearch.search((PsiElement)element, (SearchScope)scope, (boolean)true).toArray((Object[])new PsiReference[0]));
    }

    public static Iterable<PsiReference> findAllReferences(PsiElement element) {
        return SearchUtils.findAllReferences(element, element.getUseScope());
    }

    public static Iterable<PsiMethod> findOverridingMethods(PsiMethod method) {
        return new ArrayIterable<Object>(OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)method.getUseScope(), (boolean)true).toArray((Object[])new PsiMethod[0]));
    }

    public static Iterable<PsiClass> findClassInheritors(PsiClass aClass, boolean deep) {
        return new ArrayIterable<Object>(ClassInheritorsSearch.search((PsiClass)aClass, (SearchScope)aClass.getUseScope(), (boolean)deep).toArray((Object[])new PsiClass[0]));
    }
}

