/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveInstanceMethod;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.makeStatic.MakeStaticHandler;
import com.intellij.refactoring.move.MoveInstanceMembersUtil;
import com.intellij.refactoring.move.moveInstanceMethod.MoveInstanceMethodDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveInstanceMethodHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveInstanceMethod.MoveInstanceMethodHandler");
    static final String REFACTORING_NAME = RefactoringBundle.message((String)"move.instance.method.title");

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/move/moveInstanceMethod/MoveInstanceMethodHandler.invoke must not be null");
        }
        PsiElement element = (PsiElement)LangDataKeys.PSI_ELEMENT.getData(dataContext);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        if (element == null) {
            element = file.findElementAt(editor.getCaretModel().getOffset());
        }
        if (element == null) {
            return;
        }
        if (element instanceof PsiIdentifier) {
            element = element.getParent();
        }
        if (!(element instanceof PsiMethod)) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.method"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.moveInstMethod");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Move Instance Method invoked");
        }
        this.invoke(project, new PsiElement[]{element}, dataContext);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/move/moveInstanceMethod/MoveInstanceMethodHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/move/moveInstanceMethod/MoveInstanceMethodHandler.invoke must not be null");
        }
        if (elements.length != 1 || !(elements[0] instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)elements[0];
        String message = null;
        if (method.isConstructor()) {
            message = RefactoringBundle.message((String)"move.method.is.not.supported.for.constructors");
        } else if (PsiUtil.typeParametersIterator((PsiTypeParameterListOwner)method.getContainingClass()).hasNext() && TypeParametersSearcher.hasTypeParameters((PsiElement)method)) {
            message = RefactoringBundle.message((String)"move.method.is.not.supported.for.generic.classes");
        } else if (method.findSuperMethods().length > 0 || ((PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)method.getUseScope(), (boolean)true).toArray((Object[])PsiMethod.EMPTY_ARRAY)).length > 0) {
            message = RefactoringBundle.message((String)"move.method.is.not.supported.when.method.is.part.of.inheritance.hierarchy");
        } else {
            Set<PsiClass> classes = MoveInstanceMembersUtil.getThisClassesToMembers((PsiMember)method).keySet();
            for (PsiClass aClass : classes) {
                if (!(aClass instanceof JspClass)) continue;
                message = RefactoringBundle.message((String)"synthetic.jsp.class.is.referenced.in.the.method");
                Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)REFACTORING_NAME, (String)"refactoring.moveInstMethod");
                break;
            }
        }
        if (message != null) {
            MoveInstanceMethodHandler.showErrorHint(project, dataContext, message);
            return;
        }
        ArrayList<PsiVariable> suitableVariables = new ArrayList<PsiVariable>();
        message = MoveInstanceMethodHandler.collectSuitableVariables(method, suitableVariables);
        if (message != null) {
            String unableToMakeStaticMessage = MakeStaticHandler.validateTarget((PsiTypeParameterListOwner)method);
            if (unableToMakeStaticMessage != null) {
                MoveInstanceMethodHandler.showErrorHint(project, dataContext, message);
            } else {
                String suggestToMakeStaticMessage = "Would you like to make method '" + method.getName() + "' static and then move?";
                if (Messages.showYesNoCancelDialog((Project)project, (String)(message + ". " + suggestToMakeStaticMessage), (String)REFACTORING_NAME, (Icon)Messages.getErrorIcon()) == 0) {
                    MakeStaticHandler.invoke((PsiTypeParameterListOwner)method);
                }
            }
            return;
        }
        new MoveInstanceMethodDialog(method, suitableVariables.toArray(new PsiVariable[suitableVariables.size()])).show();
    }

    private static void showErrorHint(Project project, DataContext dataContext, String message) {
        Editor editor = dataContext == null ? null : (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)message), (String)REFACTORING_NAME, (String)"refactoring.moveInstMethod");
    }

    @Nullable
    private static String collectSuitableVariables(PsiMethod method, List<PsiVariable> suitableVariables) {
        ArrayList<Object> allVariables = new ArrayList<Object>();
        allVariables.addAll(Arrays.asList(method.getParameterList().getParameters()));
        allVariables.addAll(Arrays.asList(method.getContainingClass().getFields()));
        boolean classTypesFound = false;
        boolean resolvableClassesFound = false;
        boolean classesInProjectFound = false;
        for (PsiVariable psiVariable : allVariables) {
            PsiType type = psiVariable.getType();
            if (!(type instanceof PsiClassType) || ((PsiClassType)type).hasParameters()) continue;
            classTypesFound = true;
            PsiClass psiClass = ((PsiClassType)type).resolve();
            if (psiClass == null || psiClass instanceof PsiTypeParameter) continue;
            resolvableClassesFound = true;
            boolean inProject = method.getManager().isInProject((PsiElement)psiClass);
            if (!inProject) continue;
            classesInProjectFound = true;
            suitableVariables.add(psiVariable);
        }
        if (suitableVariables.isEmpty()) {
            if (!classTypesFound) {
                return RefactoringBundle.message((String)"there.are.no.variables.that.have.reference.type");
            }
            if (!resolvableClassesFound) {
                return RefactoringBundle.message((String)"all.candidate.variables.have.unknown.types");
            }
            if (!classesInProjectFound) {
                return RefactoringBundle.message((String)"all.candidate.variables.have.types.not.in.project");
            }
        }
        return null;
    }

    public static String suggestParameterNameForThisClass(PsiClass thisClass) {
        PsiManager manager = thisClass.getManager();
        PsiClassType type = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory().createType(thisClass);
        SuggestedNameInfo suggestedNameInfo = JavaCodeStyleManager.getInstance((Project)manager.getProject()).suggestVariableName(VariableKind.PARAMETER, null, null, (PsiType)type);
        return suggestedNameInfo.names.length > 0 ? suggestedNameInfo.names[0] : "";
    }

    public static Map<PsiClass, String> suggestParameterNames(PsiMethod method, PsiVariable targetVariable) {
        Map<PsiClass, Set<PsiMember>> classesToMembers = MoveInstanceMembersUtil.getThisClassesToMembers((PsiMember)method);
        LinkedHashMap<PsiClass, String> result = new LinkedHashMap<PsiClass, String>();
        for (Map.Entry<PsiClass, Set<PsiMember>> entry : classesToMembers.entrySet()) {
            PsiClass aClass = entry.getKey();
            Set<PsiMember> members = entry.getValue();
            if (members.size() == 1 && members.contains(targetVariable)) continue;
            result.put(aClass, MoveInstanceMethodHandler.suggestParameterNameForThisClass(aClass));
        }
        return result;
    }

    private static class TypeParametersSearcher
    extends PsiTypeVisitor<Boolean> {
        private TypeParametersSearcher() {
        }

        public static boolean hasTypeParameters(PsiElement element) {
            final TypeParametersSearcher searcher = new TypeParametersSearcher();
            final boolean[] hasParameters = new boolean[]{false};
            element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitTypeElement(PsiTypeElement type) {
                    super.visitTypeElement(type);
                    hasParameters[0] = hasParameters[0] | (Boolean)type.getType().accept((PsiTypeVisitor)searcher);
                }
            });
            return hasParameters[0];
        }

        public Boolean visitClassType(PsiClassType classType) {
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)classType);
            if (psiClass instanceof PsiTypeParameter) {
                return Boolean.TRUE;
            }
            return (Boolean)super.visitClassType(classType);
        }

        public Boolean visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            if (PsiUtil.resolveClassInType((PsiType)bound) instanceof PsiTypeParameter) {
                return Boolean.TRUE;
            }
            return (Boolean)super.visitWildcardType(wildcardType);
        }

        public Boolean visitType(PsiType type) {
            return Boolean.FALSE;
        }
    }
}

