/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTFactory;
import com.intellij.lexer.FilterLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.Navigatable;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.parsing.xml.OldXmlParsing;
import com.intellij.psi.impl.source.parsing.xml.XmlParsingContext;
import com.intellij.psi.impl.source.parsing.xml.XmlPsiLexer;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URIReferenceProvider;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.impl.source.xml.XmlTokenImpl;
import com.intellij.psi.tree.xml.IXmlLeafElementType;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlUtil;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlEntityDeclImpl
extends XmlElementImpl
implements XmlEntityDecl,
XmlElementType {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.xml.XmlEntityDeclImpl");

    public XmlEntityDeclImpl() {
        super(XML_ENTITY_DECL);
    }

    public PsiElement getNameElement() {
        for (TreeElement e = this.getFirstChildNode(); e != null; e = e.getTreeNext()) {
            XmlTokenImpl xmlToken;
            if (!(e instanceof XmlTokenImpl) || (xmlToken = (XmlTokenImpl)e).getTokenType() != XmlTokenType.XML_NAME) continue;
            return xmlToken;
        }
        return null;
    }

    public XmlAttributeValue getValueElement() {
        if (this.isInternalReference()) {
            for (TreeElement e = this.getFirstChildNode(); e != null; e = e.getTreeNext()) {
                if (e.getElementType() != XmlElementType.XML_ATTRIBUTE_VALUE) continue;
                return (XmlAttributeValue)SourceTreeToPsiMap.treeElementToPsi(e);
            }
        } else {
            for (TreeElement e = this.getLastChildNode(); e != null; e = e.getTreePrev()) {
                if (e.getElementType() != XmlElementType.XML_ATTRIBUTE_VALUE) continue;
                return (XmlAttributeValue)SourceTreeToPsiMap.treeElementToPsi(e);
            }
        }
        return null;
    }

    @Override
    public String getName() {
        PsiElement nameElement = this.getNameElement();
        return nameElement != null ? nameElement.getText() : "";
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/xml/XmlEntityDeclImpl.setName must not be null");
        }
        PsiElement nameElement = this.getNameElement();
        if (nameElement != null) {
            return ElementManipulators.getManipulator((PsiElement)nameElement).handleContentChange(nameElement, new TextRange(0, nameElement.getTextLength()), name);
        }
        return null;
    }

    public PsiElement parse(PsiFile baseFile, int context, XmlEntityRef originalElement) {
        PsiElement dependsOnElement = this.getValueElement(baseFile);
        String value = null;
        if (dependsOnElement instanceof XmlAttributeValue) {
            XmlAttributeValue attributeValue = (XmlAttributeValue)dependsOnElement;
            value = attributeValue.getValue();
        } else if (dependsOnElement instanceof PsiFile) {
            PsiFile file = (PsiFile)dependsOnElement;
            value = file.getText();
        }
        if (value == null) {
            return null;
        }
        FileElement holderElement = DummyHolderFactory.createHolder(originalElement.getManager(), (PsiElement)originalElement).getTreeElement();
        Lexer lexer = XmlEntityDeclImpl.getLexer(context, value);
        XmlParsingContext parsingContext = new XmlParsingContext(holderElement.getCharTable());
        CompositeElement element = ASTFactory.composite(XML_ELEMENT_DECL);
        holderElement.rawAddChildren(element);
        switch (context) {
            default: {
                LOG.error("Entity: " + this.getName() + " context: " + context);
                return null;
            }
            case 1: {
                parsingContext.getXmlParsing().parseElementContentSpec(element, lexer);
                PsiElement generated = SourceTreeToPsiMap.treeElementToPsi(element).getFirstChild().getFirstChild();
                this.setDependsOnElement(generated, dependsOnElement);
                return this.setOriginalElement(generated, (PsiElement)originalElement);
            }
            case 2: {
                parsingContext.getXmlParsing().parseAttributeContentSpec(element, lexer);
                PsiElement generated = SourceTreeToPsiMap.treeElementToPsi(element).getFirstChild();
                this.setDependsOnElement(generated, dependsOnElement);
                return this.setOriginalElement(generated, (PsiElement)originalElement);
            }
            case 3: {
                parsingContext.getXmlParsing().parseAttlistContent(element, lexer);
                PsiElement generated = SourceTreeToPsiMap.treeElementToPsi(element).getFirstChild();
                this.setDependsOnElement(generated, dependsOnElement);
                return this.setOriginalElement(generated, (PsiElement)originalElement);
            }
            case 7: {
                parsingContext.getXmlParsing().parseAttrValue(element, lexer);
                PsiElement generated = SourceTreeToPsiMap.treeElementToPsi(element).getFirstChild();
                this.setDependsOnElement(generated, dependsOnElement);
                return this.setOriginalElement(generated, (PsiElement)originalElement);
            }
            case 4: {
                parsingContext.getXmlParsing().parseEntityDeclContent(element, lexer);
                PsiElement generated = SourceTreeToPsiMap.treeElementToPsi(element).getFirstChild();
                this.setDependsOnElement(generated, dependsOnElement);
                return this.setOriginalElement(generated, (PsiElement)originalElement);
            }
            case 5: {
                HashSet<String> names = new HashSet<String>();
                for (XmlEntityRef parent = originalElement; parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof XmlTag)) continue;
                    names.add(((XmlTag)parent).getName());
                }
                parsingContext.getXmlParsing().parseGenericXml(lexer, element, names);
                PsiElement generated = SourceTreeToPsiMap.treeElementToPsi(element).getFirstChild();
                this.setDependsOnElement(generated, dependsOnElement);
                return this.setOriginalElement(generated, (PsiElement)originalElement);
            }
            case 6: 
        }
        parsingContext.getXmlParsing().parseEnumeratedTypeContent(element, lexer);
        PsiElement generated = SourceTreeToPsiMap.treeElementToPsi(element).getFirstChild();
        this.setDependsOnElement(generated, dependsOnElement);
        return this.setOriginalElement(generated, (PsiElement)originalElement);
    }

    private PsiElement setDependsOnElement(PsiElement generated, PsiElement dependsOnElement) {
        for (PsiElement e = generated; e != null; e = e.getNextSibling()) {
            e.putUserData(XmlElement.DEPENDING_ELEMENT, (Object)dependsOnElement);
        }
        return generated;
    }

    private PsiElement setOriginalElement(PsiElement element, PsiElement valueElement) {
        for (PsiElement e = element; e != null; e = e.getNextSibling()) {
            e.putUserData(XmlElement.INCLUDING_ELEMENT, (Object)((XmlElement)valueElement));
        }
        return element;
    }

    public static Lexer getLexer(int context, CharSequence buffer) {
        XmlPsiLexer lexer = new XmlPsiLexer();
        FilterLexer filterLexer = new FilterLexer((Lexer)lexer, (FilterLexer.Filter)new FilterLexer.SetFilter(OldXmlParsing.XML_WHITE_SPACE_OR_COMMENT_BIT_SET));
        int state = 0;
        switch (context) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                state = 15;
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            default: {
                LOG.error("context: " + context);
            }
        }
        filterLexer.start(buffer, 0, buffer.length(), state);
        return filterLexer;
    }

    @Nullable
    private PsiElement getValueElement(PsiFile baseFile) {
        String value;
        XmlAttributeValue attributeValue = this.getValueElement();
        if (this.isInternalReference()) {
            return attributeValue;
        }
        if (attributeValue != null && (value = attributeValue.getValue()) != null) {
            XmlFile xmlFile = XmlUtil.findNamespaceByLocation(baseFile, value);
            if (xmlFile != null) {
                return xmlFile;
            }
            int i = URIReferenceProvider.getPrefixLength(value);
            if (i > 0) {
                return XmlUtil.findNamespaceByLocation(baseFile, value.substring(i));
            }
        }
        return null;
    }

    public boolean isInternalReference() {
        for (TreeElement e = this.getFirstChildNode(); e != null; e = e.getTreeNext()) {
            XmlToken token;
            if (!(e.getElementType() instanceof IXmlLeafElementType) || (token = (XmlToken)SourceTreeToPsiMap.treeElementToPsi(e)).getTokenType() != XmlTokenType.XML_DOCTYPE_PUBLIC && token.getTokenType() != XmlTokenType.XML_DOCTYPE_SYSTEM) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement psiElement = this.getNameElement();
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/xml/XmlEntityDeclImpl.getNavigationElement must not return null");
        }
        return psiElement;
    }

    @Override
    public int getTextOffset() {
        PsiElement name = this.getNameElement();
        return name != null ? name.getTextOffset() : super.getTextOffset();
    }

    @Override
    public boolean canNavigate() {
        if (this.isPhysical()) {
            return super.canNavigate();
        }
        PsiNamedElement psiNamedElement = XmlUtil.findRealNamedElement((PsiNamedElement)this);
        return psiNamedElement != null;
    }

    @Override
    public void navigate(boolean requestFocus) {
        if (!this.isPhysical()) {
            ((Navigatable)XmlUtil.findRealNamedElement((PsiNamedElement)this)).navigate(requestFocus);
            return;
        }
        super.navigate(requestFocus);
    }
}

