/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.util.containers.MostlySingularMultiMap;

public class ClassCollectingProcessor
extends BaseScopeProcessor
implements ElementClassHint {
    private final MostlySingularMultiMap<String, ResultWithContext> myResult = new MostlySingularMultiMap();
    private PsiElement myCurrentFileContext = null;

    @Override
    public <T> T getHint(Key<T> hintKey) {
        if (hintKey == KEY) {
            return (T)this;
        }
        return null;
    }

    @Override
    public void handleEvent(PsiScopeProcessor.Event event, Object associated) {
        if (event == JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT) {
            this.myCurrentFileContext = (PsiElement)associated;
        }
    }

    public boolean execute(PsiElement element, ResolveState state) {
        PsiNamedElement named;
        String name;
        if (element instanceof PsiNamedElement && (name = (named = (PsiNamedElement)element).getName()) != null) {
            this.myResult.add((Object)name, (Object)new ResultWithContext(named, this.myCurrentFileContext));
        }
        return true;
    }

    @Override
    public boolean shouldProcess(ElementClassHint.DeclaractionKind kind) {
        return kind == ElementClassHint.DeclaractionKind.CLASS || kind == ElementClassHint.DeclaractionKind.PACKAGE || kind == ElementClassHint.DeclaractionKind.METHOD || kind == ElementClassHint.DeclaractionKind.FIELD;
    }

    public MostlySingularMultiMap<String, ResultWithContext> getResults() {
        return this.myResult;
    }

    public static class ResultWithContext {
        private final PsiNamedElement myElement;
        private final PsiElement myFileContext;

        public ResultWithContext(PsiNamedElement element, PsiElement fileContext) {
            this.myElement = element;
            this.myFileContext = fileContext;
        }

        public PsiNamedElement getElement() {
            return this.myElement;
        }

        public PsiElement getFileContext() {
            return this.myFileContext;
        }
    }
}

