/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.FocusTrackback;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeFrameImpl
extends JFrame
implements IdeFrame,
DataProvider {
    private String myTitle;
    private String myFileTitle;
    private File myCurrentFile;
    private Project myProject;
    private final LayoutFocusTraversalPolicyExt myLayoutFocusTraversalPolicy;
    private IdeRootPane myRootPane;
    private BalloonLayout myBalloonLayout;

    public IdeFrameImpl(ApplicationInfoEx applicationInfoEx, ActionManager actionManager, UISettings uiSettings, DataManager dataManager, KeymapManager keymapManager, Application application, String[] commandLineArgs) {
        super(applicationInfoEx.getFullApplicationName());
        this.myRootPane = new IdeRootPane(actionManager, uiSettings, dataManager, keymapManager, application, commandLineArgs);
        this.setRootPane(this.myRootPane);
        AppUIUtil.updateFrameIcon(this);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(10, 10, screenSize.width - 20, screenSize.height - 40);
        this.myLayoutFocusTraversalPolicy = new LayoutFocusTraversalPolicyExt();
        this.setFocusTraversalPolicy(this.myLayoutFocusTraversalPolicy);
        this.setupCloseAction();
        new MnemonicHelper().register((Component)this);
        this.myBalloonLayout = new BalloonLayout(this.myRootPane.getLayeredPane(), new Insets(8, 8, 8, 8));
        if (!Registry.is((String)"ide.windowSystem.focusAppOnStartup") && !this.isThereActiveFrame()) {
            this.setFocusableWindowState(false);
        }
    }

    private boolean isThereActiveFrame() {
        Frame[] all;
        for (Frame each : all = Frame.getFrames()) {
            if (!each.isActive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void show() {
        super.show();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IdeFrameImpl.this.setFocusableWindowState(true);
            }
        });
    }

    public final void setDefaultFocusableComponent(JComponent component) {
        LayoutFocusTraversalPolicyExt.setOverridenDefaultComponent(component);
    }

    @Override
    public synchronized void setMaximizedBounds(Rectangle bounds) {
        super.setMaximizedBounds(null);
    }

    private void setupCloseAction() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                final Application app = ApplicationManager.getApplication();
                app.invokeLater((Runnable)new DumbAwareRunnable(){

                    public void run() {
                        if (app.isDisposed()) {
                            ApplicationManagerEx.getApplicationEx().exit();
                            return;
                        }
                        Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
                        if (openProjects.length > 1) {
                            if (IdeFrameImpl.this.myProject != null && IdeFrameImpl.this.myProject.isOpen()) {
                                ProjectUtil.closeProject(IdeFrameImpl.this.myProject);
                            }
                            ((AppLifecycleListener)app.getMessageBus().syncPublisher(AppLifecycleListener.TOPIC)).projectFrameClosed();
                        } else {
                            ApplicationManagerEx.getApplicationEx().exit();
                        }
                    }
                }, ModalityState.NON_MODAL);
            }
        });
    }

    public StatusBarEx getStatusBar() {
        return ((IdeRootPane)this.getRootPane()).getStatusBar();
    }

    public void updateToolbar() {
        ((IdeRootPane)this.getRootPane()).updateToolbar();
    }

    public void updateMenuBar() {
        ((IdeRootPane)this.getRootPane()).updateMainMenuActions();
    }

    @Override
    public void setTitle(String title) {
        this.myTitle = title;
        this.updateTitle();
    }

    private void setFrameTitle(String text) {
        super.setTitle(text);
    }

    public void setFileTitle(String fileTitle) {
        this.setFileTitle(fileTitle, null);
    }

    public void setFileTitle(@Nullable String fileTitle, @Nullable File file) {
        this.myFileTitle = fileTitle;
        this.myCurrentFile = file;
        this.updateTitle();
    }

    private void updateTitle() {
        StringBuilder sb = new StringBuilder();
        if (this.myTitle != null && this.myTitle.length() > 0) {
            sb.append(this.myTitle);
            sb.append(" - ");
        }
        if (this.myFileTitle != null && this.myFileTitle.length() > 0) {
            sb.append(this.myFileTitle);
            sb.append(" - ");
        }
        this.getRootPane().putClientProperty("Window.documentFile", this.myCurrentFile);
        sb.append(((ApplicationInfoEx)ApplicationInfo.getInstance()).getFullApplicationName());
        this.setFrameTitle(sb.toString());
    }

    public Object getData(String dataId) {
        if (PlatformDataKeys.PROJECT.is(dataId) && this.myProject != null) {
            return this.myProject.isInitialized() ? this.myProject : null;
        }
        return null;
    }

    public void setProject(Project project) {
        this.getStatusBar().cleanupCustomComponents();
        this.myProject = project;
        if (project != null) {
            if (this.myRootPane != null) {
                this.myRootPane.installNorthComponents(project);
            }
        } else if (this.myRootPane != null) {
            this.myRootPane.deinstallNorthComponents();
        }
        if (project == null) {
            FocusTrackback.release(this);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    @Override
    public void dispose() {
        if (this.myRootPane != null) {
            this.myRootPane = null;
        }
        super.dispose();
    }

    @Override
    public void paint(Graphics g) {
        UIUtil.applyRenderingHints((Graphics)g);
        super.paint(g);
    }

    public Rectangle suggestChildFrameBounds() {
        Rectangle b = this.getBounds();
        b.x += 100;
        b.width -= 200;
        b.y += 100;
        b.height -= 200;
        return b;
    }

    @Nullable
    public static Component findNearestModalComponent(@NotNull Component c) {
        if (c == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/wm/impl/IdeFrameImpl.findNearestModalComponent must not be null");
        }
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            if (eachParent instanceof IdeFrameImpl) {
                return eachParent;
            }
            if (!(eachParent instanceof JDialog) || !((JDialog)eachParent).isModal()) continue;
            return eachParent;
        }
        return null;
    }

    public final BalloonLayout getBalloonLayout() {
        return this.myBalloonLayout;
    }
}

