/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.readOnlyHandler;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vcs.readOnlyHandler.FileInfo;
import com.intellij.openapi.vcs.readOnlyHandler.HandleType;
import com.intellij.openapi.vcs.readOnlyHandler.ReadOnlyStatusDialog;
import com.intellij.openapi.vcs.readOnlyHandler.WritingAccessProvider;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="ReadonlyStatusHandler", storages={@Storage(id="other", file="$WORKSPACE_FILE$")})
public class ReadonlyStatusHandlerImpl
extends ReadonlyStatusHandler
implements PersistentStateComponent<State> {
    private final Project myProject;
    private final WritingAccessProvider[] myAccessProviders;
    private State myState = new State();

    public ReadonlyStatusHandlerImpl(Project project) {
        this.myProject = project;
        this.myAccessProviders = (WritingAccessProvider[])Extensions.getExtensions(WritingAccessProvider.EP_NAME, (AreaInstance)project);
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(State state) {
        this.myState = state;
    }

    /*
     * WARNING - void declaration
     */
    public ReadonlyStatusHandler.OperationStatus ensureFilesWritable(VirtualFile ... files) {
        if (files == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vcs/readOnlyHandler/ReadonlyStatusHandlerImpl.ensureFilesWritable must not be null");
        }
        if (files.length == 0) {
            return new OperationStatusImpl(VirtualFile.EMPTY_ARRAY);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        THashSet realFiles = new THashSet(files.length);
        for (VirtualFile virtualFile : files) {
            void var6_8;
            if (virtualFile instanceof VirtualFileWindow) {
                VirtualFile virtualFile2 = ((VirtualFileWindow)virtualFile).getDelegate();
            }
            if (var6_8 == null) continue;
            realFiles.add(var6_8);
        }
        files = VfsUtil.toVirtualFileArray((Collection)realFiles);
        for (WritingAccessProvider writingAccessProvider : this.myAccessProviders) {
            Collection<VirtualFile> denied = writingAccessProvider.requestWriting(files);
            if (denied.isEmpty()) continue;
            return new OperationStatusImpl(VfsUtil.toVirtualFileArray(denied));
        }
        FileInfo[] fileInfoArray = this.createFileInfos(files);
        if (fileInfoArray.length == 0) {
            return ReadonlyStatusHandlerImpl.createResultStatus(files);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return ReadonlyStatusHandlerImpl.createResultStatus(files);
        }
        int savedEventCount = IdeEventQueue.getInstance().getEventCount();
        if (this.myState.SHOW_DIALOG) {
            new ReadOnlyStatusDialog(this.myProject, fileInfoArray).show();
        } else {
            ReadonlyStatusHandlerImpl.processFiles(new ArrayList<FileInfo>(Arrays.asList(fileInfoArray)));
        }
        IdeEventQueue.getInstance().setEventCount(savedEventCount);
        return ReadonlyStatusHandlerImpl.createResultStatus(files);
    }

    private static ReadonlyStatusHandler.OperationStatus createResultStatus(VirtualFile[] files) {
        ArrayList<VirtualFile> readOnlyFiles = new ArrayList<VirtualFile>();
        for (VirtualFile file : files) {
            if (!file.exists() || file.isWritable()) continue;
            readOnlyFiles.add(file);
        }
        return new OperationStatusImpl(VfsUtil.toVirtualFileArray(readOnlyFiles));
    }

    private FileInfo[] createFileInfos(VirtualFile[] files) {
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        for (VirtualFile file : files) {
            if (file == null || file.isWritable() || !file.isInLocalFileSystem()) continue;
            fileInfos.add(new FileInfo(file, this.myProject));
        }
        return fileInfos.toArray(new FileInfo[fileInfos.size()]);
    }

    public static void processFiles(List<FileInfo> fileInfos) {
        FileInfo[] copy = fileInfos.toArray(new FileInfo[fileInfos.size()]);
        MultiValuesMap handleTypeToFile = new MultiValuesMap();
        for (FileInfo fileInfo : copy) {
            handleTypeToFile.put((Object)fileInfo.getSelectedHandleType(), (Object)fileInfo.getFile());
        }
        for (HandleType handleType : handleTypeToFile.keySet()) {
            handleType.processFiles(handleTypeToFile.get((Object)handleType));
        }
        for (FileInfo fileInfo : copy) {
            if (fileInfo.getFile().exists() && !fileInfo.getFile().isWritable()) continue;
            fileInfos.remove(fileInfo);
        }
    }

    private static class OperationStatusImpl
    extends ReadonlyStatusHandler.OperationStatus {
        private final VirtualFile[] myReadonlyFiles;

        OperationStatusImpl(VirtualFile[] readonlyFiles) {
            this.myReadonlyFiles = readonlyFiles;
        }

        @NotNull
        public VirtualFile[] getReadonlyFiles() {
            if (this.myReadonlyFiles == null) {
                throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/readOnlyHandler/ReadonlyStatusHandlerImpl$OperationStatusImpl.getReadonlyFiles must not return null");
            }
            return this.myReadonlyFiles;
        }

        public boolean hasReadonlyFiles() {
            return this.myReadonlyFiles.length > 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NotNull
        public String getReadonlyFilesMessage() {
            String string;
            if (!this.hasReadonlyFiles()) {
                throw new RuntimeException("No readonly files");
            }
            StringBuffer buf = new StringBuffer();
            if (this.myReadonlyFiles.length > 1) {
                for (VirtualFile file : this.myReadonlyFiles) {
                    buf.append('\n');
                    buf.append(file.getPresentableUrl());
                }
                string = CommonBundle.message((String)"failed.to.make.the.following.files.writable.error.message", (Object[])new Object[]{buf.toString()});
                if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/readOnlyHandler/ReadonlyStatusHandlerImpl$OperationStatusImpl.getReadonlyFilesMessage must not return null");
                return string;
            }
            string = CommonBundle.message((String)"failed.to.make.file.writeable.error.message", (Object[])new Object[]{this.myReadonlyFiles[0].getPresentableUrl()});
            if (string != null) return string;
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vcs/readOnlyHandler/ReadonlyStatusHandlerImpl$OperationStatusImpl.getReadonlyFilesMessage must not return null");
        }
    }

    public static class State {
        public boolean SHOW_DIALOG = true;
    }
}

