/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.ui.ColorChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.Nullable;

public class RegistryUi
implements Disposable {
    private JTable myTable;
    private JTextArea myDescriptionLabel;
    private JPanel myContent = new JPanel();
    private static final Icon RESTART_ICON = IconLoader.getIcon((String)"/gutter/check.png");
    private RestoreDefaultsAction myRestoreDefaultsAction;
    private MyTableModel myModel;
    private static final Map<Color, Icon> icons_cache = new HashMap<Color, Icon>();

    public RegistryUi() {
        this.myContent.setLayout(new BorderLayout());
        this.myModel = new MyTableModel();
        this.myTable = new JTable(this.myModel);
        MyRenderer r = new MyRenderer();
        TableColumn c0 = this.myTable.getColumnModel().getColumn(0);
        c0.setCellRenderer(r);
        c0.setMaxWidth(RESTART_ICON.getIconWidth() + 12);
        c0.setMinWidth(RESTART_ICON.getIconWidth() + 12);
        c0.setHeaderValue(null);
        TableColumn c1 = this.myTable.getColumnModel().getColumn(1);
        c1.setCellRenderer(r);
        c1.setHeaderValue("Key");
        TableColumn c2 = this.myTable.getColumnModel().getColumn(2);
        c2.setCellRenderer(r);
        c2.setHeaderValue("Value");
        c2.setCellEditor(new MyEditor());
        this.myDescriptionLabel = new JTextArea(3, 50);
        this.myDescriptionLabel.setEditable(false);
        JScrollPane label = new JScrollPane(this.myDescriptionLabel);
        label.setBorder(new TitledBorder("Description"));
        this.myContent.add((Component)new JScrollPane(this.myTable), "Center");
        this.myContent.add((Component)label, "South");
        this.myTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int selected = RegistryUi.this.myTable.getSelectedRow();
                if (selected != -1) {
                    RegistryValue value = (RegistryValue)RegistryUi.this.myTable.getModel().getValueAt(selected, 0);
                    String desc = value.getDescription();
                    if (value.isRestartRequired()) {
                        String required = "Requires IDE restart.";
                        desc = desc.endsWith(".") ? desc + required : desc + ". " + required;
                    }
                    RegistryUi.this.myDescriptionLabel.setText(desc);
                } else {
                    RegistryUi.this.myDescriptionLabel.setText(null);
                }
            }
        });
        this.myRestoreDefaultsAction = new RestoreDefaultsAction();
        DefaultActionGroup tbGroup = new DefaultActionGroup();
        tbGroup.add((AnAction)new EditAction());
        tbGroup.add((AnAction)new RevertAction());
        ActionToolbar tb = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)tbGroup, true);
        tb.setTargetComponent((JComponent)this.myTable);
        this.myContent.add((Component)tb.getComponent(), "North");
    }

    private void startEditingAtSelection() {
        this.myTable.editCellAt(this.myTable.getSelectedRow(), 2);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (RegistryUi.this.myTable.isEditing()) {
                    RegistryUi.this.myTable.getEditorComponent().requestFocus();
                }
            }
        });
    }

    public void show() {
        DialogWrapper dialog = new DialogWrapper(true){
            {
                this.setTitle("Registry");
                this.setModal(true);
                this.init();
                RegistryUi.this.revaliateActions();
            }

            protected JComponent createCenterPanel() {
                return RegistryUi.this.myContent;
            }

            protected void dispose() {
                super.dispose();
                RegistryUi.this.dispose();
            }

            protected String getDimensionServiceKey() {
                return "Registry";
            }

            public JComponent getPreferredFocusedComponent() {
                return RegistryUi.this.myTable;
            }

            protected Action[] createActions() {
                return new Action[]{RegistryUi.this.myRestoreDefaultsAction, new AbstractAction("Close"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RegistryUi.this.processClose();
                        this.doOKAction();
                    }
                }};
            }
        };
        dialog.show();
    }

    private void processClose() {
        if (Registry.getInstance().isRestartNeeded()) {
            final ApplicationEx app = (ApplicationEx)ApplicationManager.getApplication();
            ApplicationInfo info = ApplicationInfo.getInstance();
            int r = Messages.showDialog((Component)this.myContent, (String)("You need to restart " + info.getVersionName() + " for the changes to take effect"), (String)"Restart Required", (String[])new String[]{app.isRestartCapable() ? "Restart Now" : "Shutdown Now", app.isRestartCapable() ? "Restart Later" : "Shutdown Later"}, (int)0, (Icon)Messages.getQuestionIcon());
            if (r == 0) {
                LaterInvocator.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (app.isRestartCapable()) {
                            app.restart();
                        } else {
                            app.exit(true);
                        }
                    }
                }, ModalityState.NON_MODAL);
            }
        }
    }

    private void restoreDefaults() {
        int r = Messages.showYesNoDialog((Component)this.myContent, (String)"Are you sure you want to revert registry settings to default values?", (String)"Revert To Defaults", (Icon)Messages.getQuestionIcon());
        if (r == 0) {
            Registry.getInstance().restoreDefaults();
            this.myModel.fireChanged();
            this.revaliateActions();
        }
    }

    private void revaliateActions() {
        this.myRestoreDefaultsAction.setEnabled(!Registry.getInstance().isInDefaultState());
    }

    public void dispose() {
    }

    private static Icon createColoredIcon(Color color) {
        Icon icon = icons_cache.get(color);
        if (icon != null) {
            return icon;
        }
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(16, 16, 3);
        Graphics g = image.getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, 16, 16);
        g.dispose();
        icon = new ImageIcon(image);
        icons_cache.put(color, icon);
        return icon;
    }

    private class RestoreDefaultsAction
    extends AbstractAction {
        public RestoreDefaultsAction() {
            super("Restore Defaults");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RegistryUi.this.restoreDefaults();
        }
    }

    private class MyEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JTextField myField = new JTextField();
        private RegistryValue myValue;

        private MyEditor() {
        }

        @Override
        @Nullable
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.myValue = (RegistryValue)value;
            if (this.myValue.asColor(null) == null) {
                this.myField.setText(this.myValue.asString());
                this.myField.selectAll();
                this.myField.setBorder(null);
                return this.myField;
            }
            Color color = ColorChooser.chooseColor((Component)table, (String)"Chose color", (Color)((RegistryValue)value).asColor(Color.WHITE));
            if (color != null) {
                this.myValue.setValue(color.getRed() + "," + color.getGreen() + "," + color.getBlue());
            }
            return null;
        }

        @Override
        public boolean stopCellEditing() {
            if (this.myValue != null) {
                this.myValue.setValue(this.myField.getText().trim());
            }
            RegistryUi.this.revaliateActions();
            return super.stopCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            return this.myValue;
        }
    }

    private static class MyRenderer
    implements TableCellRenderer {
        private JLabel myLabel = new JLabel();

        private MyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            RegistryValue v = (RegistryValue)value;
            this.myLabel.setIcon(null);
            this.myLabel.setText(null);
            this.myLabel.setHorizontalAlignment(2);
            if (v != null) {
                switch (column) {
                    case 0: {
                        this.myLabel.setIcon(v.isRestartRequired() ? RESTART_ICON : null);
                        this.myLabel.setHorizontalAlignment(0);
                        break;
                    }
                    case 1: {
                        this.myLabel.setText(v.getKey());
                        break;
                    }
                    case 2: {
                        if (v.asColor(null) == null) {
                            this.myLabel.setText(v.asString());
                            break;
                        }
                        this.myLabel.setIcon(RegistryUi.createColoredIcon(v.asColor(null)));
                    }
                }
                this.myLabel.setOpaque(true);
                this.myLabel.setFont(this.myLabel.getFont().deriveFont(v.isChangedFromDefault() ? 1 : 0));
                this.myLabel.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                this.myLabel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            }
            return this.myLabel;
        }
    }

    private static class MyTableModel
    extends AbstractTableModel {
        private List<RegistryValue> myAll;

        private MyTableModel() {
            Registry.getInstance();
            this.myAll = Registry.getAll();
            Collections.sort(this.myAll, new Comparator<RegistryValue>(){

                @Override
                public int compare(RegistryValue o1, RegistryValue o2) {
                    return o1.getKey().compareTo(o2.getKey());
                }
            });
        }

        public void fireChanged() {
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.myAll.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.myAll.get(rowIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2;
        }
    }

    private class EditAction
    extends AnAction {
        private EditAction() {
            new ShadowAction((AnAction)this, ActionManager.getInstance().getAction("EditSource"), (JComponent)RegistryUi.this.myTable);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(!RegistryUi.this.myTable.isEditing() && RegistryUi.this.myTable.getSelectedRow() >= 0);
            e.getPresentation().setText("Edit");
            e.getPresentation().setIcon(IconLoader.getIcon((String)"/actions/editSource.png"));
        }

        public void actionPerformed(AnActionEvent e) {
            RegistryUi.this.startEditingAtSelection();
        }
    }

    private class RevertAction
    extends AnAction {
        private RevertAction() {
            new ShadowAction((AnAction)this, ActionManager.getInstance().getAction("EditorDelete"), (JComponent)RegistryUi.this.myTable);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(!RegistryUi.this.myTable.isEditing() && RegistryUi.this.myTable.getSelectedRow() >= 0);
            e.getPresentation().setText("Revert to Default");
            e.getPresentation().setIcon(IconLoader.getIcon((String)"/general/remove.png"));
            if (e.getPresentation().isEnabled()) {
                RegistryValue rv = (RegistryValue)RegistryUi.this.myTable.getValueAt(RegistryUi.this.myTable.getSelectedRow(), 0);
                e.getPresentation().setEnabled(rv.isChangedFromDefault());
            }
        }

        public void actionPerformed(AnActionEvent e) {
            RegistryValue value = (RegistryValue)RegistryUi.this.myTable.getValueAt(RegistryUi.this.myTable.getSelectedRow(), 0);
            value.resetToDefault();
            RegistryUi.this.myModel.fireTableCellUpdated(RegistryUi.this.myTable.getSelectedRow(), 0);
            RegistryUi.this.myModel.fireTableCellUpdated(RegistryUi.this.myTable.getSelectedRow(), 1);
            RegistryUi.this.myModel.fireTableCellUpdated(RegistryUi.this.myTable.getSelectedRow(), 2);
            RegistryUi.this.revaliateActions();
        }
    }
}

