/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.reporter.ConnectionException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.NoUpdatesDialog;
import com.intellij.openapi.updateSettings.impl.PatchInfo;
import com.intellij.openapi.updateSettings.impl.PluginDownloader;
import com.intellij.openapi.updateSettings.impl.Product;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateInfoDialog;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.updateSettings.impl.UpdateSettingsConfigurable;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.util.io.UrlConnectionUtil;
import com.intellij.util.net.HttpConfigurable;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.SwingUtilities;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UpdateChecker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.updateSettings.impl.UpdateChecker");
    public static String ADDITIONAL_REQUEST_OPTIONS = "";
    private static boolean myVeryFirstOpening = true;
    @NonNls
    private static final String DISABLED_UPDATE = "disabled_update.txt";
    private static TreeSet<String> ourDisabledToUpdatePlugins;

    private static String getUpdateUrl() {
        return StringHolder.UPDATE_URL;
    }

    private static String getPatchesUrl() {
        return StringHolder.PATCHES_URL;
    }

    public static boolean isMyVeryFirstOpening() {
        return myVeryFirstOpening;
    }

    public static void setMyVeryFirstOpening(boolean myVeryFirstProjectOpening) {
        myVeryFirstOpening = myVeryFirstProjectOpening;
    }

    public static boolean checkNeeded() {
        UpdateSettings settings = UpdateSettings.getInstance();
        if (settings == null || UpdateChecker.getUpdateUrl() == null) {
            return false;
        }
        long timeDelta = System.currentTimeMillis() - settings.LAST_TIME_CHECKED;
        if (Math.abs(timeDelta) < 86400000L) {
            return false;
        }
        return settings.CHECK_NEEDED;
    }

    public static List<PluginDownloader> updatePlugins(boolean showErrorDialog) {
        ArrayList<PluginDownloader> downloaded = new ArrayList<PluginDownloader>();
        HashSet<String> failed = new HashSet<String>();
        for (String host : UpdateSettingsConfigurable.getInstance().getPluginHosts()) {
            try {
                UpdateChecker.checkPluginsHost(host, downloaded);
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                failed.add(host);
            }
        }
        if (!failed.isEmpty()) {
            String failedMessage = IdeBundle.message((String)"connection.failed.message", (Object[])new Object[]{StringUtil.join(failed, (String)",")});
            if (showErrorDialog) {
                Messages.showErrorDialog((String)failedMessage, (String)IdeBundle.message((String)"title.connection.error", (Object[])new Object[0]));
            } else {
                LOG.info(failedMessage);
            }
        }
        return downloaded.isEmpty() ? null : downloaded;
    }

    public static boolean checkPluginsHost(String host, final List<PluginDownloader> downloaded) throws Exception {
        Document document = UpdateChecker.loadVersionInfo(host);
        if (document == null) {
            return false;
        }
        boolean success = true;
        for (Object plugin : document.getRootElement().getChildren("plugin")) {
            Element pluginElement = (Element)plugin;
            final String pluginId = pluginElement.getAttributeValue("id");
            String pluginUrl = pluginElement.getAttributeValue("url");
            final String pluginVersion = pluginElement.getAttributeValue("version");
            if (pluginId == null) {
                LOG.info("plugin id should not be null");
                success = false;
                continue;
            }
            if (pluginUrl == null) {
                LOG.info("plugin url should not be null");
                success = false;
                continue;
            }
            if (!pluginUrl.startsWith("http")) {
                HttpFileSystem fileSystem = HttpFileSystem.getInstance();
                VirtualFile hostFile = fileSystem.findFileByPath(VfsUtil.urlToPath((String)host));
                LOG.assertTrue(hostFile != null);
                VirtualFile pluginByRelativePath = UpdateChecker.findPluginByRelativePath(hostFile.getParent(), pluginUrl, fileSystem);
                if (pluginByRelativePath != null) {
                    pluginUrl = pluginByRelativePath.getUrl();
                }
            }
            final String finalPluginUrl = pluginUrl;
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

                @Override
                public void run() {
                    try {
                        PluginDownloader uploader;
                        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                        if (progressIndicator != null) {
                            progressIndicator.setText(finalPluginUrl);
                        }
                        if ((uploader = new PluginDownloader(pluginId, finalPluginUrl, pluginVersion)).prepareToInstall()) {
                            downloaded.add(uploader);
                        }
                    }
                    catch (IOException e) {
                        LOG.info((Throwable)e);
                    }
                }
            }, IdeBundle.message((String)"update.uploading.plugin.progress.title", (Object[])new Object[0]), true, null);
        }
        return success;
    }

    @Nullable
    public static VirtualFile findPluginByRelativePath(VirtualFile hostFile, @NotNull @NonNls String relPath, HttpFileSystem fileSystem) {
        String name;
        VirtualFile child;
        if (relPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/updateSettings/impl/UpdateChecker.findPluginByRelativePath must not be null");
        }
        if (relPath.length() == 0) {
            return hostFile;
        }
        int index = relPath.indexOf(47);
        if (index < 0) {
            index = relPath.length();
        }
        if ((child = (name = relPath.substring(0, index)).equals(".") ? hostFile : (name.equals("..") ? hostFile.getParent() : fileSystem.findFileByPath(hostFile.getPath() + "/" + name))) == null) {
            return null;
        }
        if (index < relPath.length()) {
            return UpdateChecker.findPluginByRelativePath(child, relPath.substring(index + 1), fileSystem);
        }
        return child;
    }

    @Nullable
    private static Product findProduct(Element products, String code) {
        for (Object productNode : products.getChildren("product")) {
            Product product = new Product((Element)productNode);
            if (!product.hasCode(code)) continue;
            return product;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static UpdateChannel checkForUpdates() throws ConnectionException {
        try {
            Document document;
            BuildNumber ourBuild = ApplicationInfo.getInstance().getBuild();
            if (LOG.isDebugEnabled()) {
                LOG.debug("enter: checkForUpdates()");
            }
            try {
                document = UpdateChecker.loadVersionInfo(UpdateChecker.getUpdateUrl());
                if (document == null) {
                    UpdateChannel updateChannel = null;
                    return updateChannel;
                }
            }
            catch (Throwable t) {
                LOG.debug(t);
                throw new ConnectionException(t);
            }
            Element root = document.getRootElement();
            UpdateChannel channel = UpdateChecker.findUpdateChannel(root, ourBuild.getProductCode());
            if (channel == null) {
                UpdateChannel updateChannel = null;
                return updateChannel;
            }
            BuildInfo latestBuild = channel.getLatestBuild();
            if (latestBuild == null) {
                UpdateChannel updateChannel = null;
                return updateChannel;
            }
            if (ourBuild.compareTo(latestBuild.getNumber()) < 0) {
                UpdateChannel updateChannel = channel;
                return updateChannel;
            }
            UpdateChannel updateChannel = null;
            return updateChannel;
        }
        catch (Throwable t) {
            LOG.debug(t);
            UpdateChannel updateChannel = null;
            return updateChannel;
        }
        finally {
            UpdateSettings.getInstance().LAST_TIME_CHECKED = System.currentTimeMillis();
        }
    }

    @Nullable
    private static UpdateChannel findUpdateChannel(Element root, String productCode) {
        if (root == null) {
            LOG.info("cannot read " + UpdateChecker.getUpdateUrl());
            return null;
        }
        Product product = UpdateChecker.findProduct(root, productCode);
        if (product == null) {
            return null;
        }
        UpdateChannel channel = product.findUpdateChannelById(ApplicationInfo.getInstance().getDefaultUpdateChannel());
        if (channel != null) {
            return channel;
        }
        for (UpdateChannel c : product.getChannels()) {
            BuildInfo cBuild = c.getLatestBuild();
            if (cBuild == null) continue;
            if (channel == null) {
                channel = c;
                continue;
            }
            BuildInfo build = channel.getLatestBuild();
            assert (build != null);
            if (build.compareTo(cBuild) >= 0) continue;
            channel = c;
        }
        return channel;
    }

    private static Document loadVersionInfo(final String url) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: loadVersionInfo(UPDATE_URL='" + url + "' )");
        }
        final Document[] document = new Document[]{null};
        final Exception[] exception = new Exception[]{null};
        Future downloadThreadFuture = ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    HttpConfigurable.getInstance().prepareURL(url);
                    String uid = PropertiesComponent.getInstance().getOrInit("installation.uid", UUID.randomUUID().toString());
                    URL requestUrl = new URL(url + "?build=" + ApplicationInfo.getInstance().getBuild().asString() + "&uid=" + uid + ADDITIONAL_REQUEST_OPTIONS);
                    InputStream inputStream = requestUrl.openStream();
                    try {
                        document[0] = JDOMUtil.loadDocument((InputStream)inputStream);
                    }
                    finally {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    exception[0] = e;
                }
                catch (JDOMException e) {
                    LOG.info((Throwable)e);
                }
            }
        });
        try {
            downloadThreadFuture.get(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            // empty catch block
        }
        if (!downloadThreadFuture.isDone()) {
            downloadThreadFuture.cancel(true);
            throw new ConnectionException(IdeBundle.message((String)"updates.timeout.error", (Object[])new Object[0]));
        }
        if (exception[0] != null) {
            throw exception[0];
        }
        return document[0];
    }

    public static void showNoUpdatesDialog(boolean enableLink, List<PluginDownloader> updatePlugins) {
        NoUpdatesDialog dialog = new NoUpdatesDialog(true, updatePlugins, enableLink);
        dialog.show();
    }

    public static void showUpdateInfoDialog(boolean enableLink, UpdateChannel channel, List<PluginDownloader> updatePlugins) {
        new UpdateInfoDialog(true, channel, updatePlugins, enableLink).show();
    }

    public static boolean install(List<PluginDownloader> downloaders) {
        boolean installed = false;
        for (PluginDownloader downloader : downloaders) {
            if (UpdateChecker.getDisabledToUpdatePlugins().contains(downloader.getPluginId())) continue;
            try {
                downloader.install();
                installed = true;
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return installed;
    }

    public static DownloadPatchResult downloadAndInstallPatch(final BuildInfo newVersion) {
        final DownloadPatchResult[] result = new DownloadPatchResult[]{DownloadPatchResult.CANCELED};
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                try {
                    UpdateChecker.doDownloadAndInstallPatch(newVersion, ProgressManager.getInstance().getProgressIndicator());
                    result[0] = DownloadPatchResult.SUCCESS;
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                    result[0] = DownloadPatchResult.FAILED;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Notifications.Bus.notify((Notification)new Notification("Updater", "Failed to download patch file", e.getMessage(), NotificationType.ERROR));
                        }
                    });
                }
            }
        }, IdeBundle.message((String)"update.downloading.patch.progress.title", (Object[])new Object[0]), true, null)) {
            return DownloadPatchResult.CANCELED;
        }
        return result[0];
    }

    private static void doDownloadAndInstallPatch(BuildInfo newVersion, ProgressIndicator i) throws IOException {
        PatchInfo patch = newVersion.findPatchForCurrentBuild();
        if (patch == null) {
            throw new IOException("No patch is available for current version");
        }
        String productCode = ApplicationInfo.getInstance().getBuild().getProductCode();
        String osSuffix = "";
        if (SystemInfo.isWindows) {
            osSuffix = "-win";
        } else if (SystemInfo.isMac) {
            osSuffix = "-mac";
        } else if (SystemInfo.isUnix) {
            osSuffix = "-unix";
        }
        String fromBuildNumber = patch.getFromBuild().asStringWithoutProductCode();
        String toBuildNumber = newVersion.getNumber().asStringWithoutProductCode();
        String fileName = productCode + "-" + fromBuildNumber + "-" + toBuildNumber + "-patch" + osSuffix + ".jar";
        URLConnection connection = null;
        InputStream in = null;
        OutputStream out = null;
        String platform = System.getProperty("idea.platform.prefix", "idea");
        String patchFileName = "jetbrains.patch.jar." + platform;
        File patchFile = new File(FileUtil.getTempDirectory(), patchFileName);
        try {
            int count;
            connection = new URL(new URL(UpdateChecker.getPatchesUrl()), fileName).openConnection();
            in = UrlConnectionUtil.getConnectionInputStreamWithException(connection, i);
            out = new BufferedOutputStream(new FileOutputStream(patchFile));
            i.setIndeterminate(false);
            byte[] buffer = new byte[10240];
            int total = connection.getContentLength();
            int read = 0;
            while ((count = in.read(buffer)) > 0) {
                i.checkCanceled();
                out.write(buffer, 0, count);
                i.setFraction((double)(read += count) / (double)total);
                i.setText2(read / 1024 + "/" + total / 1024 + " KB");
            }
        }
        catch (IOException e) {
            patchFile.delete();
            throw e;
        }
        catch (ProcessCanceledException e) {
            patchFile.delete();
            throw e;
        }
        catch (Throwable e) {
            patchFile.delete();
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
        }
    }

    public static Set<String> getDisabledToUpdatePlugins() {
        if (ourDisabledToUpdatePlugins == null) {
            ourDisabledToUpdatePlugins = new TreeSet();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                try {
                    File file = new File(PathManager.getConfigPath(), DISABLED_UPDATE);
                    if (file.isFile()) {
                        String[] ids;
                        for (String id : ids = new String(FileUtil.loadFileText((File)file)).split("[\\s]")) {
                            if (id == null || id.trim().length() <= 0) continue;
                            ourDisabledToUpdatePlugins.add(id.trim());
                        }
                    }
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
        return ourDisabledToUpdatePlugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDisabledToUpdatePlugins() {
        try {
            File plugins = new File(PathManager.getConfigPath(), DISABLED_UPDATE);
            FileUtil.ensureCanCreateFile((File)plugins);
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new BufferedWriter(new FileWriter(plugins)));
                for (String id : UpdateChecker.getDisabledToUpdatePlugins()) {
                    printWriter.println(id);
                }
                printWriter.flush();
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static class StringHolder {
        private static final String UPDATE_URL = ApplicationInfoEx.getInstanceEx().getUpdateUrls().getCheckingUrl();
        private static final String PATCHES_URL = ApplicationInfoEx.getInstanceEx().getUpdateUrls().getPatchesUrl();

        private StringHolder() {
        }
    }

    public static enum DownloadPatchResult {
        SUCCESS,
        FAILED,
        CANCELED;

    }
}

