/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.facet.Facet;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FindUsagesInProjectStructureActionBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzerListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolderImpl;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeToolTipHandler;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.navigation.Place;
import com.intellij.util.Icons;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseStructureConfigurable
extends MasterDetailsComponent
implements SearchableConfigurable,
Disposable,
Configurable.Assistant,
Place.Navigator {
    protected StructureConfigurableContext myContext;
    protected final Project myProject;
    protected boolean myUiDisposed = true;
    private boolean myWasTreeInitialized;
    protected boolean myAutoScrollEnabled = true;

    protected BaseStructureConfigurable(Project project) {
        this.myProject = project;
    }

    public void init(StructureConfigurableContext context) {
        this.myContext = context;
        this.myContext.getDaemonAnalyzer().addListener(new ProjectStructureDaemonAnalyzerListener(){

            @Override
            public void usagesCollected(@NotNull ProjectStructureElement containingElement) {
                if (containingElement == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/BaseStructureConfigurable$1.usagesCollected must not be null");
                }
                this.updateTree();
            }

            @Override
            public void problemsChanged(@NotNull ProjectStructureElement element) {
                if (element == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/BaseStructureConfigurable$1.problemsChanged must not be null");
                }
                this.updateTree();
            }

            @Override
            public void allProblemsChanged() {
                this.updateTree();
            }

            private void updateTree() {
                if (!BaseStructureConfigurable.this.myTree.isShowing()) {
                    return;
                }
                BaseStructureConfigurable.this.myTree.revalidate();
                BaseStructureConfigurable.this.myTree.repaint();
            }
        });
    }

    public ActionCallback navigateTo(final @Nullable Place place, final boolean requestFocus) {
        MasterDetailsComponent.MyNode nodeByName;
        if (place == null) {
            return new ActionCallback.Done();
        }
        Object object = place.getPath("treeObject");
        String byName = (String)place.getPath("treeName");
        if (object == null && byName == null) {
            return new ActionCallback.Done();
        }
        MasterDetailsComponent.MyNode node = object == null ? null : BaseStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)object);
        MasterDetailsComponent.MyNode myNode = nodeByName = byName == null ? null : BaseStructureConfigurable.findNodeByName((TreeNode)this.myRoot, (String)byName);
        if (node == null && nodeByName == null) {
            return new ActionCallback.Done();
        }
        final NamedConfigurable config = node != null ? node.getConfigurable() : nodeByName.getConfigurable();
        final ActionCallback result = new ActionCallback().doWhenDone(new Runnable(){

            @Override
            public void run() {
                BaseStructureConfigurable.this.myAutoScrollEnabled = true;
            }
        });
        this.myAutoScrollEnabled = false;
        this.myAutoScrollHandler.cancelAllRequests();
        final MasterDetailsComponent.MyNode nodeToSelect = node != null ? node : nodeByName;
        this.selectNodeInTree((DefaultMutableTreeNode)nodeToSelect, requestFocus).doWhenDone(new Runnable(){

            @Override
            public void run() {
                BaseStructureConfigurable.this.setSelectedNode(nodeToSelect);
                Place.goFurther((Object)config, (Place)place, (boolean)requestFocus).notifyWhenDone(result);
            }
        });
        return result;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/BaseStructureConfigurable.queryPlace must not be null");
        }
        if (this.myCurrentConfigurable != null) {
            place.putPath("treeObject", this.myCurrentConfigurable.getEditableObject());
            Place.queryFurther((Object)this.myCurrentConfigurable, (Place)place);
        }
    }

    protected void initTree() {
        if (this.myWasTreeInitialized) {
            return;
        }
        this.myWasTreeInitialized = true;
        super.initTree();
        new TreeSpeedSearch(this.myTree, new Convertor<TreePath, String>(){

            public String convert(TreePath treePath) {
                return ((MasterDetailsComponent.MyNode)treePath.getLastPathComponent()).getDisplayName();
            }
        }, true);
        TreeToolTipHandler.install((JTree)this.myTree);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
        this.myTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof MasterDetailsComponent.MyNode) {
                    ProjectStructureElement projectStructureElement;
                    SimpleTextAttributes textAttributes;
                    MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)value;
                    NamedConfigurable namedConfigurable = node.getConfigurable();
                    if (namedConfigurable == null) {
                        return;
                    }
                    String displayName = node.getDisplayName();
                    Icon icon = namedConfigurable.getIcon(expanded);
                    this.setIcon(icon);
                    this.setToolTipText(null);
                    this.setFont(UIUtil.getTreeFont());
                    SimpleTextAttributes simpleTextAttributes = textAttributes = selected && hasFocus ? SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
                    if (node.isDisplayInBold()) {
                        textAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                    } else if (namedConfigurable instanceof ProjectStructureElementConfigurable && (projectStructureElement = ((ProjectStructureElementConfigurable)namedConfigurable).getProjectStructureElement()) != null) {
                        boolean invalid;
                        ProjectStructureDaemonAnalyzer daemonAnalyzer = BaseStructureConfigurable.this.myContext.getDaemonAnalyzer();
                        boolean unused = daemonAnalyzer.isUnused(projectStructureElement);
                        ProjectStructureProblemsHolderImpl problemsHolder = daemonAnalyzer.getProblemsHolder(projectStructureElement);
                        if (problemsHolder == null) {
                            daemonAnalyzer.queueUpdate(projectStructureElement, true, false);
                        }
                        ProjectStructureProblemDescription.Severity level = problemsHolder != null ? problemsHolder.getSeverity() : null;
                        boolean bl = invalid = level != null;
                        if (unused || invalid) {
                            String text;
                            Color fg = unused ? UIUtil.getTextInactiveTextColor() : (selected && hasFocus ? UIUtil.getTreeSelectionForeground() : UIUtil.getTreeForeground());
                            textAttributes = new SimpleTextAttributes(invalid ? 8 : 0, fg, level == ProjectStructureProblemDescription.Severity.ERROR ? Color.RED : Color.GRAY);
                            String string = text = problemsHolder != null ? problemsHolder.composeTooltipMessage() : "";
                            if (unused) {
                                text = text + ProjectBundle.message((String)"project.roots.tooltip.unused", (Object[])new Object[]{displayName});
                            }
                            this.setToolTipText(text);
                        }
                    }
                    this.append(displayName, textAttributes);
                }
            }
        });
    }

    public void disposeUIResources() {
        if (this.myUiDisposed) {
            return;
        }
        super.disposeUIResources();
        this.myUiDisposed = true;
        this.myAutoScrollHandler.cancelAllRequests();
        this.myContext.getDaemonAnalyzer().clear();
        Disposer.dispose((Disposable)this);
    }

    protected void addCollapseExpandActions(List<AnAction> result) {
        TreeExpander expander = new TreeExpander(){

            public void expandAll() {
                TreeUtil.expandAll((JTree)BaseStructureConfigurable.this.myTree);
            }

            public boolean canExpand() {
                return true;
            }

            public void collapseAll() {
                TreeUtil.collapseAll((JTree)BaseStructureConfigurable.this.myTree, (int)0);
            }

            public boolean canCollapse() {
                return true;
            }
        };
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        result.add(actionsManager.createExpandAllAction(expander, (JComponent)this.myTree));
        result.add(actionsManager.createCollapseAllAction(expander, (JComponent)this.myTree));
    }

    @Nullable
    public ProjectStructureElement getSelectedElement() {
        MasterDetailsComponent.MyNode node;
        NamedConfigurable configurable;
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null && selectionPath.getLastPathComponent() instanceof MasterDetailsComponent.MyNode && (configurable = (node = (MasterDetailsComponent.MyNode)selectionPath.getLastPathComponent()).getConfigurable()) instanceof ProjectStructureElementConfigurable) {
            return ((ProjectStructureElementConfigurable)configurable).getProjectStructureElement();
        }
        return null;
    }

    public void reset() {
        this.myUiDisposed = false;
        if (!this.myWasTreeInitialized) {
            this.initTree();
            this.myTree.setShowsRootHandles(false);
            this.loadTree();
        } else {
            super.disposeUIResources();
            this.myTree.setShowsRootHandles(false);
            this.loadTree();
        }
        for (ProjectStructureElement projectStructureElement : this.getProjectStructureElements()) {
            this.myContext.getDaemonAnalyzer().queueUpdate(projectStructureElement, false, true);
        }
        super.reset();
    }

    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/BaseStructureConfigurable.getProjectStructureElements must not return null");
        }
        return list;
    }

    protected abstract void loadTree();

    @NotNull
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result = new ArrayList<AnAction>();
        AbstractAddGroup addAction = this.createAddAction();
        if (addAction != null) {
            result.add((AnAction)addAction);
        }
        result.add((AnAction)new MyRemoveAction());
        AnAction copyAction = this.createCopyAction();
        if (copyAction != null) {
            result.add(copyAction);
        }
        result.add((AnAction)Separator.getInstance());
        result.add(new MyFindUsagesAction((JComponent)this.myTree));
        ArrayList<AnAction> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/projectRoot/BaseStructureConfigurable.createActions must not return null");
        }
        return arrayList;
    }

    @Nullable
    protected AnAction createCopyAction() {
        return null;
    }

    @Nullable
    protected abstract AbstractAddGroup createAddAction();

    protected void removeArtifact(Artifact artifact) {
    }

    protected void removeLibrary(Library library) {
    }

    protected void removeFacetNodes(@NotNull List<Facet> facets) {
        if (facets == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/projectRoot/BaseStructureConfigurable.removeFacetNodes must not be null");
        }
        for (Facet facet : facets) {
            MasterDetailsComponent.MyNode node = BaseStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)facet);
            if (node == null) continue;
            this.removePaths(new TreePath[]{TreeUtil.getPathFromRoot((TreeNode)node)});
        }
    }

    protected List<Facet> removeFacet(Facet facet) {
        return this.myContext.myModulesConfigurator.getFacetsConfigurator().removeFacet(facet);
    }

    protected boolean removeModule(Module module) {
        return true;
    }

    protected void removeJdk(Sdk editableObject) {
    }

    protected static abstract class AbstractAddGroup
    extends ActionGroup
    implements MasterDetailsComponent.ActionGroupWithPreselection {
        protected AbstractAddGroup(String text, Icon icon) {
            super(text, true);
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(icon);
            Keymap active = KeymapManager.getInstance().getActiveKeymap();
            if (active != null) {
                Shortcut[] shortcuts = active.getShortcuts("NewElement");
                this.setShortcutSet((ShortcutSet)new CustomShortcutSet(shortcuts));
            }
        }

        public AbstractAddGroup(String text) {
            this(text, Icons.ADD_ICON);
        }

        public ActionGroup getActionGroup() {
            return this;
        }

        public int getDefaultIndex() {
            return 0;
        }
    }

    protected class MyRemoveAction
    extends MasterDetailsComponent.MyDeleteAction {
        public MyRemoveAction() {
            super((MasterDetailsComponent)BaseStructureConfigurable.this, (Condition)new Condition<Object>(){

                public boolean value(Object object) {
                    NamedConfigurable namedConfigurable;
                    if (object instanceof MasterDetailsComponent.MyNode && (namedConfigurable = ((MasterDetailsComponent.MyNode)object).getConfigurable()) != null) {
                        Object editableObject = namedConfigurable.getEditableObject();
                        if (editableObject instanceof Sdk || editableObject instanceof Module || editableObject instanceof Facet || editableObject instanceof Artifact) {
                            return true;
                        }
                        if (editableObject instanceof Library) {
                            LibraryTable table = ((Library)editableObject).getTable();
                            return table == null || table.isEditable();
                        }
                    }
                    return false;
                }
            });
        }

        public void actionPerformed(AnActionEvent e) {
            TreePath[] paths = BaseStructureConfigurable.this.myTree.getSelectionPaths();
            if (paths == null) {
                return;
            }
            HashSet<TreePath> pathsToRemove = new HashSet<TreePath>();
            for (TreePath path : paths) {
                if (!this.removeFromModel(path)) continue;
                pathsToRemove.add(path);
            }
            BaseStructureConfigurable.this.removePaths(pathsToRemove.toArray(new TreePath[pathsToRemove.size()]));
        }

        private boolean removeFromModel(TreePath selectionPath) {
            Object last = selectionPath.getLastPathComponent();
            if (!(last instanceof MasterDetailsComponent.MyNode)) {
                return false;
            }
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)last;
            NamedConfigurable configurable = node.getConfigurable();
            Object editableObject = configurable.getEditableObject();
            if (editableObject instanceof Sdk) {
                BaseStructureConfigurable.this.removeJdk((Sdk)editableObject);
            } else if (editableObject instanceof Module) {
                if (!BaseStructureConfigurable.this.removeModule((Module)editableObject)) {
                    return false;
                }
            } else if (editableObject instanceof Facet) {
                if (BaseStructureConfigurable.this.removeFacet((Facet)editableObject).isEmpty()) {
                    return false;
                }
            } else if (editableObject instanceof Library) {
                BaseStructureConfigurable.this.removeLibrary((Library)editableObject);
            } else if (editableObject instanceof Artifact) {
                BaseStructureConfigurable.this.removeArtifact((Artifact)editableObject);
            }
            return true;
        }
    }

    private class MyFindUsagesAction
    extends FindUsagesInProjectStructureActionBase {
        public MyFindUsagesAction(JComponent parentComponent) {
            super(parentComponent, BaseStructureConfigurable.this.myProject);
        }

        @Override
        protected boolean isEnabled() {
            TreePath selectionPath = BaseStructureConfigurable.this.myTree.getSelectionPath();
            if (selectionPath != null) {
                MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)selectionPath.getLastPathComponent();
                return !node.isDisplayInBold();
            }
            return false;
        }

        @Override
        protected StructureConfigurableContext getContext() {
            return BaseStructureConfigurable.this.myContext;
        }

        @Override
        protected ProjectStructureElement getSelectedElement() {
            return BaseStructureConfigurable.this.getSelectedElement();
        }

        @Override
        protected RelativePoint getPointToShowResults() {
            int selectedRow = BaseStructureConfigurable.this.myTree.getSelectionRows()[0];
            Rectangle rowBounds = BaseStructureConfigurable.this.myTree.getRowBounds(selectedRow);
            Point location = rowBounds.getLocation();
            location.x += rowBounds.width;
            return new RelativePoint((Component)BaseStructureConfigurable.this.myTree, location);
        }
    }
}

