/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.PackagingSourceItemsProvider;
import com.intellij.packaging.ui.SourceItemPresentation;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModuleSourceItemGroup
extends PackagingSourceItem {
    private final Module myModule;

    public ModuleSourceItemGroup(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleSourceItemGroup.<init> must not be null");
        }
        super(true);
        this.myModule = module;
    }

    public SourceItemPresentation createPresentation(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleSourceItemGroup.createPresentation must not be null");
        }
        return new ModuleSourceItemPresentation(this.myModule, context);
    }

    public boolean equals(Object obj) {
        return obj instanceof ModuleSourceItemGroup && this.myModule.equals(((ModuleSourceItemGroup)((Object)obj)).myModule);
    }

    public int hashCode() {
        return this.myModule.hashCode();
    }

    @NotNull
    public List<? extends PackagingElement<?>> createElements(@NotNull ArtifactEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleSourceItemGroup.createElements must not be null");
        }
        LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
        ModuleSourceItemGroup.collectDependentModules(this.myModule, modules, context);
        Artifact artifact = context.getArtifact();
        ArtifactType artifactType = artifact.getArtifactType();
        LinkedHashSet<PackagingSourceItem> items = new LinkedHashSet<PackagingSourceItem>();
        for (Module module : modules) {
            for (PackagingSourceItemsProvider provider : (PackagingSourceItemsProvider[])PackagingSourceItemsProvider.EP_NAME.getExtensions()) {
                ModuleSourceItemGroup parent = new ModuleSourceItemGroup(module);
                for (PackagingSourceItem sourceItem : provider.getSourceItems(context, artifact, (PackagingSourceItem)parent)) {
                    if (!artifactType.isSuitableItem(sourceItem) || !sourceItem.isProvideElements()) continue;
                    items.add(sourceItem);
                }
            }
        }
        ArrayList result = new ArrayList();
        PackagingElementFactory factory = PackagingElementFactory.getInstance();
        for (PackagingSourceItem item : items) {
            String path = artifactType.getDefaultPathFor(item.getKindOfProducedElements());
            if (path == null) continue;
            result.addAll(factory.createParentDirectories(path, item.createElements(context)));
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleSourceItemGroup.createElements must not return null");
        }
        return arrayList;
    }

    private static void collectDependentModules(Module module, Set<Module> modules, ArtifactEditorContext context) {
        if (!modules.add(module)) {
            return;
        }
        for (OrderEntry entry : context.getModulesProvider().getRootModel(module).getOrderEntries()) {
            if (!(entry instanceof ModuleOrderEntry)) continue;
            ModuleOrderEntry moduleEntry = (ModuleOrderEntry)entry;
            Module dependency = moduleEntry.getModule();
            DependencyScope scope = moduleEntry.getScope();
            if (dependency == null || scope == DependencyScope.TEST || scope == DependencyScope.PROVIDED) continue;
            ModuleSourceItemGroup.collectDependentModules(dependency, modules, context);
        }
    }

    public Module getModule() {
        return this.myModule;
    }

    public void render(@NotNull ColoredTreeCellRenderer renderer) {
        if (renderer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleSourceItemGroup.render must not be null");
        }
        renderer.append(this.myModule.getName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        renderer.setIcon(this.myModule.getModuleType().getNodeIcon(false));
    }

    private static class ModuleSourceItemPresentation
    extends SourceItemPresentation {
        private final Module myModule;
        private final ArtifactEditorContext myContext;

        public ModuleSourceItemPresentation(@NotNull Module module, ArtifactEditorContext context) {
            if (module == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleSourceItemGroup$ModuleSourceItemPresentation.<init> must not be null");
            }
            this.myModule = module;
            this.myContext = context;
        }

        public String getPresentableName() {
            return this.myModule.getName();
        }

        public void render(@NotNull PresentationData presentationData, SimpleTextAttributes mainAttributes, SimpleTextAttributes commentAttributes) {
            if (presentationData == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModuleSourceItemGroup$ModuleSourceItemPresentation.render must not be null");
            }
            presentationData.setClosedIcon(this.myModule.getModuleType().getNodeIcon(false));
            presentationData.setOpenIcon(this.myModule.getModuleType().getNodeIcon(true));
            presentationData.addText(this.myModule.getName(), mainAttributes);
        }

        public boolean canNavigateToSource() {
            return true;
        }

        public void navigateToSource() {
            this.myContext.selectModule(this.myModule);
        }

        public Object getSourceObject() {
            return this.myModule;
        }

        public int getWeight() {
            return 50;
        }
    }
}

