/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class JdkScope
extends GlobalSearchScope {
    private final LinkedHashSet<VirtualFile> myEntries = new LinkedHashSet();
    private final String myJdkName;
    private final ProjectFileIndex myIndex;

    public JdkScope(Project project, JdkOrderEntry jdk) {
        super(project);
        this.myIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        this.myJdkName = jdk.getJdkName();
        this.myEntries.addAll(Arrays.asList(jdk.getFiles(OrderRootType.CLASSES)));
    }

    public int hashCode() {
        return this.myJdkName.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object.getClass() != JdkScope.class) {
            return false;
        }
        JdkScope that = (JdkScope)((Object)object);
        return that.myJdkName.equals(this.myJdkName);
    }

    public boolean contains(VirtualFile file) {
        return this.myEntries.contains(this.getFileRoot(file));
    }

    private VirtualFile getFileRoot(VirtualFile file) {
        if (this.myIndex.isInLibraryClasses(file)) {
            return this.myIndex.getClassRootForFile(file);
        }
        if (this.myIndex.isInContent(file)) {
            return this.myIndex.getSourceRootForFile(file);
        }
        return null;
    }

    public int compare(VirtualFile file1, VirtualFile file2) {
        VirtualFile r1 = this.getFileRoot(file1);
        VirtualFile r2 = this.getFileRoot(file2);
        for (VirtualFile root : this.myEntries) {
            if (r1 == root) {
                return 1;
            }
            if (r2 != root) continue;
            return -1;
        }
        return 0;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/module/impl/scopes/JdkScope.isSearchInModuleContent must not be null");
        }
        return false;
    }

    public boolean isSearchInLibraries() {
        return true;
    }
}

