/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.ide.DataManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import java.awt.Component;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextComponentSelectionModel
implements SelectionModel {
    private final JTextComponent myTextComponent;
    private final TextComponentEditor myEditor;

    public TextComponentSelectionModel(JTextComponent textComponent, TextComponentEditor textComponentEditor) {
        this.myTextComponent = textComponent;
        this.myEditor = textComponentEditor;
    }

    public int getSelectionStart() {
        return this.myTextComponent.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.myTextComponent.getSelectionEnd();
    }

    @Nullable
    public String getSelectedText() {
        return this.myTextComponent.getSelectedText();
    }

    public int getLeadSelectionOffset() {
        int caretPosition = this.myTextComponent.getCaretPosition();
        int start = this.myTextComponent.getSelectionStart();
        int end = this.myTextComponent.getSelectionEnd();
        return caretPosition == start ? end : start;
    }

    public boolean hasSelection() {
        return this.myTextComponent.getSelectionStart() != this.myTextComponent.getSelectionEnd();
    }

    public void setSelection(int startOffset, int endOffset) {
        if (this.myTextComponent.getCaretPosition() == startOffset) {
            this.myTextComponent.setCaretPosition(endOffset);
            this.myTextComponent.moveCaretPosition(startOffset);
        } else {
            this.myTextComponent.setCaretPosition(startOffset);
            this.myTextComponent.moveCaretPosition(endOffset);
        }
    }

    public void removeSelection() {
        int position = this.myTextComponent.getCaretPosition();
        this.myTextComponent.select(position, position);
    }

    public void addSelectionListener(SelectionListener listener) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeSelectionListener(SelectionListener listener) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void selectLineAtCaret() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void selectWordAtCaret(boolean honorCamelWordsSettings) {
        this.removeSelection();
        EditorActionHandler handler = EditorActionManager.getInstance().getActionHandler("EditorSelectWord");
        handler.execute((Editor)this.myEditor, DataManager.getInstance().getDataContext((Component)this.myEditor.getComponent()));
    }

    public void copySelectionToClipboard() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setBlockSelection(LogicalPosition blockStart, LogicalPosition blockEnd) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeBlockSelection() {
    }

    public boolean hasBlockSelection() {
        return false;
    }

    @NotNull
    public int[] getBlockSelectionStarts() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public int[] getBlockSelectionEnds() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nullable
    public LogicalPosition getBlockStart() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nullable
    public LogicalPosition getBlockEnd() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isBlockSelectionGuarded() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nullable
    public RangeMarker getBlockSelectionGuard() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public TextAttributes getTextAttributes() {
        return null;
    }
}

