/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.DecodeDefaultsUtil;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.BundledColorSchemesProvider;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsSchemeImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.NamedJDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class EditorColorsManagerImpl
extends EditorColorsManager
implements NamedJDOMExternalizable,
ExportableApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.colors.impl.EditorColorsManagerImpl");
    private final Collection<EditorColorsListener> myListeners = new ArrayList<EditorColorsListener>();
    @NonNls
    private static final String NODE_NAME = "global_color_scheme";
    @NonNls
    private static final String SCHEME_NODE_NAME = "scheme";
    private String myGlobalSchemeName;
    public boolean USE_ONLY_MONOSPACED_FONTS = true;
    private final DefaultColorSchemesManager myDefaultColorSchemesManager;
    private final SchemesManager<EditorColorsScheme, EditorColorsSchemeImpl> mySchemesManager;
    @NonNls
    private static final String NAME_ATTR = "name";
    private static final String FILE_SPEC = "$ROOT_CONFIG$/colors";

    public EditorColorsManagerImpl(DefaultColorSchemesManager defaultColorSchemesManager, SchemesManagerFactory schemesManagerFactory) {
        this.myDefaultColorSchemesManager = defaultColorSchemesManager;
        this.mySchemesManager = schemesManagerFactory.createSchemesManager(FILE_SPEC, (SchemeProcessor)new SchemeProcessor<EditorColorsSchemeImpl>(){

            public EditorColorsSchemeImpl readScheme(Document document) throws InvalidDataException, IOException, JDOMException {
                return EditorColorsManagerImpl.this.loadSchemeFromDocument(document, true);
            }

            public Document writeScheme(EditorColorsSchemeImpl scheme) throws WriteExternalException {
                Element root = new Element(EditorColorsManagerImpl.SCHEME_NODE_NAME);
                try {
                    scheme.writeExternal(root);
                }
                catch (WriteExternalException e) {
                    LOG.error((Throwable)e);
                    return null;
                }
                return new Document(root);
            }

            public void renameScheme(String name, EditorColorsScheme scheme) {
                scheme.setName(name);
            }

            public boolean shouldBeSaved(EditorColorsSchemeImpl scheme) {
                return !(scheme instanceof ReadOnlyColorsScheme);
            }

            public void initScheme(EditorColorsSchemeImpl scheme) {
            }

            public void onSchemeAdded(EditorColorsSchemeImpl scheme) {
            }

            public void onSchemeDeleted(EditorColorsSchemeImpl scheme) {
            }

            public void onCurrentSchemeChanged(Scheme newCurrentScheme) {
                EditorColorsManagerImpl.this.fireChanges((EditorColorsScheme)EditorColorsManagerImpl.this.mySchemesManager.getCurrentScheme());
            }
        }, RoamingType.PER_USER);
        this.addDefaultSchemes();
        this.extendDefaultScheme();
        this.loadAdditionalDefaultSchemes();
        this.loadAllSchemes();
        this.setGlobalScheme(this.myDefaultColorSchemesManager.getAllSchemes()[0]);
    }

    private void extendDefaultScheme() {
        EditorColorsScheme defaultColorsScheme = (EditorColorsScheme)this.mySchemesManager.findSchemeByName("Default");
        for (BundledColorSchemesProvider provider : (BundledColorSchemesProvider[])BundledColorSchemesProvider.EP_NAME.getExtensions()) {
            String extensionPath;
            try {
                extensionPath = provider.getDefaultSchemaExtensionPath();
            }
            catch (AbstractMethodError e) {
                continue;
            }
            if (extensionPath == null) continue;
            try {
                TextAttributesKey key;
                EditorColorsSchemeImpl extScheme = this.loadScheme(extensionPath, provider);
                if (extScheme == null) continue;
                for (Map.Entry keyTextAttributesEntry : extScheme.myAttributesMap.entrySet()) {
                    key = (TextAttributesKey)keyTextAttributesEntry.getKey();
                    TextAttributes attrs = (TextAttributes)keyTextAttributesEntry.getValue();
                    ((AbstractColorsScheme)defaultColorsScheme).myAttributesMap.put(key, attrs);
                }
                for (Map.Entry keyColorEntry : extScheme.myColorsMap.entrySet()) {
                    key = (ColorKey)keyColorEntry.getKey();
                    Color color = (Color)keyColorEntry.getValue();
                    ((AbstractColorsScheme)defaultColorsScheme).myColorsMap.put((ColorKey)key, color);
                }
            }
            catch (Exception e) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LOG.error("Cannot read scheme from " + extensionPath + ": " + e.getLocalizedMessage(), (Throwable)e);
                    }
                });
            }
        }
    }

    private void loadAdditionalDefaultSchemes() {
        for (BundledColorSchemesProvider provider : (BundledColorSchemesProvider[])BundledColorSchemesProvider.EP_NAME.getExtensions()) {
            String[] schemesPaths = provider.getBundledSchemesRelativePaths();
            if (schemesPaths == null) continue;
            for (final String schemePath : schemesPaths) {
                try {
                    EditorColorsSchemeImpl scheme = this.loadScheme(schemePath, provider);
                    if (scheme == null) continue;
                    this.mySchemesManager.addNewScheme((Scheme)scheme, false);
                }
                catch (Exception e) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LOG.error("Cannot read scheme from " + schemePath + ": " + e.getLocalizedMessage(), (Throwable)e);
                        }
                    });
                }
            }
        }
    }

    private EditorColorsSchemeImpl loadScheme(@NotNull String schemePath, BundledColorSchemesProvider provider) throws IOException, JDOMException, InvalidDataException {
        Document document;
        if (schemePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl.loadScheme must not be null");
        }
        InputStream inputStream = DecodeDefaultsUtil.getDefaultsInputStream(provider, schemePath);
        if (inputStream == null) {
            LOG.error("Cannot read scheme from " + schemePath);
            return null;
        }
        try {
            document = JDOMUtil.loadDocument((InputStream)inputStream);
        }
        catch (JDOMException e) {
            LOG.info("Error reading scheme from  " + schemePath + ": " + e.getLocalizedMessage());
            throw e;
        }
        return this.loadSchemeFromDocument(document, false);
    }

    private EditorColorsSchemeImpl loadSchemeFromDocument(Document document, boolean isEditable) throws InvalidDataException {
        Element root = document.getRootElement();
        if (root == null || !SCHEME_NODE_NAME.equals(root.getName())) {
            throw new InvalidDataException();
        }
        EditorColorsSchemeImpl scheme = isEditable ? new EditorColorsSchemeImpl(null, DefaultColorSchemesManager.getInstance()) : new ReadOnlyColorsSchemeImpl(null, DefaultColorSchemesManager.getInstance());
        scheme.readExternal(root);
        return scheme;
    }

    public void disposeComponent() {
    }

    public void initComponent() {
    }

    public void addColorsScheme(EditorColorsScheme scheme) {
        if (!this.isDefaultScheme(scheme) && scheme.getName().trim().length() > 0) {
            this.mySchemesManager.addNewScheme((Scheme)scheme, true);
        }
    }

    public void removeAllSchemes() {
        this.mySchemesManager.clearAllSchemes();
        this.addDefaultSchemes();
    }

    private void addDefaultSchemes() {
        DefaultColorsScheme[] allDefaultSchemes;
        for (DefaultColorsScheme defaultScheme : allDefaultSchemes = this.myDefaultColorSchemesManager.getAllSchemes()) {
            this.mySchemesManager.addNewScheme((Scheme)defaultScheme, true);
        }
    }

    public EditorColorsScheme[] getAllSchemes() {
        ArrayList schemes = new ArrayList(this.mySchemesManager.getAllSchemes());
        Collections.sort(schemes, new Comparator<EditorColorsScheme>(){

            @Override
            public int compare(EditorColorsScheme s1, EditorColorsScheme s2) {
                if (EditorColorsManagerImpl.this.isDefaultScheme(s1) && !EditorColorsManagerImpl.this.isDefaultScheme(s2)) {
                    return -1;
                }
                if (!EditorColorsManagerImpl.this.isDefaultScheme(s1) && EditorColorsManagerImpl.this.isDefaultScheme(s2)) {
                    return 1;
                }
                return s1.getName().compareToIgnoreCase(s2.getName());
            }
        });
        return schemes.toArray(new EditorColorsScheme[schemes.size()]);
    }

    public void setGlobalScheme(EditorColorsScheme scheme) {
        this.mySchemesManager.setCurrentSchemeName(scheme == null ? DefaultColorSchemesManager.getInstance().getAllSchemes()[0].getName() : scheme.getName());
        this.fireChanges(scheme);
    }

    public EditorColorsScheme getGlobalScheme() {
        return (EditorColorsScheme)this.mySchemesManager.getCurrentScheme();
    }

    public EditorColorsScheme getScheme(String schemeName) {
        return (EditorColorsScheme)this.mySchemesManager.findSchemeByName(schemeName);
    }

    private void fireChanges(EditorColorsScheme scheme) {
        EditorColorsListener[] colorsListeners;
        for (EditorColorsListener colorsListener : colorsListeners = this.myListeners.toArray(new EditorColorsListener[this.myListeners.size()])) {
            colorsListener.globalSchemeChange(scheme);
        }
    }

    private void loadAllSchemes() {
        this.mySchemesManager.loadSchemes();
    }

    private static File getColorsDir(boolean create) {
        String directoryPath = PathManager.getConfigPath() + File.separator + "colors";
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            if (!create) {
                return null;
            }
            if (!directory.mkdir()) {
                LOG.error("Cannot create directory: " + directory.getAbsolutePath());
                return null;
            }
        }
        return directory;
    }

    public void addEditorColorsListener(EditorColorsListener listener) {
        this.myListeners.add(listener);
    }

    public void removeEditorColorsListener(EditorColorsListener listener) {
        this.myListeners.remove(listener);
    }

    public void setUseOnlyMonospacedFonts(boolean b) {
        this.USE_ONLY_MONOSPACED_FONTS = b;
    }

    public boolean isUseOnlyMonospacedFonts() {
        return this.USE_ONLY_MONOSPACED_FONTS;
    }

    public String getExternalFileName() {
        return "colors.scheme";
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{EditorColorsManagerImpl.getColorsDir(true), PathManager.getOptionsFile((NamedJDOMExternalizable)this)};
        if (fileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl.getExportFiles must not return null");
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        String string = OptionsBundle.message((String)"options.color.schemes.presentable.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl.getPresentableName must not return null");
        }
        return string;
    }

    public void readExternal(Element parentNode) throws InvalidDataException {
        String name;
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)parentNode);
        Element element = parentNode.getChild(NODE_NAME);
        if (element != null && (name = element.getAttributeValue(NAME_ATTR)) != null && !"".equals(name.trim())) {
            this.myGlobalSchemeName = name;
        }
        this.initGlobalScheme();
    }

    private void initGlobalScheme() {
        if (this.myGlobalSchemeName != null) {
            this.setGlobalSchemeByName(this.myGlobalSchemeName);
        } else {
            this.setGlobalScheme(this.myDefaultColorSchemesManager.getAllSchemes()[0]);
        }
    }

    private void setGlobalSchemeByName(String schemeName) {
        this.setGlobalScheme((EditorColorsScheme)this.mySchemesManager.findSchemeByName(schemeName));
    }

    public void writeExternal(Element parentNode) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)parentNode);
        if (this.mySchemesManager.getCurrentScheme() != null) {
            Element element = new Element(NODE_NAME);
            element.setAttribute(NAME_ATTR, ((EditorColorsScheme)this.mySchemesManager.getCurrentScheme()).getName());
            parentNode.addContent(element);
        }
    }

    public boolean isDefaultScheme(EditorColorsScheme scheme) {
        return scheme instanceof DefaultColorsScheme;
    }

    public String getComponentName() {
        return "EditorColorsManagerImpl";
    }

    public SchemesManager<EditorColorsScheme, EditorColorsSchemeImpl> getSchemesManager() {
        return this.mySchemesManager;
    }
}

