/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard.modes;

import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.ide.util.importProject.FacetDetectionStep;
import com.intellij.ide.util.importProject.LibrariesDetectionStep;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.importProject.ModulesDetectionStep;
import com.intellij.ide.util.newProjectWizard.ProjectFromSourcesBuilder;
import com.intellij.ide.util.newProjectWizard.ProjectNameStep;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.newProjectWizard.modes.WizardMode;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.ProjectWizardStepFactory;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.IconLoader;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFromSourcesMode
extends WizardMode {
    private static final Icon NEW_PROJECT_ICON = IconLoader.getIcon((String)"/newprojectwizard.png");
    private static final Icon ICON = IconLoader.getIcon((String)"/addmodulewizard.png");
    private ProjectFromSourcesBuilder myProjectBuilder;

    @Override
    @NotNull
    public String getDisplayName(WizardContext context) {
        String string = ProjectBundle.message((String)"project.new.wizard.from.existent.sources.title", (Object[])new Object[]{context.getPresentationName()});
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/newProjectWizard/modes/CreateFromSourcesMode.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescription(WizardContext context) {
        String string = ProjectBundle.message((String)"project.new.wizard.from.existent.sources.description", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), context.getPresentationName()});
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/newProjectWizard/modes/CreateFromSourcesMode.getDescription must not return null");
        }
        return string;
    }

    @Override
    @Nullable
    protected StepSequence createSteps(WizardContext context, ModulesProvider modulesProvider) {
        ProjectFromSourcesBuilder projectBuilder;
        ModuleInsight moduleInsight = new ModuleInsight((ProgressIndicator)new DelegatingProgressIndicator());
        this.myProjectBuilder = projectBuilder = new ProjectFromSourcesBuilder(moduleInsight);
        ProjectWizardStepFactory factory = ProjectWizardStepFactory.getInstance();
        StepSequence sequence = new StepSequence();
        Icon icon = context.isCreatingNewProject() ? NEW_PROJECT_ICON : ICON;
        sequence.addCommonStep(new ProjectNameStep(context, sequence, this));
        sequence.addCommonStep(factory.createSourcePathsStep(context, (SourcePathsBuilder)projectBuilder, icon, "reference.dialogs.new.project.fromCode.source"));
        sequence.addCommonStep(new LibrariesDetectionStep(projectBuilder, moduleInsight, icon, "reference.dialogs.new.project.fromCode.page1"));
        sequence.addCommonStep(new ModulesDetectionStep(projectBuilder, moduleInsight, icon, "reference.dialogs.new.project.fromCode.page2"));
        sequence.addCommonStep(factory.createProjectJdkStep(context));
        if (FacetDetectionStep.isEnabled(StdModuleTypes.JAVA)) {
            FacetDetectionStep facetDetectionStep = new FacetDetectionStep(icon, StdModuleTypes.JAVA){

                @Override
                protected List<ModuleDescriptor> getModuleDescriptors() {
                    return projectBuilder.getModules();
                }
            };
            projectBuilder.addConfigurationUpdater(facetDetectionStep);
            sequence.addCommonStep(facetDetectionStep);
        }
        return sequence;
    }

    @Override
    public boolean isAvailable(WizardContext context) {
        return context.getProject() == null;
    }

    @Override
    public ProjectBuilder getModuleBuilder() {
        return this.myProjectBuilder;
    }

    @Override
    @Nullable
    public JComponent getAdditionalSettings() {
        return null;
    }

    @Override
    public void onChosen(boolean enabled) {
    }

    @Override
    public void dispose() {
        this.myProjectBuilder = null;
        super.dispose();
    }
}

