/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl.convert;

import com.intellij.conversion.CannotConvertException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDomConvertingUtil {
    @NonNls
    private static final String COMPONENT_ELEMENT = "component";
    @NonNls
    private static final String OPTION_ELEMENT = "option";
    @NonNls
    private static final String NAME_ATTRIBUTE = "name";
    @NonNls
    private static final String VALUE_ATTRIBUTE = "value";

    private JDomConvertingUtil() {
    }

    public static Document loadDocument(File file) throws CannotConvertException {
        try {
            return JDOMUtil.loadDocument((File)file);
        }
        catch (JDOMException e) {
            throw new CannotConvertException(file.getAbsolutePath() + ": " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CannotConvertException(file.getAbsolutePath() + ": " + e.getMessage(), e);
        }
    }

    public static String getOptionValue(Element element, String optionName) {
        return JDOMExternalizerUtil.readField((Element)element, (String)optionName);
    }

    @Nullable
    public static String getSettingsValue(@Nullable Element element) {
        return element != null ? element.getAttributeValue(VALUE_ATTRIBUTE) : null;
    }

    @Nullable
    public static Element getSettingsElement(@Nullable Element element, String name) {
        for (Element child : JDomConvertingUtil.getChildren(element, "setting")) {
            if (!child.getAttributeValue(NAME_ATTRIBUTE).equals(name)) continue;
            return child;
        }
        return null;
    }

    public static Condition<Element> createAttributeValueFilter(@NonNls String name, @NonNls String value) {
        return JDomConvertingUtil.createAttributeValueFilter(name, Collections.singleton(value));
    }

    public static Condition<Element> createAttributeValueFilter(final @NonNls String name, final @NonNls Collection<String> value) {
        return new Condition<Element>(){

            public boolean value(Element element) {
                return value.contains(element.getAttributeValue(name));
            }
        };
    }

    public static Condition<Element> createOptionElementFilter(@NonNls String optionName) {
        return JDomConvertingUtil.createElementWithAttributeFilter(OPTION_ELEMENT, NAME_ATTRIBUTE, optionName);
    }

    public static Condition<Element> createElementWithAttributeFilter(String elementName, String attributeName, String attributeValue) {
        return Conditions.and(JDomConvertingUtil.createElementNameFilter(elementName), JDomConvertingUtil.createAttributeValueFilter(attributeName, attributeValue));
    }

    public static void copyAttributes(Element from, Element to) {
        List attributes = from.getAttributes();
        for (Attribute attribute : attributes) {
            to.setAttribute(attribute.getName(), attribute.getValue());
        }
    }

    public static void copyChildren(Element from, Element to) {
        JDomConvertingUtil.copyChildren(from, to, (Condition<Element>)Condition.TRUE);
    }

    public static void copyChildren(Element from, Element to, Condition<Element> filter) {
        List list = from.getChildren();
        for (Element element : list) {
            if (!filter.value((Object)element)) continue;
            to.addContent((Element)element.clone());
        }
    }

    @Nullable
    public static Element findComponent(Element root, @NonNls String componentName) {
        List list = root.getChildren(COMPONENT_ELEMENT);
        for (Element element : list) {
            if (!componentName.equals(element.getAttributeValue(NAME_ATTRIBUTE))) continue;
            return element;
        }
        return null;
    }

    public static Condition<Element> createElementNameFilter(final @NonNls String elementName) {
        return new Condition<Element>(){

            public boolean value(Element element) {
                return elementName.equals(element.getName());
            }
        };
    }

    public static List<Element> removeChildren(Element element, Condition<Element> filter) {
        ArrayList<Element> toRemove = new ArrayList<Element>();
        List list = element.getChildren();
        for (Element e : list) {
            if (!filter.value((Object)e)) continue;
            toRemove.add(e);
        }
        for (Element e : toRemove) {
            element.removeContent((Content)e);
        }
        return toRemove;
    }

    public static Element createOptionElement(String name, String value) {
        Element element = new Element(OPTION_ELEMENT);
        element.setAttribute(NAME_ATTRIBUTE, name);
        element.setAttribute(VALUE_ATTRIBUTE, value);
        return element;
    }

    public static void addChildAfter(Element parent, Element child, Condition<Element> filter, boolean addFirstIfNotFound) {
        List list = parent.getContent();
        for (int i = 0; i < list.size(); ++i) {
            Object o = list.get(i);
            if (!(o instanceof Element) || !filter.value((Object)((Element)o))) continue;
            if (i < list.size() - 1) {
                parent.addContent(i + 1, (Content)child);
            } else {
                parent.addContent(child);
            }
            return;
        }
        if (addFirstIfNotFound) {
            parent.addContent(0, (Content)child);
        }
    }

    public static Element createComponentElement(String componentName) {
        Element element = new Element(COMPONENT_ELEMENT);
        element.setAttribute(NAME_ATTRIBUTE, componentName);
        return element;
    }

    @NotNull
    public static Element findOrCreateComponentElement(@NotNull Element root, @NotNull String componentName) {
        if (root == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/impl/convert/JDomConvertingUtil.findOrCreateComponentElement must not be null");
        }
        if (componentName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/impl/convert/JDomConvertingUtil.findOrCreateComponentElement must not be null");
        }
        Element component = JDomConvertingUtil.findComponent(root, componentName);
        if (component == null) {
            component = JDomConvertingUtil.createComponentElement(componentName);
            JDomConvertingUtil.addComponent(root, component);
        }
        Element element = component;
        if (element == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/impl/convert/JDomConvertingUtil.findOrCreateComponentElement must not return null");
        }
        return element;
    }

    public static void addComponent(Element root, Element component) {
        String componentName = component.getAttributeValue(NAME_ATTRIBUTE);
        Element old = JDomConvertingUtil.findComponent(root, componentName);
        if (old != null) {
            root.removeContent((Content)old);
        }
        for (int i = 0; i < root.getContent().size(); ++i) {
            String name;
            Element element;
            Object o = root.getContent().get(i);
            if (!(o instanceof Element) || !(element = (Element)o).getName().equals(COMPONENT_ELEMENT) || componentName.compareTo(name = element.getAttributeValue(NAME_ATTRIBUTE)) >= 0) continue;
            root.addContent(i, (Content)component);
            return;
        }
        root.addContent(component);
    }

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent) {
        List list = parent != null ? parent.getChildren() : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/impl/convert/JDomConvertingUtil.getChildren must not return null");
        }
        return list;
    }

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/impl/convert/JDomConvertingUtil.getChildren must not be null");
        }
        List list = parent != null ? parent.getChildren(name) : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/impl/convert/JDomConvertingUtil.getChildren must not return null");
        }
        return list;
    }

    @Nullable
    public static Element findChild(Element parent, Condition<Element> filter) {
        List list = parent.getChildren();
        for (Element e : list) {
            if (!filter.value((Object)e)) continue;
            return e;
        }
        return null;
    }

    public static void removeDuplicatedOptions(Element element) {
        ArrayList children = new ArrayList(element.getChildren(OPTION_ELEMENT));
        HashSet<String> names = new HashSet<String>();
        for (Element child : children) {
            if (names.add(child.getAttributeValue(NAME_ATTRIBUTE))) continue;
            element.removeContent((Content)child);
        }
    }
}

