/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.ide.util.DirectoryUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.util.Icons;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import javax.swing.Icon;

public class CreateDirectoryOrPackageAction
extends AnAction
implements DumbAware {
    public CreateDirectoryOrPackageAction() {
        super(IdeBundle.message((String)"action.create.new.directory.or.package", (Object[])new Object[0]), IdeBundle.message((String)"action.create.new.directory.or.package", (Object[])new Object[0]), null);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        PsiDirectory directory = DirectoryChooserUtil.getOrChooseDirectory(view);
        if (directory == null) {
            return;
        }
        boolean isDirectory = !PsiDirectoryFactory.getInstance(project).isPackage(directory);
        MyInputValidator validator = new MyInputValidator(project, directory, isDirectory);
        Messages.showInputDialog((Project)project, (String)(isDirectory ? IdeBundle.message((String)"prompt.enter.new.directory.name", (Object[])new Object[0]) : IdeBundle.message((String)"prompt.enter.new.package.name", (Object[])new Object[0])), (String)(isDirectory ? IdeBundle.message((String)"title.new.directory", (Object[])new Object[0]) : IdeBundle.message((String)"title.new.package", (Object[])new Object[0])), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)validator);
        if (validator.myCreatedElement == null) {
            return;
        }
        view.selectElement(validator.myCreatedElement);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setVisible(false);
            presentation.setEnabled(false);
            return;
        }
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            presentation.setVisible(false);
            presentation.setEnabled(false);
            return;
        }
        PsiDirectory[] directories = view.getDirectories();
        if (directories.length == 0) {
            presentation.setVisible(false);
            presentation.setEnabled(false);
            return;
        }
        presentation.setVisible(true);
        presentation.setEnabled(true);
        boolean isPackage = false;
        PsiDirectoryFactory factory = PsiDirectoryFactory.getInstance(project);
        for (PsiDirectory directory : directories) {
            if (!factory.isPackage(directory)) continue;
            isPackage = true;
            break;
        }
        if (isPackage) {
            presentation.setText(IdeBundle.message((String)"action.package", (Object[])new Object[0]));
            presentation.setIcon(Icons.PACKAGE_ICON);
        } else {
            presentation.setText(IdeBundle.message((String)"action.directory", (Object[])new Object[0]));
            presentation.setIcon(Icons.DIRECTORY_OPEN_ICON);
        }
    }

    protected class MyInputValidator
    implements InputValidatorEx {
        private final Project myProject;
        private final PsiDirectory myDirectory;
        private final boolean myIsDirectory;
        private PsiElement myCreatedElement = null;

        public MyInputValidator(Project project, PsiDirectory directory, boolean isDirectory) {
            this.myProject = project;
            this.myDirectory = directory;
            this.myIsDirectory = isDirectory;
        }

        public boolean checkInput(String inputString) {
            return true;
        }

        public String getErrorText(String inputString) {
            if (FileTypeManager.getInstance().isFileIgnored(inputString)) {
                return "Trying to create a " + (this.myIsDirectory ? "directory" : "package") + " with ignored name, result will not be visible";
            }
            if (!this.myIsDirectory && inputString.length() > 0 && !PsiDirectoryFactory.getInstance(this.myProject).isValidPackageName(inputString)) {
                return "Not a valid package name";
            }
            return null;
        }

        public boolean canClose(String inputString) {
            boolean multiCreation;
            final String subDirName = inputString;
            if (subDirName.length() == 0) {
                Messages.showMessageDialog((Project)this.myProject, (String)IdeBundle.message((String)"error.name.should.be.specified", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                return false;
            }
            boolean bl = this.myIsDirectory ? subDirName.indexOf(47) != -1 || subDirName.indexOf(92) != -1 : (multiCreation = subDirName.indexOf(46) != -1);
            if (!multiCreation) {
                try {
                    this.myDirectory.checkCreateSubdirectory(subDirName);
                }
                catch (IncorrectOperationException ex) {
                    Messages.showMessageDialog((Project)this.myProject, (String)CreateElementActionBase.filterMessage((String)ex.getMessage()), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                    return false;
                }
            }
            Runnable command = new Runnable(){

                @Override
                public void run() {
                    Runnable run = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            LocalHistoryAction action = LocalHistoryAction.NULL;
                            try {
                                String dirPath = MyInputValidator.this.myDirectory.getVirtualFile().getPresentableUrl();
                                String actionName = IdeBundle.message((String)"progress.creating.directory", (Object[])new Object[]{dirPath, File.separator, subDirName});
                                action = LocalHistory.startAction((Project)MyInputValidator.this.myProject, (String)actionName);
                                PsiDirectory createdDir = MyInputValidator.this.myIsDirectory ? DirectoryUtil.createSubdirectories(subDirName, MyInputValidator.this.myDirectory, "\\/") : DirectoryUtil.createSubdirectories(subDirName, MyInputValidator.this.myDirectory, ".");
                                MyInputValidator.this.myCreatedElement = (PsiElement)createdDir;
                            }
                            catch (IncorrectOperationException ex) {
                                ApplicationManager.getApplication().invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        Messages.showMessageDialog((Project)MyInputValidator.this.myProject, (String)CreateElementActionBase.filterMessage((String)ex.getMessage()), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                                    }
                                });
                            }
                            finally {
                                action.finish();
                            }
                        }
                    };
                    ApplicationManager.getApplication().runWriteAction(run);
                }
            };
            CommandProcessor.getInstance().executeCommand(this.myProject, command, this.myIsDirectory ? IdeBundle.message((String)"command.create.directory", (Object[])new Object[0]) : IdeBundle.message((String)"command.create.package", (Object[])new Object[0]), null);
            return this.myCreatedElement != null;
        }
    }
}

