/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.CopyPasteSupport;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.copy.CopyHandler;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandler;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class CopyPasteDelegator
implements CopyPasteSupport {
    private static final ExtensionPointName<PasteProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.filePasteProvider");
    private final Project myProject;
    private final JComponent myKeyReceiver;
    private final MyEditable myEditable;

    public CopyPasteDelegator(Project project, JComponent keyReceiver) {
        this.myProject = project;
        this.myKeyReceiver = keyReceiver;
        this.myEditable = new MyEditable();
    }

    @NotNull
    protected abstract PsiElement[] getSelectedElements();

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private PsiElement[] getValidSelectedElements() {
        PsiElement[] psiElementArray;
        PsiElement[] selectedElements;
        for (PsiElement element : selectedElements = this.getSelectedElements()) {
            if (element != null && element.isValid()) continue;
            psiElementArray = PsiElement.EMPTY_ARRAY;
            if (PsiElement.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/ide/CopyPasteDelegator.getValidSelectedElements must not return null");
            return psiElementArray;
        }
        psiElementArray = selectedElements;
        if (selectedElements != null) return psiElementArray;
        throw new IllegalStateException("@NotNull method com/intellij/ide/CopyPasteDelegator.getValidSelectedElements must not return null");
    }

    private void updateView() {
        this.myKeyReceiver.repaint();
    }

    public CopyProvider getCopyProvider() {
        return this.myEditable;
    }

    public CutProvider getCutProvider() {
        return this.myEditable;
    }

    public PasteProvider getPasteProvider() {
        return this.myEditable;
    }

    private class MyEditable
    implements CutProvider,
    CopyProvider,
    PasteProvider {
        private MyEditable() {
        }

        public void performCopy(DataContext dataContext) {
            PsiElement[] elements = CopyPasteDelegator.this.getValidSelectedElements();
            PsiCopyPasteManager.getInstance().setElements(elements, true);
            CopyPasteDelegator.this.updateView();
        }

        public boolean isCopyEnabled(DataContext dataContext) {
            PsiElement[] elements = CopyPasteDelegator.this.getValidSelectedElements();
            return CopyHandler.canCopy(elements) || PsiCopyPasteManager.asFileList(elements) != null;
        }

        public boolean isCopyVisible(DataContext dataContext) {
            return true;
        }

        public void performCut(DataContext dataContext) {
            PsiElement[] elements = CopyPasteDelegator.this.getValidSelectedElements();
            if (MoveHandler.adjustForMove(CopyPasteDelegator.this.myProject, elements, null) == null) {
                return;
            }
            PsiCopyPasteManager.getInstance().setElements(elements, false);
            CopyPasteDelegator.this.updateView();
        }

        public boolean isCutEnabled(DataContext dataContext) {
            PsiElement[] elements = CopyPasteDelegator.this.getValidSelectedElements();
            return elements.length != 0 && MoveHandler.canMove(elements, null);
        }

        public boolean isCutVisible(DataContext dataContext) {
            return true;
        }

        public void performPaste(DataContext dataContext) {
            if (!this.performDefaultPaste(dataContext)) {
                for (PasteProvider provider : (PasteProvider[])Extensions.getExtensions((ExtensionPointName)EP_NAME)) {
                    if (!provider.isPasteEnabled(dataContext)) continue;
                    provider.performPaste(dataContext);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean performDefaultPaste(DataContext dataContext) {
            block8: {
                boolean[] isCopied = new boolean[1];
                PsiElement[] elements = PsiCopyPasteManager.getInstance().getElements(isCopied);
                if (elements == null) {
                    return false;
                }
                try {
                    PsiElement target = (PsiElement)LangDataKeys.PASTE_TARGET_PSI_ELEMENT.getData(dataContext);
                    if (isCopied[0]) {
                        PsiDirectory[] directories;
                        PsiDirectory targetDirectory;
                        PsiDirectory psiDirectory = targetDirectory = target instanceof PsiDirectory ? (PsiDirectory)target : null;
                        if (targetDirectory == null && target instanceof PsiDirectoryContainer && (directories = ((PsiDirectoryContainer)target).getDirectories()).length > 0) {
                            targetDirectory = directories[0];
                        }
                        if (CopyHandler.canCopy(elements)) {
                            CopyHandler.doCopy(elements, targetDirectory);
                        }
                        break block8;
                    }
                    if (MoveHandler.canMove(elements, target)) {
                        MoveHandler.doMove(CopyPasteDelegator.this.myProject, elements, target, new MoveCallback(){

                            @Override
                            public void refactoringCompleted() {
                                PsiCopyPasteManager.getInstance().clear();
                            }
                        });
                        break block8;
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    CopyPasteDelegator.this.updateView();
                }
            }
            return true;
        }

        public boolean isPastePossible(DataContext dataContext) {
            return true;
        }

        public boolean isPasteEnabled(DataContext dataContext) {
            if (this.isDefaultPasteEnabled(dataContext)) {
                return true;
            }
            for (PasteProvider provider : (PasteProvider[])Extensions.getExtensions((ExtensionPointName)EP_NAME)) {
                if (!provider.isPasteEnabled(dataContext)) continue;
                return true;
            }
            return false;
        }

        private boolean isDefaultPasteEnabled(DataContext dataContext) {
            Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return false;
            }
            Object target = LangDataKeys.PASTE_TARGET_PSI_ELEMENT.getData(dataContext);
            if (target == null) {
                return false;
            }
            PsiElement[] elements = PsiCopyPasteManager.getInstance().getElements(new boolean[]{false});
            if (elements == null) {
                return false;
            }
            for (PsiElement element : elements) {
                PsiManager manager = element.getManager();
                if (manager != null && manager.getProject() == project) continue;
                return false;
            }
            return true;
        }
    }
}

