/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;

public class Paths {
    private static final char DELIM = '/';
    private static boolean myIsCaseSensitive;

    public static String getNameOf(String path) {
        int i = path.lastIndexOf(47);
        return i == -1 ? path : path.substring(i + 1);
    }

    public static String getParentOf(String path) {
        int i = path.lastIndexOf(47);
        return i == -1 ? null : path.substring(0, i);
    }

    public static String appended(String path, String child) {
        return path + '/' + child;
    }

    public static String renamed(String path, String newName) {
        String parent = Paths.getParentOf(path);
        return parent == null ? newName : Paths.appended(parent, newName);
    }

    public static String withoutRootIfUnder(String path, String root) {
        if (!Paths.isParent(root, path)) {
            return null;
        }
        if ((path = path.substring(root.length())).length() == 0) {
            return "";
        }
        if (path.charAt(0) != '/') {
            return null;
        }
        return path.substring(1);
    }

    public static boolean isParent(String parent, String path) {
        return myIsCaseSensitive ? path.startsWith(parent) : StringUtil.startsWithIgnoreCase((String)path, (String)parent);
    }

    public static boolean equals(String p1, String p2) {
        return myIsCaseSensitive ? p1.equals(p2) : p1.equalsIgnoreCase(p2);
    }

    public static void setCaseSensitive(boolean b) {
        myIsCaseSensitive = b;
    }

    public static boolean isCaseSensitive() {
        return myIsCaseSensitive;
    }

    public static void useSystemCaseSensitivity() {
        myIsCaseSensitive = SystemInfo.isFileSystemCaseSensitive;
    }

    static {
        Paths.useSystemCaseSensitivity();
    }
}

