/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.pointers;

import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.facet.FacetManagerListener;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.facet.impl.pointers.FacetPointerImpl;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointerListener;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FacetPointersManagerImpl
extends FacetPointersManager
implements ProjectComponent {
    private final Project myProject;
    private final Map<String, FacetPointerImpl> myPointers = new HashMap<String, FacetPointerImpl>();
    private final Map<Class<? extends Facet>, EventDispatcher<FacetPointerListener>> myDispatchers = new HashMap<Class<? extends Facet>, EventDispatcher<FacetPointerListener>>();

    public FacetPointersManagerImpl(Project project) {
        this.myProject = project;
    }

    public <F extends Facet> FacetPointer<F> create(F facet) {
        String id = FacetPointersManagerImpl.constructId(facet);
        FacetPointerImpl<F> pointer = this.myPointers.get(id);
        if (pointer == null) {
            if (!FacetUtil.isRegistered(facet)) {
                return this.create(id);
            }
            pointer = new FacetPointerImpl<F>(this, facet);
            this.myPointers.put(id, pointer);
        }
        return pointer;
    }

    public <F extends Facet> FacetPointer<F> create(String id) {
        FacetPointerImpl pointer = this.myPointers.get(id);
        if (pointer == null) {
            pointer = new FacetPointerImpl(this, id);
            this.myPointers.put(id, pointer);
        }
        return pointer;
    }

    <F extends Facet> void dispose(FacetPointer<F> pointer) {
        this.myPointers.remove(pointer.getId());
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("FacetPointersManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/pointers/FacetPointersManagerImpl.getComponentName must not return null");
        }
        return "FacetPointersManager";
    }

    public void initComponent() {
        FacetManagerAdapter facetListener = new FacetManagerAdapter(){

            public void facetRenamed(@NotNull Facet facet, @NotNull String oldName) {
                if (facet == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/pointers/FacetPointersManagerImpl$1.facetRenamed must not be null");
                }
                if (oldName == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/pointers/FacetPointersManagerImpl$1.facetRenamed must not be null");
                }
                FacetPointersManagerImpl.this.refreshPointers(facet.getModule());
            }
        };
        MyModuleListener moduleListener = new MyModuleListener((FacetManagerListener)facetListener);
        this.myProject.getMessageBus().connect().subscribe(ProjectTopics.MODULES, (Object)moduleListener);
        for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            moduleListener.moduleAdded(this.myProject, module);
        }
    }

    private void refreshPointers(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/pointers/FacetPointersManagerImpl.refreshPointers must not be null");
        }
        ArrayList<Pair> changed = new ArrayList<Pair>();
        for (FacetPointerImpl pointer : this.myPointers.values()) {
            String oldId = pointer.getId();
            pointer.refresh();
            if (oldId.equals(pointer.getId())) continue;
            changed.add(Pair.create((Object)pointer, (Object)oldId));
        }
        for (Pair pair : changed) {
            Class facetClass;
            FacetPointerImpl pointer = (FacetPointerImpl)pair.getFirst();
            Object facet = pointer.getFacet();
            Class clazz = facetClass = facet != null ? facet.getClass() : Facet.class;
            while (facetClass != Object.class) {
                EventDispatcher<FacetPointerListener> dispatcher = this.myDispatchers.get(facetClass);
                if (dispatcher != null) {
                    ((FacetPointerListener)dispatcher.getMulticaster()).pointerIdChanged((FacetPointer)pointer, (String)pair.getSecond());
                }
                facetClass = facetClass.getSuperclass();
            }
        }
    }

    public boolean isRegistered(FacetPointer<?> pointer) {
        return this.myPointers.containsKey(pointer.getId());
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void disposeComponent() {
    }

    public void addListener(FacetPointerListener<Facet> listener) {
        this.addListener(Facet.class, listener);
    }

    public void removeListener(FacetPointerListener<Facet> listener) {
        this.removeListener(Facet.class, listener);
    }

    public void addListener(FacetPointerListener<Facet> listener, Disposable parentDisposable) {
        this.addListener(Facet.class, listener, parentDisposable);
    }

    public <F extends Facet> void addListener(final Class<F> facetClass, final FacetPointerListener<F> listener, Disposable parentDisposable) {
        this.addListener(facetClass, listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                FacetPointersManagerImpl.this.removeListener(facetClass, listener);
            }
        });
    }

    public <F extends Facet> void addListener(Class<F> facetClass, FacetPointerListener<F> listener) {
        EventDispatcher dispatcher = this.myDispatchers.get(facetClass);
        if (dispatcher == null) {
            dispatcher = EventDispatcher.create(FacetPointerListener.class);
            this.myDispatchers.put(facetClass, (EventDispatcher<FacetPointerListener>)dispatcher);
        }
        dispatcher.addListener(listener);
    }

    public <F extends Facet> void removeListener(Class<F> facetClass, FacetPointerListener<F> listener) {
        EventDispatcher<FacetPointerListener> dispatcher = this.myDispatchers.get(facetClass);
        if (dispatcher != null) {
            dispatcher.removeListener(listener);
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    private class MyModuleListener
    extends ModuleAdapter {
        private final FacetManagerListener myFacetListener;
        private final Map<Module, MessageBusConnection> myModule2Connection = new HashMap<Module, MessageBusConnection>();

        public MyModuleListener(FacetManagerListener facetListener) {
            this.myFacetListener = facetListener;
        }

        public void moduleAdded(Project project, Module module) {
            MessageBusConnection connection = module.getMessageBus().connect();
            this.myModule2Connection.put(module, connection);
            connection.subscribe(FacetManager.FACETS_TOPIC, (Object)this.myFacetListener);
        }

        public void moduleRemoved(Project project, Module module) {
            MessageBusConnection connection = this.myModule2Connection.remove(module);
            if (connection != null) {
                connection.disconnect();
            }
        }

        public void modulesRenamed(Project project, List<Module> modules) {
            for (Module module : modules) {
                FacetPointersManagerImpl.this.refreshPointers(module);
            }
        }
    }
}

