/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.TabImpl;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerLayout {
    private final String myID;
    protected Map<String, ViewImpl> myViews = new HashMap<String, ViewImpl>();
    private final Map<String, ViewImpl.Default> myDefaultViews = new HashMap<String, ViewImpl.Default>();
    protected Set<TabImpl> myTabs = new TreeSet<TabImpl>(new Comparator<TabImpl>(){

        @Override
        public int compare(TabImpl o1, TabImpl o2) {
            return o1.getIndex() - o2.getIndex();
        }
    });
    private final Map<Integer, TabImpl.Default> myDefaultTabs = new HashMap<Integer, TabImpl.Default>();
    protected General myGeneral = new General();
    private final Map<String, Pair<String, LayoutAttractionPolicy>> myDefaultFocus = new HashMap<String, Pair<String, LayoutAttractionPolicy>>();

    public RunnerLayout(String ID2) {
        this.myID = ID2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public TabImpl getOrCreateTab(int index) {
        TabImpl tabImpl;
        TabImpl tab = this.findTab(index);
        if (tab != null) {
            tabImpl = tab;
            if (tabImpl == null) throw new IllegalStateException("@NotNull method com/intellij/execution/ui/layout/impl/RunnerLayout.getOrCreateTab must not return null");
            return tabImpl;
        }
        tab = this.createNewTab(index);
        tabImpl = tab;
        if (tabImpl != null) return tabImpl;
        throw new IllegalStateException("@NotNull method com/intellij/execution/ui/layout/impl/RunnerLayout.getOrCreateTab must not return null");
    }

    public TabImpl getDefaultTab() {
        return this.getOrCreateTab(0);
    }

    private TabImpl createNewTab(int index) {
        TabImpl.Default defaultTab = this.getOrCreateDefaultTab(index);
        TabImpl tab = defaultTab.createTab();
        this.myTabs.add(tab);
        return tab;
    }

    private TabImpl.Default getOrCreateDefaultTab(int index) {
        TabImpl.Default tab = this.myDefaultTabs.get(index);
        if (tab == null) {
            tab = new TabImpl.Default(index, null, null);
            this.myDefaultTabs.put(index, tab);
        }
        return tab;
    }

    public TabImpl createNewTab() {
        int index = 0;
        for (TabImpl each : this.myTabs) {
            if (!this.isUsed(each)) {
                return each;
            }
            if (each.getIndex() >= Integer.MAX_VALUE) break;
            index = each.getIndex() + 1;
        }
        return this.createNewTab(index);
    }

    private boolean isUsed(TabImpl tab) {
        for (ViewImpl each : this.myViews.values()) {
            if (each.getTab() != tab) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected TabImpl findTab(int index) {
        for (TabImpl each : this.myTabs) {
            if (index != each.getIndex()) continue;
            return each;
        }
        return null;
    }

    public Element getState() {
        return this.write(new Element("layout"));
    }

    public void loadState(Element state) {
        this.read(state);
    }

    public Element read(Element parentNode) {
        List tabs = parentNode.getChildren(StringUtil.getShortName((String)TabImpl.class.getName()));
        for (Object eachTabElement : tabs) {
            TabImpl eachTab = new TabImpl((Element)eachTabElement);
            this.getOrCreateTab(eachTab.getIndex()).read((Element)eachTabElement);
        }
        List views = parentNode.getChildren(StringUtil.getShortName((String)ViewImpl.class.getName()));
        for (Object content : views) {
            ViewImpl state = new ViewImpl(this, (Element)content);
            this.myViews.put(state.getID(), state);
        }
        XmlSerializer.deserializeInto((Object)this.myGeneral, (Element)parentNode.getChild(StringUtil.getShortName((String)this.myGeneral.getClass().getName(), (char)'$')));
        return parentNode;
    }

    public Element write(Element parentNode) {
        for (ViewImpl eachState : this.myViews.values()) {
            eachState.write(parentNode);
        }
        for (TabImpl eachTab : this.myTabs) {
            eachTab.write(parentNode);
        }
        parentNode.addContent(XmlSerializer.serialize((Object)this.myGeneral));
        return parentNode;
    }

    public void resetToDefault() {
        this.myViews.clear();
        for (TabImpl each : this.myTabs) {
            TabImpl.Default defaultTab = this.getOrCreateDefaultTab(each.getIndex());
            each.copyFrom(defaultTab);
        }
    }

    public boolean isToolbarHorizontal() {
        return this.myGeneral.horizontalToolbar;
    }

    public void setToolbarHorizontal(boolean horizontal) {
        this.myGeneral.horizontalToolbar = horizontal;
    }

    public ViewImpl getStateFor(Content content) {
        return this.getOrCreateView(RunnerLayout.getOrCreateContentId(content));
    }

    private static String getOrCreateContentId(Content content) {
        String id = (String)content.getUserData(ViewImpl.ID);
        if (id == null) {
            id = "UnknownView-" + content.getDisplayName();
            content.putUserData(ViewImpl.ID, (Object)id);
        }
        return id;
    }

    private ViewImpl getOrCreateView(String id) {
        if (this.myViews.containsKey(id)) {
            return this.myViews.get(id);
        }
        ViewImpl.Default defaultView = this.getOrCreateDefault(id);
        ViewImpl view = defaultView.createView(this);
        this.myViews.put(id, view);
        return view;
    }

    private ViewImpl.Default getOrCreateDefault(String id) {
        if (this.myDefaultViews.containsKey(id)) {
            return this.myDefaultViews.get(id);
        }
        return this.setDefault(id, Integer.MAX_VALUE, PlaceInGrid.bottom, false);
    }

    public TabImpl.Default setDefault(int tabID, String displayName, Icon icon) {
        TabImpl.Default tab = new TabImpl.Default(tabID, displayName, icon);
        this.myDefaultTabs.put(tabID, tab);
        return tab;
    }

    public ViewImpl.Default setDefault(String id, int tabIndex, PlaceInGrid placeInGrid, boolean isMinimized) {
        ViewImpl.Default view = new ViewImpl.Default(id, tabIndex, placeInGrid, isMinimized);
        this.myDefaultViews.put(id, view);
        return view;
    }

    public PlaceInGrid getDefaultGridPlace(Content content) {
        return this.getOrCreateDefault(RunnerLayout.getOrCreateContentId(content)).getPlaceInGrid();
    }

    public int getDefaultSelectedTabIndex() {
        return 0;
    }

    public boolean isToFocus(String id, String condition) {
        return Comparing.equal((String)id, (String)this.getToFocus(condition));
    }

    public void setToFocus(String id, String condition) {
        this.myGeneral.focusOnCondition.put(condition, id);
    }

    public void setDefaultToFocus(String id, String condition, @NotNull LayoutAttractionPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/execution/ui/layout/impl/RunnerLayout.setDefaultToFocus must not be null");
        }
        this.myDefaultFocus.put(condition, (Pair<String, LayoutAttractionPolicy>)Pair.create((Object)id, (Object)policy));
    }

    @Nullable
    public String getToFocus(String condition) {
        return this.myGeneral.focusOnCondition.containsKey(condition) ? this.myGeneral.focusOnCondition.get(condition) : (this.myDefaultFocus.containsKey(condition) ? (String)this.myDefaultFocus.get(condition).getFirst() : null);
    }

    public LayoutAttractionPolicy getAttractionPolicy(String condition) {
        Pair<String, LayoutAttractionPolicy> pair = this.myDefaultFocus.get(condition);
        return pair == null ? new LayoutAttractionPolicy.FocusOnce() : (LayoutAttractionPolicy)pair.getSecond();
    }

    public static class General {
        public volatile boolean horizontalToolbar = false;
        public volatile int selectedTab = 0;
        public volatile Map<String, String> focusOnCondition = new HashMap<String, String>();
    }
}

