/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;

public class DebuggerTreeNodeExpression {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression");

    private static boolean isSuperMethod(PsiMethod superMethod, PsiMethod overridingMethod) {
        PsiMethod[] superMethods = overridingMethod.findSuperMethods();
        for (int i = 0; i < superMethods.length; ++i) {
            if (superMethods[i] == superMethod) {
                return true;
            }
            if (!DebuggerTreeNodeExpression.isSuperMethod(superMethod, superMethods[i])) continue;
            return true;
        }
        return false;
    }

    public static PsiExpression substituteThis(PsiExpression expressionWithThis, PsiExpression howToEvaluateThis, Value howToEvaluateThisValue) throws EvaluateException {
        PsiExpression psiExpression;
        PsiType type;
        PsiExpression result = (PsiExpression)expressionWithThis.copy();
        PsiClass thisClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)result, PsiClass.class, (boolean)true);
        boolean castNeeded = true;
        if (thisClass != null && (type = howToEvaluateThis.getType()) != null) {
            if (type instanceof PsiClassType) {
                PsiClass psiClass = ((PsiClassType)type).resolve();
                if (psiClass != null && (psiClass == thisClass || psiClass.isInheritor(thisClass, true))) {
                    castNeeded = false;
                }
            } else if (type instanceof PsiArrayType) {
                LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)expressionWithThis);
                if (thisClass == JavaPsiFacade.getInstance((Project)expressionWithThis.getProject()).getElementFactory().getArrayClass(languageLevel)) {
                    castNeeded = false;
                }
            }
        }
        if (castNeeded) {
            howToEvaluateThis = DebuggerTreeNodeExpression.castToRuntimeType(howToEvaluateThis, howToEvaluateThisValue, howToEvaluateThis.getContext());
        }
        ChangeContextUtil.encodeContextInfo((PsiElement)result, false);
        try {
            psiExpression = (PsiExpression)ChangeContextUtil.decodeContextInfo((PsiElement)result, thisClass, howToEvaluateThis);
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(DebuggerBundle.message((String)"evaluation.error.invalid.this.expression", (Object[])new Object[]{result.getText(), howToEvaluateThis.getText()}), null);
        }
        try {
            return JavaPsiFacade.getInstance((Project)howToEvaluateThis.getProject()).getElementFactory().createExpressionFromText(psiExpression.getText(), howToEvaluateThis.getContext());
        }
        catch (IncorrectOperationException e) {
            throw new EvaluateException(e.getMessage(), (Throwable)e);
        }
    }

    public static PsiExpression castToRuntimeType(PsiExpression expression, Value value, PsiElement contextElement) throws EvaluateException {
        if (value instanceof ObjectReference) {
            return DebuggerTreeNodeExpression.castToType(expression, ((ObjectReference)value).referenceType(), contextElement);
        }
        return expression;
    }

    private static PsiExpression castToType(PsiExpression expression, ReferenceType valueType, PsiElement contextElement) throws EvaluateException {
        if (valueType != null) {
            Project project = expression.getProject();
            String typeName = DebuggerUtilsEx.getQualifiedClassName(valueType.name(), project);
            PsiManager manager = PsiManager.getInstance((Project)project);
            typeName = DebuggerTreeNodeExpression.normalize(typeName, contextElement, project);
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
            try {
                PsiParenthesizedExpression parenthExpression = (PsiParenthesizedExpression)elementFactory.createExpressionFromText("((" + typeName + ")expression)", null);
                ((PsiTypeCastExpression)parenthExpression.getExpression()).getOperand().replace((PsiElement)expression);
                return parenthExpression;
            }
            catch (IncorrectOperationException e) {
                throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.type.name", (Object[])new Object[]{typeName}), (Throwable)e);
            }
        }
        return expression;
    }

    public static String normalize(String qualifiedName, PsiElement contextElement, Project project) {
        if (contextElement == null) {
            return qualifiedName;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass aClass = facade.findClass(qualifiedName, GlobalSearchScope.allScope((Project)project));
        if (aClass != null) {
            return DebuggerTreeNodeExpression.normalizePsiClass(aClass, contextElement, facade.getResolveHelper());
        }
        return qualifiedName;
    }

    private static String normalizePsiClass(PsiClass psiClass, PsiElement contextElement, PsiResolveHelper helper) {
        String name = psiClass.getName();
        PsiClass aClass = helper.resolveReferencedClass(name, contextElement);
        if (psiClass.equals(aClass)) {
            return name;
        }
        PsiClass parentClass = psiClass.getContainingClass();
        if (parentClass != null) {
            return DebuggerTreeNodeExpression.normalizePsiClass(parentClass, contextElement, helper) + "." + name;
        }
        return psiClass.getQualifiedName();
    }

    public static PsiExpression getEvaluationExpression(DebuggerTreeNodeImpl node, DebuggerContextImpl context) throws EvaluateException {
        if (node.getDescriptor() instanceof ValueDescriptorImpl) {
            return ((ValueDescriptorImpl)node.getDescriptor()).getTreeEvaluation(node, context);
        }
        LOG.error(node.getDescriptor() != null ? node.getDescriptor().getClass().getName() : "null");
        return null;
    }

    public static TextWithImports createEvaluationText(final DebuggerTreeNodeImpl node, final DebuggerContextImpl context) throws EvaluateException {
        final EvaluateException[] ex = new EvaluateException[]{null};
        TextWithImports textWithImports = (TextWithImports)PsiDocumentManager.getInstance((Project)context.getProject()).commitAndRunReadAction((Computable)new Computable<TextWithImports>(){

            public TextWithImports compute() {
                try {
                    PsiExpression expressionText = DebuggerTreeNodeExpression.getEvaluationExpression(node, context);
                    if (expressionText != null) {
                        return new TextWithImportsImpl(expressionText);
                    }
                }
                catch (EvaluateException e) {
                    ex[0] = e;
                }
                return null;
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
        return textWithImports;
    }

    private static class IncorrectOperationRuntimeException
    extends RuntimeException {
        private final IncorrectOperationException myException;

        public IncorrectOperationRuntimeException(IncorrectOperationException exception) {
            this.myException = exception;
        }

        public IncorrectOperationException getException() {
            return this.myException;
        }
    }
}

