/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.ui.impl.DebuggerTreePanel;
import com.intellij.debugger.ui.impl.WatchDebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.util.Enumeration;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import org.jetbrains.annotations.NonNls;

public abstract class WatchPanel
extends DebuggerTreePanel {
    @NonNls
    private static final String HELP_ID = "debugging.debugWatches";

    public WatchPanel(Project project, DebuggerStateManager stateManager) {
        super(project, stateManager);
        this.add((Component)new JScrollPane((Component)((Object)this.getWatchTree())), "Center");
        Disposable disposable = DebuggerAction.installEditAction((JTree)((Object)this.getWatchTree()), "Debugger.EditNodeSource");
        this.registerDisposable(disposable);
    }

    @Override
    protected DebuggerTree createTreeView() {
        return new WatchDebuggerTree(this.getProject());
    }

    @Override
    protected void changeEvent(DebuggerContextImpl newContext, int event) {
        DebuggerTreeNodeImpl root;
        if (event == 0 && (root = (DebuggerTreeNodeImpl)this.getWatchTree().getModel().getRoot()) != null) {
            Enumeration e = root.rawChildren();
            while (e.hasMoreElements()) {
                DebuggerTreeNodeImpl child = (DebuggerTreeNodeImpl)e.nextElement();
                ((WatchItemDescriptor)child.getDescriptor()).setNew();
            }
        }
        this.rebuildIfVisible(event);
    }

    @Override
    protected ActionPopupMenu createPopupMenu() {
        return null;
    }

    @Override
    public Object getData(String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return super.getData(dataId);
    }

    public WatchDebuggerTree getWatchTree() {
        return (WatchDebuggerTree)this.getTree();
    }
}

