/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.settings.ThreadsViewSettings;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadGroupDescriptorImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class ThreadsDebuggerTree
extends DebuggerTree {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.impl.ThreadsDebuggerTree");

    public ThreadsDebuggerTree(Project project) {
        super(project);
    }

    @Override
    protected NodeManagerImpl createNodeManager(Project project) {
        return new NodeManagerImpl(project, this){

            @Override
            public String getContextKey(StackFrameProxyImpl frame) {
                return "ThreadsView";
            }
        };
    }

    @Override
    protected boolean isExpandable(DebuggerTreeNodeImpl node) {
        NodeDescriptorImpl descriptor = node.getDescriptor();
        if (descriptor instanceof StackFrameDescriptorImpl) {
            return false;
        }
        return descriptor.isExpandable();
    }

    @Override
    protected void build(DebuggerContextImpl context) {
        this.buildWhenPaused(context, new RefreshThreadsTreelCommand(context));
    }

    private class RefreshThreadsTreelCommand
    extends DebuggerTree.RefreshDebuggerTreeCommand {
        public RefreshThreadsTreelCommand(DebuggerContextImpl context) {
            super(context);
        }

        @Override
        public void contextAction() throws Exception {
            List groups;
            ThreadReferenceProxyImpl thread;
            boolean hasThreadToSelect;
            boolean showGroups;
            DebuggerTreeNodeImpl root;
            block16: {
                root = ThreadsDebuggerTree.this.getNodeFactory().getDefaultNode();
                showGroups = ThreadsViewSettings.getInstance().SHOW_THREAD_GROUPS;
                try {
                    DebugProcessImpl debugProcess = this.getDebuggerContext().getDebugProcess();
                    if (debugProcess == null || !debugProcess.isAttached()) {
                        return;
                    }
                    ThreadReferenceProxyImpl currentThread = ThreadsViewSettings.getInstance().SHOW_CURRENT_THREAD ? this.getSuspendContext().getThread() : null;
                    VirtualMachineProxyImpl vm = debugProcess.getVirtualMachineProxy();
                    EvaluationContextImpl evaluationContext = this.getDebuggerContext().createEvaluationContext();
                    NodeManagerImpl nodeManager = ThreadsDebuggerTree.this.getNodeFactory();
                    if (showGroups) {
                        ThreadGroupReferenceProxyImpl topCurrentGroup = null;
                        if (currentThread != null) {
                            topCurrentGroup = currentThread.threadGroupProxy();
                            if (topCurrentGroup != null) {
                                for (ThreadGroupReferenceProxyImpl parentGroup = topCurrentGroup.parent(); parentGroup != null; parentGroup = parentGroup.parent()) {
                                    topCurrentGroup = parentGroup;
                                }
                            }
                            if (topCurrentGroup != null) {
                                root.add(nodeManager.createNode(nodeManager.getThreadGroupDescriptor(null, topCurrentGroup), evaluationContext));
                            } else {
                                root.add(nodeManager.createNode(nodeManager.getThreadDescriptor(null, currentThread), evaluationContext));
                            }
                        }
                        for (ThreadGroupReferenceProxyImpl group : vm.topLevelThreadGroups()) {
                            if (group == topCurrentGroup) continue;
                            DebuggerTreeNodeImpl threadGroup = nodeManager.createNode(nodeManager.getThreadGroupDescriptor(null, group), evaluationContext);
                            root.add(threadGroup);
                        }
                    } else {
                        if (currentThread != null) {
                            root.insert(nodeManager.createNode(nodeManager.getThreadDescriptor(null, currentThread), evaluationContext), 0);
                        }
                        ArrayList<ThreadReferenceProxyImpl> allThreads = new ArrayList<ThreadReferenceProxyImpl>(vm.allThreads());
                        Collections.sort(allThreads, ThreadReferenceProxyImpl.ourComparator);
                        for (ThreadReferenceProxyImpl threadProxy : allThreads) {
                            if (threadProxy.equals(currentThread)) continue;
                            root.add(nodeManager.createNode(nodeManager.getThreadDescriptor(null, threadProxy), evaluationContext));
                        }
                    }
                }
                catch (Exception ex) {
                    root.add(MessageDescriptor.DEBUG_INFO_UNAVAILABLE);
                    if (!LOG.isDebugEnabled()) break block16;
                    LOG.debug((Throwable)ex);
                }
            }
            boolean bl = hasThreadToSelect = (thread = this.getSuspendContext().getThread()) != null;
            if (hasThreadToSelect && showGroups) {
                groups = new ArrayList();
                for (ThreadGroupReferenceProxyImpl group = thread.threadGroupProxy(); group != null; group = group.parent()) {
                    groups.add(group);
                }
                Collections.reverse(groups);
            } else {
                groups = Collections.emptyList();
            }
            DebuggerInvocationUtil.swingInvokeLater(ThreadsDebuggerTree.this.getProject(), new Runnable(){

                @Override
                public void run() {
                    ThreadsDebuggerTree.this.getMutableModel().setRoot(root);
                    ThreadsDebuggerTree.this.treeChanged();
                    if (hasThreadToSelect) {
                        RefreshThreadsTreelCommand.this.selectThread(groups, thread, true);
                    }
                }
            });
        }

        private void selectThread(final List<ThreadGroupReferenceProxyImpl> pathToThread, final ThreadReferenceProxyImpl thread, final boolean expand) {
            LOG.assertTrue(SwingUtilities.isEventDispatchThread());
            class MyTreeModelAdapter
            extends TreeModelAdapter {
                MyTreeModelAdapter() {
                }

                private void structureChanged(DebuggerTreeNodeImpl node) {
                    Enumeration enumeration = node.children();
                    while (enumeration.hasMoreElements()) {
                        DebuggerTreeNodeImpl child = (DebuggerTreeNodeImpl)enumeration.nextElement();
                        this.nodeChanged(child);
                    }
                }

                private void nodeChanged(DebuggerTreeNodeImpl debuggerTreeNode) {
                    if (pathToThread.size() == 0) {
                        if (debuggerTreeNode.getDescriptor() instanceof ThreadDescriptorImpl && ((ThreadDescriptorImpl)debuggerTreeNode.getDescriptor()).getThreadReference() == thread) {
                            this.removeListener();
                            TreePath treePath = new TreePath(debuggerTreeNode.getPath());
                            ThreadsDebuggerTree.this.setSelectionPath(treePath);
                            if (expand && !ThreadsDebuggerTree.this.isExpanded(treePath)) {
                                ThreadsDebuggerTree.this.expandPath(treePath);
                            }
                        }
                    } else if (debuggerTreeNode.getDescriptor() instanceof ThreadGroupDescriptorImpl && ((ThreadGroupDescriptorImpl)debuggerTreeNode.getDescriptor()).getThreadGroupReference() == pathToThread.get(0)) {
                        pathToThread.remove(0);
                        ThreadsDebuggerTree.this.expandPath(new TreePath(debuggerTreeNode.getPath()));
                    }
                }

                private void removeListener() {
                    final MyTreeModelAdapter listener = this;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ThreadsDebuggerTree.this.getModel().removeTreeModelListener((TreeModelListener)listener);
                        }
                    });
                }

                public void treeStructureChanged(TreeModelEvent event) {
                    if (event.getPath().length <= 1) {
                        this.removeListener();
                        return;
                    }
                    this.structureChanged((DebuggerTreeNodeImpl)event.getTreePath().getLastPathComponent());
                }
            }
            MyTreeModelAdapter listener = new MyTreeModelAdapter();
            listener.structureChanged((DebuggerTreeNodeImpl)ThreadsDebuggerTree.this.getModel().getRoot());
            ThreadsDebuggerTree.this.getModel().addTreeModelListener((TreeModelListener)((Object)listener));
        }
    }
}

