/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.settings.ArrayRendererConfigurable;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import javax.swing.Action;
import javax.swing.Icon;

public class AdjustArrayRangeAction
extends DebuggerAction {
    public void actionPerformed(AnActionEvent e) {
        DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
        if (debuggerContext == null) {
            return;
        }
        DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
        if (debugProcess == null) {
            return;
        }
        Project project = debuggerContext.getProject();
        final DebuggerTreeNodeImpl selectedNode = AdjustArrayRangeAction.getSelectedNode(e.getDataContext());
        if (selectedNode == null) {
            return;
        }
        NodeDescriptorImpl descriptor = selectedNode.getDescriptor();
        if (!(descriptor instanceof ValueDescriptorImpl) || !((ValueDescriptorImpl)descriptor).isArray()) {
            return;
        }
        ArrayRenderer renderer = (ArrayRenderer)((ValueDescriptorImpl)selectedNode.getDescriptor()).getLastRenderer();
        String title = AdjustArrayRangeAction.createNodeTitle("", selectedNode);
        String label = selectedNode.toString();
        int index = label.indexOf(61);
        if (index > 0) {
            title = title + " " + label.substring(index);
        }
        final ArrayRenderer cloneRenderer = renderer.clone();
        SingleConfigurableEditor editor = new SingleConfigurableEditor(project, new NamedArrayConfigurable(title, cloneRenderer)){

            @Override
            protected Action[] createActions() {
                Action[] actionArray;
                String helpTopic = this.getConfigurable().getHelpTopic();
                if (helpTopic != null) {
                    Action[] actionArray2 = new Action[3];
                    actionArray2[0] = this.getOKAction();
                    actionArray2[1] = this.getCancelAction();
                    actionArray = actionArray2;
                    actionArray2[2] = this.getHelpAction();
                } else {
                    Action[] actionArray3 = new Action[2];
                    actionArray3[0] = this.getOKAction();
                    actionArray = actionArray3;
                    actionArray3[1] = this.getCancelAction();
                }
                return actionArray;
            }
        };
        editor.show();
        if (editor.getExitCode() == 0) {
            debugProcess.getManagerThread().schedule(new SuspendContextCommandImpl(debuggerContext.getSuspendContext()){

                @Override
                public void contextAction() throws Exception {
                    selectedNode.setRenderer(cloneRenderer);
                }
            });
        }
    }

    public void update(AnActionEvent e) {
        boolean enable = false;
        DebuggerTreeNodeImpl selectedNode = AdjustArrayRangeAction.getSelectedNode(e.getDataContext());
        if (selectedNode != null) {
            NodeDescriptorImpl descriptor = selectedNode.getDescriptor();
            enable = descriptor instanceof ValueDescriptorImpl && ((ValueDescriptorImpl)descriptor).isArray() && ((ValueDescriptorImpl)descriptor).getLastRenderer() instanceof ArrayRenderer;
        }
        e.getPresentation().setVisible(enable);
    }

    private static String createNodeTitle(String prefix, DebuggerTreeNodeImpl node) {
        if (node != null) {
            DebuggerTreeNodeImpl parent = node.getParent();
            NodeDescriptorImpl descriptor = parent.getDescriptor();
            if (descriptor instanceof ValueDescriptorImpl && ((ValueDescriptorImpl)descriptor).isArray()) {
                int index = parent.getIndex(node);
                return AdjustArrayRangeAction.createNodeTitle(prefix, parent) + "[" + index + "]";
            }
            String name = node.getDescriptor() != null ? node.getDescriptor().getName() : null;
            return name != null ? prefix + " " + name : prefix;
        }
        return prefix;
    }

    private static class NamedArrayConfigurable
    extends ArrayRendererConfigurable
    implements Configurable {
        private final String myTitle;

        public NamedArrayConfigurable(String title, ArrayRenderer renderer) {
            super(renderer);
            this.myTitle = title;
        }

        public String getDisplayName() {
            return this.myTitle;
        }

        public Icon getIcon() {
            return null;
        }

        public String getHelpTopic() {
            return null;
        }
    }
}

