/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant.artifacts;

import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.Tag;
import com.intellij.compiler.ant.taskdefs.ZipFileSet;
import com.intellij.packaging.elements.AntCopyInstructionCreator;
import org.jetbrains.annotations.NotNull;

public class ArchiveAntCopyInstructionCreator
implements AntCopyInstructionCreator {
    private String myPrefix;

    public ArchiveAntCopyInstructionCreator(String prefix) {
        this.myPrefix = prefix;
    }

    @NotNull
    public Tag createDirectoryContentCopyInstruction(@NotNull String dirPath) {
        if (dirPath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/ant/artifacts/ArchiveAntCopyInstructionCreator.createDirectoryContentCopyInstruction must not be null");
        }
        ZipFileSet zipFileSet = new ZipFileSet(dirPath, this.myPrefix, true);
        if (zipFileSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/ant/artifacts/ArchiveAntCopyInstructionCreator.createDirectoryContentCopyInstruction must not return null");
        }
        return zipFileSet;
    }

    @NotNull
    public Tag createFileCopyInstruction(@NotNull String filePath, String outputFileName) {
        if (filePath == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/compiler/ant/artifacts/ArchiveAntCopyInstructionCreator.createFileCopyInstruction must not be null");
        }
        String relativePath = this.myPrefix + "/" + outputFileName;
        ZipFileSet zipFileSet = new ZipFileSet(filePath, relativePath, false);
        if (zipFileSet == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/ant/artifacts/ArchiveAntCopyInstructionCreator.createFileCopyInstruction must not return null");
        }
        return zipFileSet;
    }

    @NotNull
    public AntCopyInstructionCreator subFolder(String directoryName) {
        ArchiveAntCopyInstructionCreator archiveAntCopyInstructionCreator = new ArchiveAntCopyInstructionCreator(this.myPrefix + "/" + directoryName);
        if (archiveAntCopyInstructionCreator == null) {
            throw new IllegalStateException("@NotNull method com/intellij/compiler/ant/artifacts/ArchiveAntCopyInstructionCreator.subFolder must not return null");
        }
        return archiveAntCopyInstructionCreator;
    }

    public Generator createSubFolderCommand(String directoryName) {
        return null;
    }
}

