/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerImpl;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefFieldImpl;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaFileImpl;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.reference.RefPackageImpl;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefParameterImpl;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashMap;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class RefJavaManagerImpl
extends RefJavaManager {
    private static final Logger LOG = Logger.getInstance((String)("#" + RefJavaManagerImpl.class.getName()));
    private PsiMethod myAppMainPattern;
    private PsiMethod myAppPremainPattern;
    private PsiClass myApplet;
    private PsiClass myServlet;
    private RefPackage myDefaultPackage;
    private THashMap<String, RefPackage> myPackages;
    private final RefManagerImpl myRefManager;
    private PsiElementVisitor myProjectIterator;
    private EntryPointsManager myEntryPointsManager;

    public RefJavaManagerImpl(RefManagerImpl manager) {
        this.myRefManager = manager;
        Project project = manager.getProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
        try {
            this.myAppMainPattern = factory.createMethodFromText("void main(String[] args);", null);
            this.myAppPremainPattern = factory.createMethodFromText("void premain(String[] args, java.lang.instrument.Instrumentation i);", null);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        this.myApplet = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass("java.applet.Applet", GlobalSearchScope.allScope((Project)project));
        this.myServlet = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass("javax.servlet.Servlet", GlobalSearchScope.allScope((Project)project));
    }

    public RefPackage getPackage(String packageName) {
        RefPackage refPackage;
        if (this.myPackages == null) {
            this.myPackages = new THashMap();
        }
        if ((refPackage = (RefPackage)this.myPackages.get((Object)packageName)) == null) {
            refPackage = new RefPackageImpl(packageName, this.myRefManager);
            this.myPackages.put((Object)packageName, (Object)refPackage);
            int dotIndex = packageName.lastIndexOf(46);
            if (dotIndex >= 0) {
                ((RefPackageImpl)this.getPackage(packageName.substring(0, dotIndex))).add((RefEntity)refPackage);
            } else {
                ((RefProjectImpl)this.myRefManager.getRefProject()).add((RefEntity)refPackage);
            }
        }
        return refPackage;
    }

    public RefPackage getDefaultPackage() {
        if (this.myDefaultPackage == null) {
            this.myDefaultPackage = this.getPackage(InspectionsBundle.message((String)"inspection.reference.default.package", (Object[])new Object[0]));
        }
        return this.myDefaultPackage;
    }

    public PsiMethod getAppMainPattern() {
        return this.myAppMainPattern;
    }

    public PsiMethod getAppPremainPattern() {
        return this.myAppPremainPattern;
    }

    public PsiClass getApplet() {
        return this.myApplet;
    }

    public PsiClass getServlet() {
        return this.myServlet;
    }

    public RefParameter getParameterReference(PsiParameter param, int index) {
        LOG.assertTrue(this.myRefManager.isValidPointForReference(), (Object)"References may become invalid after process is finished");
        RefElement ref = this.myRefManager.getFromRefTable((PsiElement)param);
        if (ref == null) {
            ref = new RefParameterImpl(param, index, (RefManager)this.myRefManager);
            ((RefParameterImpl)ref).initialize();
            this.myRefManager.putToRefTable((PsiElement)param, ref);
        }
        return (RefParameter)ref;
    }

    public void iterate(RefVisitor visitor) {
        if (this.myPackages != null) {
            for (RefPackage refPackage : this.myPackages.values()) {
                refPackage.accept(visitor);
            }
        }
        THashMap<PsiAnchor, RefElement> refTable = this.myRefManager.getRefTable();
        for (RefElement refElement : refTable.values()) {
            RefClass refClass;
            RefMethod refDefaultConstructor;
            if (!(refElement instanceof RefClass) || !((refDefaultConstructor = (refClass = (RefClass)refElement).getDefaultConstructor()) instanceof RefImplicitConstructor)) continue;
            refClass.getDefaultConstructor().accept(visitor);
        }
    }

    public void cleanup() {
        if (this.myEntryPointsManager != null) {
            this.myEntryPointsManager.cleanup();
            this.myEntryPointsManager = null;
        }
        this.myPackages = null;
        this.myApplet = null;
        this.myAppMainPattern = null;
        this.myAppPremainPattern = null;
        this.myServlet = null;
        this.myDefaultPackage = null;
        this.myProjectIterator = null;
    }

    public void removeReference(RefElement refElement) {
        if (refElement instanceof RefMethod) {
            RefParameter[] params;
            RefMethod refMethod = (RefMethod)refElement;
            for (RefParameter param : params = refMethod.getParameters()) {
                this.myRefManager.removeReference((RefElement)param);
            }
        }
    }

    @Nullable
    public RefElement createRefElement(PsiElement elem) {
        if (elem instanceof PsiClass) {
            return new RefClassImpl((PsiClass)elem, (RefManager)this.myRefManager);
        }
        if (elem instanceof PsiMethod) {
            return new RefMethodImpl((PsiMethod)elem, (RefManager)this.myRefManager);
        }
        if (elem instanceof PsiField) {
            return new RefFieldImpl((PsiField)elem, (RefManager)this.myRefManager);
        }
        if (elem instanceof PsiJavaFile) {
            return new RefJavaFileImpl((PsiJavaFile)elem, (RefManager)this.myRefManager);
        }
        return null;
    }

    @Nullable
    public RefEntity getReference(String type, String fqName) {
        if ("method".equals(type)) {
            return RefMethodImpl.methodFromExternalName(this.myRefManager, fqName);
        }
        if ("class".equals(type)) {
            return RefClassImpl.classFromExternalName(this.myRefManager, fqName);
        }
        if ("field".equals(type)) {
            return RefFieldImpl.fieldFromExternalName(this.myRefManager, fqName);
        }
        if ("parameter".equals(type)) {
            return RefParameterImpl.parameterFromExternalName(this.myRefManager, fqName);
        }
        if ("package".equals(type)) {
            return RefPackageImpl.packageFromFQName(this.myRefManager, fqName);
        }
        return null;
    }

    @Nullable
    public String getType(RefEntity ref) {
        if (ref instanceof RefMethod) {
            return "method";
        }
        if (ref instanceof RefClass) {
            return "class";
        }
        if (ref instanceof RefField) {
            return "field";
        }
        if (ref instanceof RefParameter) {
            return "parameter";
        }
        if (ref instanceof RefPackage) {
            return "package";
        }
        return null;
    }

    public RefEntity getRefinedElement(RefEntity ref) {
        if (ref instanceof RefImplicitConstructor) {
            return ((RefImplicitConstructor)ref).getOwnerClass();
        }
        return ref;
    }

    public void visitElement(PsiElement element) {
        if (this.myProjectIterator == null) {
            this.myProjectIterator = new MyJavaElementVisitor();
        }
        element.accept(this.myProjectIterator);
    }

    @Nullable
    public String getGroupName(RefEntity entity) {
        if (entity instanceof RefFile && !(entity instanceof RefJavaFileImpl)) {
            return null;
        }
        return RefJavaUtil.getInstance().getPackageName(entity);
    }

    public boolean belongsToScope(PsiElement psiElement) {
        return !(psiElement instanceof PsiTypeParameter);
    }

    public void export(RefEntity refEntity, Element element) {
        PsiFile psiFile;
        PsiElement psiElement;
        if (refEntity instanceof RefElement && (psiElement = ((RefElement)refEntity).getElement()) != null && (psiFile = psiElement.getContainingFile()) instanceof PsiJavaFile) {
            RefJavaManagerImpl.appendPackageElement(element, ((PsiJavaFile)psiFile).getPackageName());
        }
    }

    private static void appendPackageElement(Element element, String packageName) {
        Element packageElement = new Element("package");
        packageElement.addContent(packageName.length() > 0 ? packageName : InspectionsBundle.message((String)"inspection.export.results.default", (Object[])new Object[0]));
        element.addContent(packageElement);
    }

    public EntryPointsManager getEntryPointsManager() {
        if (this.myEntryPointsManager == null) {
            Project project = this.myRefManager.getProject();
            this.myEntryPointsManager = new EntryPointsManagerImpl(project);
            ((EntryPointsManagerImpl)this.myEntryPointsManager).addAllPersistentEntries(EntryPointsManagerImpl.getInstance(project));
        }
        return this.myEntryPointsManager;
    }

    private class MyJavaElementVisitor
    extends JavaElementVisitor {
        private final RefJavaUtil myRefUtil = RefJavaUtil.getInstance();

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitElement((PsiElement)expression);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
        }

        public void visitReferenceParameterList(PsiReferenceParameterList list) {
            PsiType[] typeArguments;
            super.visitReferenceParameterList(list);
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)list, PsiMember.class);
            for (PsiType type : typeArguments = list.getTypeArguments()) {
                this.myRefUtil.addTypeReference((PsiElement)member, type, (RefManager)RefJavaManagerImpl.this.myRefManager);
            }
        }

        public void visitClass(PsiClass aClass) {
            if (!(aClass instanceof PsiTypeParameter)) {
                super.visitClass(aClass);
                RefElement refClass = RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)aClass);
                if (refClass != null) {
                    ((RefClassImpl)refClass).buildReferences();
                }
            }
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            RefElement refElement = RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)method);
            if (refElement instanceof RefMethod) {
                ((RefMethodImpl)refElement).buildReferences();
            }
        }

        public void visitField(PsiField field) {
            super.visitField(field);
            RefElement refElement = RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)field);
            if (refElement instanceof RefField) {
                ((RefFieldImpl)refElement).buildReferences();
            }
        }

        public void visitDocComment(PsiDocComment comment) {
            PsiDocTag[] tags;
            super.visitDocComment(comment);
            for (PsiDocTag tag : tags = comment.getTags()) {
                RefElementImpl element;
                PsiModifierListOwner listOwner;
                PsiElement[] dataElements;
                if (!Comparing.strEqual((String)tag.getName(), (String)"noinspection") || (dataElements = tag.getDataElements()) == null || dataElements.length <= 0 || (listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)comment, PsiModifierListOwner.class)) == null || (element = (RefElementImpl)RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)listOwner)) == null) continue;
                String suppressions = "";
                for (PsiElement dataElement : dataElements) {
                    suppressions = suppressions + "," + dataElement.getText();
                }
                element.addSuppression(suppressions);
            }
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            RefElementImpl element;
            PsiModifierListOwner listOwner;
            super.visitAnnotation(annotation);
            if (Comparing.strEqual((String)annotation.getQualifiedName(), (String)"java.lang.SuppressWarnings") && (listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiModifierListOwner.class)) != null && (element = (RefElementImpl)RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)listOwner)) != null) {
                PsiNameValuePair[] nameValuePairs;
                StringBuffer buf = new StringBuffer();
                for (PsiNameValuePair nameValuePair : nameValuePairs = annotation.getParameterList().getAttributes()) {
                    buf.append(",").append(nameValuePair.getText().replaceAll("[{}\"\"]", ""));
                }
                if (buf.length() > 0) {
                    element.addSuppression(buf.substring(1));
                }
            }
        }

        public void visitVariable(PsiVariable variable) {
            super.visitVariable(variable);
            this.myRefUtil.addTypeReference((PsiElement)variable, variable.getType(), (RefManager)RefJavaManagerImpl.this.myRefManager);
        }

        public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
            super.visitInstanceOfExpression(expression);
            PsiTypeElement typeElement = expression.getCheckType();
            if (typeElement != null) {
                this.myRefUtil.addTypeReference((PsiElement)expression, typeElement.getType(), (RefManager)RefJavaManagerImpl.this.myRefManager);
            }
        }

        public void visitThisExpression(PsiThisExpression expression) {
            super.visitThisExpression(expression);
            PsiJavaCodeReferenceElement qualifier = expression.getQualifier();
            if (qualifier != null) {
                RefClassImpl refClass;
                this.myRefUtil.addTypeReference((PsiElement)expression, expression.getType(), (RefManager)RefJavaManagerImpl.this.myRefManager);
                RefClass ownerClass = this.myRefUtil.getOwnerClass((RefManager)RefJavaManagerImpl.this.myRefManager, (PsiElement)expression);
                if (ownerClass != null && (refClass = (RefClassImpl)RefJavaManagerImpl.this.myRefManager.getReference(qualifier.resolve())) != null) {
                    refClass.addInstanceReference((RefElement)ownerClass);
                }
            }
        }
    }
}

