/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.DescriptorProviderInspection;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.openapi.actionSystem.AnActionEvent;

public class LocalQuickFixWrapper
extends QuickFixAction {
    private final QuickFix myFix;
    private String myText;

    public LocalQuickFixWrapper(QuickFix fix, DescriptorProviderInspection tool) {
        super(fix.getName(), tool);
        this.myTool = tool;
        this.myFix = fix;
        this.myText = this.myFix.getName();
    }

    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        this.getTemplatePresentation().setText(this.myText);
        e.getPresentation().setText(this.myText);
    }

    @Override
    public String getText(RefEntity where) {
        return this.myText;
    }

    public void setText(String text) {
        this.myText = text;
    }

    @Override
    protected boolean applyFix(RefElement[] refElements) {
        return true;
    }

    @Override
    protected boolean isProblemDescriptorsAcceptable() {
        return true;
    }

    public QuickFix getFix() {
        return this.myFix;
    }
}

