/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import java.beans.PropertyChangeListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LookupManager {
    @NonNls
    public static final String PROP_ACTIVE_LOOKUP = "activeLookup";

    public static LookupManager getInstance(Project project) {
        return (LookupManager)project.getComponent(LookupManager.class);
    }

    @Nullable
    public static Lookup getActiveLookup(Editor editor) {
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        return LookupManager.getInstance(project).getActiveLookup();
    }

    public Lookup showLookup(Editor editor, LookupElement ... items) {
        if (items == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupManager.showLookup must not be null");
        }
        return this.showLookup(editor, items, "", LookupArranger.DEFAULT);
    }

    public Lookup showLookup(Editor editor, @NotNull LookupElement[] items, String prefix) {
        if (items == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/lookup/LookupManager.showLookup must not be null");
        }
        return this.showLookup(editor, items, prefix, LookupArranger.DEFAULT);
    }

    public abstract Lookup showLookup(Editor var1, @NotNull LookupElement[] var2, String var3, @NotNull LookupArranger var4);

    public abstract void hideActiveLookup();

    public abstract Lookup getActiveLookup();

    public abstract void addPropertyChangeListener(PropertyChangeListener var1);

    public abstract void removePropertyChangeListener(PropertyChangeListener var1);

    public abstract boolean isDisposed();

    public abstract Lookup createLookup(Editor var1, @NotNull LookupElement[] var2, String var3, LookupArranger var4);
}

