/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupValueWithPsiElement;
import com.intellij.codeInsight.lookup.LookupValueWithUIHint;
import com.intellij.codeInsight.lookup.PresentableLookupValue;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.Icons;
import com.intellij.util.ui.EmptyIcon;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class DefaultLookupItemRenderer
extends LookupElementRenderer<LookupItem> {
    public static final DefaultLookupItemRenderer INSTANCE = new DefaultLookupItemRenderer();
    private static final Icon SAMPLE_ICON = Icons.CLASS_ICON;

    public void renderElement(LookupItem item, LookupElementPresentation presentation) {
        presentation.setIcon(DefaultLookupItemRenderer.getRawIcon(item, presentation.isReal()));
        presentation.setItemText(DefaultLookupItemRenderer.getName(item));
        presentation.setStrikeout(DefaultLookupItemRenderer.isToStrikeout(item));
        presentation.setItemTextBold(item.getAttribute(LookupItem.HIGHLIGHTED_ATTR) != null);
        presentation.setTailText(DefaultLookupItemRenderer.getText2(item), item.getAttribute(LookupItem.TAIL_TEXT_SMALL_ATTR) != null);
        presentation.setTypeText(DefaultLookupItemRenderer.getText3(item), null);
    }

    @Nullable
    public static Icon getRawIcon(LookupItem item, boolean real) {
        PsiElement element;
        Icon icon = (Icon)item.getAttribute(LookupItem.ICON_ATTR);
        if (icon != null) {
            return icon;
        }
        Object o = item.getObject();
        int flags = 1;
        if (!real) {
            if (item.getObject() instanceof String) {
                return new EmptyIcon(0, 0);
            }
            return new EmptyIcon(SAMPLE_ICON.getIconWidth() * 2, SAMPLE_ICON.getIconHeight());
        }
        if (o instanceof Iconable && !(o instanceof PsiElement)) {
            return ((Iconable)o).getIcon(flags);
        }
        if (o instanceof LookupValueWithPsiElement) {
            o = ((LookupValueWithPsiElement)o).getElement();
        }
        if (o instanceof PsiElement && (element = (PsiElement)o).isValid()) {
            return element.getIcon(flags);
        }
        return null;
    }

    @Nullable
    private static String getText3(LookupItem item) {
        Object o = item.getObject();
        String text = o instanceof LookupValueWithUIHint ? ((LookupValueWithUIHint)o).getTypeHint() : (String)item.getAttribute(LookupItem.TYPE_TEXT_ATTR);
        return text;
    }

    private static String getText2(LookupItem item) {
        return (String)item.getAttribute(LookupItem.TAIL_TEXT_ATTR);
    }

    private static boolean isToStrikeout(LookupItem item) {
        return item.getAttribute(LookupItem.DEPRECATED_ATTR) != null;
    }

    private static String getName(LookupItem item) {
        String presentableText = item.getPresentableText();
        if (presentableText != null) {
            return presentableText;
        }
        Object o = item.getObject();
        String name = null;
        if (o instanceof PsiElement) {
            PsiElement element = (PsiElement)o;
            if (element.isValid()) {
                name = PsiUtilBase.getName((PsiElement)element);
            }
        } else {
            name = o instanceof PsiMetaData ? ((PsiMetaData)o).getName() : (o instanceof PresentableLookupValue ? ((PresentableLookupValue)o).getPresentation() : String.valueOf(o));
        }
        if (name == null) {
            name = "";
        }
        return name;
    }
}

