/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUIContextEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.ui.SideBorder;
import com.intellij.ui.SplittingUtil;
import com.intellij.ui.StrikeoutLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.EnumSet;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.jetbrains.annotations.NotNull;

class ParameterInfoComponent
extends JPanel {
    private final Object[] myObjects;
    private int myCurrentParameterIndex;
    private PsiElement myParameterOwner;
    private Object myHighlighted;
    @NotNull
    private final ParameterInfoHandler myHandler;
    private final OneElementComponent[] myPanels;
    private static final Color BACKGROUND_COLOR = HintUtil.INFORMATION_COLOR;
    private static final Color FOREGROUND_COLOR = new Color(0, 0, 0);
    private static final Color DISABLED_FOREGROUND_COLOR = new Color(128, 128, 128);
    private static final Color HIGHLIGHTED_BORDER_COLOR = new Color(231, 254, 234);
    private final Font NORMAL_FONT;
    private final Font BOLD_FONT;
    private static final Border BOTTOM_BORDER = new SideBorder(Color.lightGray, 8);
    private static final Border BACKGROUND_BORDER = BorderFactory.createLineBorder(BACKGROUND_COLOR);
    protected int myWidthLimit;

    public ParameterInfoComponent(Object[] objects, Editor editor, @NotNull ParameterInfoHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/hint/ParameterInfoComponent.<init> must not be null");
        }
        super(new GridBagLayout());
        JComponent editorComponent = editor.getComponent();
        JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
        this.myWidthLimit = layeredPane.getWidth();
        this.NORMAL_FONT = UIUtil.getLabelFont();
        this.BOLD_FONT = this.NORMAL_FONT.deriveFont(1);
        this.myObjects = objects;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createCompoundBorder(LineBorder.createGrayLineBorder(), BorderFactory.createEmptyBorder(0, 5, 0, 5)));
        this.setBackground(BACKGROUND_COLOR);
        this.myHandler = handler;
        this.myPanels = new OneElementComponent[this.myObjects.length];
        for (int i = 0; i < this.myObjects.length; ++i) {
            this.myPanels[i] = new OneElementComponent();
            this.add((Component)this.myPanels[i], new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.myCurrentParameterIndex = -1;
    }

    public void update() {
        MyParameterContext context = new MyParameterContext();
        for (int i = 0; i < this.myObjects.length; ++i) {
            context.i = i;
            Object o = this.myObjects[i];
            this.myHandler.updateUI(o, (ParameterInfoUIContext)context);
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public Object[] getObjects() {
        return this.myObjects;
    }

    void setEnabled(int index, boolean enabled) {
        this.myPanels[index].setEnabled(enabled);
    }

    boolean isEnabled(int index) {
        return this.myPanels[index].isEnabled();
    }

    public void setCurrentParameterIndex(int currentParameterIndex) {
        this.myCurrentParameterIndex = currentParameterIndex;
    }

    public int getCurrentParameterIndex() {
        return this.myCurrentParameterIndex;
    }

    public void setParameterOwner(PsiElement element) {
        this.myParameterOwner = element;
    }

    public PsiElement getParameterOwner() {
        return this.myParameterOwner;
    }

    public void setHighlightedParameter(Object element) {
        this.myHighlighted = element;
    }

    private class OneLineComponent
    extends JPanel {
        StrikeoutLabel myLabel1;
        StrikeoutLabel myLabel2;
        StrikeoutLabel myLabel3;

        private OneLineComponent() {
            super(new GridBagLayout());
            this.myLabel1 = new StrikeoutLabel("", 2);
            this.myLabel2 = new StrikeoutLabel("", 2);
            this.myLabel3 = new StrikeoutLabel("", 2);
            this.myLabel1.setOpaque(true);
            this.myLabel1.setFont(ParameterInfoComponent.this.NORMAL_FONT);
            this.myLabel2.setOpaque(true);
            this.myLabel2.setFont(ParameterInfoComponent.this.BOLD_FONT);
            this.myLabel3.setOpaque(true);
            this.myLabel3.setFont(ParameterInfoComponent.this.NORMAL_FONT);
            this.add((Component)this.myLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.myLabel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.myLabel3, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void setup(String text, int highlightStartOffset, int highlightEndOffset, boolean isDisabled, boolean strikeout, Color background) {
            this.myLabel1.setBackground(background);
            this.myLabel2.setBackground(background);
            this.myLabel3.setBackground(background);
            this.setBackground(background);
            this.myLabel1.setStrikeout(strikeout);
            this.myLabel2.setStrikeout(strikeout);
            this.myLabel3.setStrikeout(strikeout);
            if (isDisabled) {
                this.myLabel1.setText(text);
                this.myLabel2.setText("");
                this.myLabel3.setText("");
                this.setDisabled();
            } else {
                this.myLabel1.setForeground(FOREGROUND_COLOR);
                this.myLabel2.setForeground(FOREGROUND_COLOR);
                this.myLabel3.setForeground(FOREGROUND_COLOR);
                if (highlightStartOffset < 0) {
                    this.myLabel1.setText(text);
                    this.myLabel2.setText("");
                    this.myLabel3.setText("");
                } else {
                    this.myLabel1.setText(text.substring(0, highlightStartOffset));
                    this.myLabel2.setText(text.substring(highlightStartOffset, highlightEndOffset));
                    this.myLabel3.setText(text.substring(highlightEndOffset));
                }
            }
        }

        private void setDisabled() {
            this.myLabel1.setForeground(DISABLED_FOREGROUND_COLOR);
            this.myLabel2.setForeground(DISABLED_FOREGROUND_COLOR);
            this.myLabel3.setForeground(DISABLED_FOREGROUND_COLOR);
        }

        private void setDisabledBeforeHighlight() {
            this.myLabel1.setForeground(DISABLED_FOREGROUND_COLOR);
        }

        @Override
        public Dimension getPreferredSize() {
            this.myLabel1.setFont(ParameterInfoComponent.this.BOLD_FONT);
            this.myLabel3.setFont(ParameterInfoComponent.this.BOLD_FONT);
            Dimension boldPreferredSize = super.getPreferredSize();
            this.myLabel1.setFont(ParameterInfoComponent.this.NORMAL_FONT);
            this.myLabel3.setFont(ParameterInfoComponent.this.NORMAL_FONT);
            Dimension normalPreferredSize = super.getPreferredSize();
            return new Dimension(Math.max(boldPreferredSize.width, normalPreferredSize.width), Math.max(boldPreferredSize.height, normalPreferredSize.height));
        }
    }

    private class OneElementComponent
    extends JPanel {
        private OneLineComponent[] myOneLineComponents;

        public OneElementComponent() {
            super(new GridBagLayout());
            this.myOneLineComponents = new OneLineComponent[0];
        }

        public void setup(String text, int highlightStartOffset, int highlightEndOffset, boolean isDisabled, boolean strikeout, boolean isDisabledBeforeHighlight, Color background) {
            this.removeAll();
            String[] lines = SplittingUtil.splitText(text, this.getFontMetrics(ParameterInfoComponent.this.BOLD_FONT), ParameterInfoComponent.this.myWidthLimit, ',');
            this.myOneLineComponents = new OneLineComponent[lines.length];
            int lineOffset = 0;
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                this.myOneLineComponents[i] = new OneLineComponent();
                int startOffset = -1;
                int endOffset = -1;
                if (highlightStartOffset >= 0 && highlightEndOffset > lineOffset && highlightStartOffset < lineOffset + line.length()) {
                    startOffset = Math.max(highlightStartOffset - lineOffset, 0);
                    endOffset = Math.min(highlightEndOffset - lineOffset, line.length());
                }
                this.myOneLineComponents[i].setup(line, startOffset, endOffset, isDisabled, strikeout, background);
                if (isDisabledBeforeHighlight && (highlightStartOffset < 0 || highlightEndOffset > lineOffset)) {
                    this.myOneLineComponents[i].setDisabledBeforeHighlight();
                }
                this.add((Component)this.myOneLineComponents[i], new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
                lineOffset += line.length();
            }
        }

        public void setup(String[] texts, EnumSet<ParameterInfoUIContextEx.Flag>[] flags, Color background) {
            this.removeAll();
            this.myOneLineComponents = new OneLineComponent[texts.length];
            for (int i = 0; i < texts.length; ++i) {
                String line = texts[i];
                EnumSet<ParameterInfoUIContextEx.Flag> flag = flags[i];
                this.myOneLineComponents[i] = new OneLineComponent();
                boolean highlighed = flag.contains(ParameterInfoUIContextEx.Flag.HIGHLIGHT);
                this.myOneLineComponents[i].setup(line, 0, highlighed ? line.length() : 0, flag.contains(ParameterInfoUIContextEx.Flag.DISABLE), flags[i].contains(ParameterInfoUIContextEx.Flag.STRIKEOUT), background);
                this.add((Component)this.myOneLineComponents[i], new GridBagConstraints(i, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            }
        }

        public void setDisabled() {
            for (OneLineComponent oneLineComponent : this.myOneLineComponents) {
                oneLineComponent.setDisabled();
            }
        }
    }

    class MyParameterContext
    implements ParameterInfoUIContextEx {
        private int i;

        MyParameterContext() {
        }

        public void setupUIComponentPresentation(String text, int highlightStartOffset, int highlightEndOffset, boolean isDisabled, boolean strikeout, boolean isDisabledBeforeHighlight, Color background) {
            ParameterInfoComponent.this.myPanels[this.i].setup(text, highlightStartOffset, highlightEndOffset, isDisabled, strikeout, isDisabledBeforeHighlight, background);
            ParameterInfoComponent.this.myPanels[this.i].setBorder(this.isLastParameterOwner() ? BACKGROUND_BORDER : BOTTOM_BORDER);
        }

        public void setupUIComponentPresentation(String[] texts, EnumSet<ParameterInfoUIContextEx.Flag>[] flags, Color background) {
            ParameterInfoComponent.this.myPanels[this.i].setup(texts, flags, background);
            ParameterInfoComponent.this.myPanels[this.i].setBorder(this.isLastParameterOwner() ? BACKGROUND_BORDER : BOTTOM_BORDER);
        }

        public boolean isUIComponentEnabled() {
            return ParameterInfoComponent.this.isEnabled(this.i);
        }

        public void setUIComponentEnabled(boolean enabled) {
            ParameterInfoComponent.this.setEnabled(this.i, enabled);
        }

        public boolean isLastParameterOwner() {
            return this.i == ParameterInfoComponent.this.myPanels.length - 1;
        }

        public int getCurrentParameterIndex() {
            return ParameterInfoComponent.this.myCurrentParameterIndex;
        }

        public PsiElement getParameterOwner() {
            return ParameterInfoComponent.this.myParameterOwner;
        }

        public Color getDefaultParameterColor() {
            return ParameterInfoComponent.this.myObjects[this.i].equals(ParameterInfoComponent.this.myHighlighted) ? HIGHLIGHTED_BORDER_COLOR : BACKGROUND_COLOR;
        }
    }
}

