/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFileFix
implements IntentionAction,
LocalQuickFix {
    private final boolean myIsDirectory;
    private final String myNewFileName;
    private final PsiDirectory myDirectory;
    @Nullable
    private final String myText;
    @NotNull
    private String myKey;
    private boolean myIsAvailable;
    private long myIsAvailableTimeStamp;
    private static final int REFRESH_INTERVAL = 1000;

    public CreateFileFix(boolean isDirectory, String newFileName, PsiDirectory directory, @Nullable String text, @NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/codeInsight/daemon/quickFix/CreateFileFix.<init> must not be null");
        }
        this.myIsDirectory = isDirectory;
        this.myNewFileName = newFileName;
        this.myDirectory = directory;
        this.myText = text;
        this.myKey = key;
        this.myIsAvailable = isDirectory || !FileTypeManager.getInstance().getFileTypeByFileName(newFileName).isBinary();
        this.myIsAvailableTimeStamp = System.currentTimeMillis();
    }

    public CreateFileFix(boolean isDirectory, String newFileName, PsiDirectory directory) {
        this(isDirectory, newFileName, directory, null, isDirectory ? "create.directory.text" : "create.file.text");
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)this.myKey, (Object[])new Object[]{this.myNewFileName});
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/quickFix/CreateFileFix.getText must not return null");
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/quickFix/CreateFileFix.getName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = CodeInsightBundle.message((String)"create.file.family", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/daemon/quickFix/CreateFileFix.getFamilyName must not return null");
        }
        return string;
    }

    public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/quickFix/CreateFileFix.applyFix must not be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/quickFix/CreateFileFix.applyFix must not be null");
        }
        if (this.isAvailable(project, null, null)) {
            new WriteCommandAction(project, new PsiFile[0]){

                protected void run(Result result) throws Throwable {
                    CreateFileFix.this.invoke(project, null, null);
                }
            }.execute();
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/quickFix/CreateFileFix.isAvailable must not be null");
        }
        long current = System.currentTimeMillis();
        if (current - this.myIsAvailableTimeStamp > 1000L) {
            this.myIsAvailable = this.myDirectory.getVirtualFile().findChild(this.myNewFileName) == null;
            this.myIsAvailableTimeStamp = current;
        }
        return this.myIsAvailable;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        block7: {
            if (project == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/quickFix/CreateFileFix.invoke must not be null");
            }
            this.myIsAvailableTimeStamp = 0L;
            try {
                if (this.myIsDirectory) {
                    this.myDirectory.createSubdirectory(this.myNewFileName);
                    break block7;
                }
                PsiFile newFile = this.myDirectory.createFile(this.myNewFileName);
                String text = null;
                if (this.myText != null) {
                    PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("_" + this.myNewFileName, this.myText);
                    PsiElement psiElement = CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiFile);
                    text = psiElement.getText();
                }
                FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.myDirectory.getProject());
                FileEditor[] fileEditors = editorManager.openFile(newFile.getVirtualFile(), true);
                if (text == null) break block7;
                for (FileEditor fileEditor : fileEditors) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    Document document = ((TextEditor)fileEditor).getEditor().getDocument();
                    document.setText((CharSequence)text);
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        FileDocumentManager.getInstance().saveDocument(document);
                    }
                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                    break;
                }
            }
            catch (IncorrectOperationException e) {
                this.myIsAvailable = false;
            }
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

