/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightInfoHolder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder");
    private final PsiFile myContextFile;
    private final HighlightInfoFilter[] myFilters;
    private int myErrorCount;
    private final List<HighlightInfo> myInfos;

    public HighlightInfoHolder(@NotNull PsiFile contextFile, HighlightInfoFilter ... filters) {
        if (contextFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder.<init> must not be null");
        }
        if (filters == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/daemon/impl/analysis/HighlightInfoHolder.<init> must not be null");
        }
        this.myInfos = new ArrayList<HighlightInfo>(5);
        this.myContextFile = contextFile;
        this.myFilters = filters;
    }

    public boolean add(@Nullable HighlightInfo info) {
        if (info == null || !this.accepted(info)) {
            return false;
        }
        HighlightSeverity severity = info.getSeverity();
        if (severity == HighlightSeverity.ERROR) {
            ++this.myErrorCount;
        }
        return this.myInfos.add(info);
    }

    private boolean accepted(HighlightInfo info) {
        for (HighlightInfoFilter filter : this.myFilters) {
            if (filter.accept(info, this.myContextFile)) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        this.myErrorCount = 0;
        this.myInfos.clear();
    }

    public boolean hasErrorResults() {
        return this.myErrorCount != 0;
    }

    public boolean addAll(Collection<? extends HighlightInfo> highlightInfos) {
        if (highlightInfos == null) {
            return false;
        }
        LOG.assertTrue(highlightInfos != this);
        boolean added = false;
        for (HighlightInfo highlightInfo : highlightInfos) {
            added |= this.add(highlightInfo);
        }
        return added;
    }

    public int size() {
        return this.myInfos.size();
    }

    public HighlightInfo get(int i) {
        return this.myInfos.get(i);
    }
}

