/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import java.io.File;
import org.jetbrains.idea.svn.SvnVcs;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class MergeRootInfo {
    private String myUrl1;
    private SVNRevision myRevision1 = SVNRevision.HEAD;
    private String myUrl2;
    private SVNRevision myRevision2 = SVNRevision.HEAD;

    public MergeRootInfo(File file, SvnVcs vcs) {
        try {
            SVNWCClient wcClient = vcs.createWCClient();
            SVNURL url = wcClient.doInfo(file, SVNRevision.WORKING).getURL();
            this.myUrl1 = url.toString();
            this.myUrl2 = url.toString();
        }
        catch (SVNException e) {
            this.myUrl1 = "";
            this.myUrl2 = "";
        }
    }

    public SVNURL getUrl1() {
        try {
            return SVNURL.parseURIDecoded((String)this.myUrl1);
        }
        catch (SVNException e) {
            return null;
        }
    }

    public SVNURL getUrl2() {
        try {
            return SVNURL.parseURIDecoded((String)this.myUrl2);
        }
        catch (SVNException e) {
            return null;
        }
    }

    public SVNRevision getRevision2() {
        return this.myRevision2;
    }

    public SVNRevision getRevision1() {
        return this.myRevision1;
    }

    public long getResultRevision() {
        return this.myRevision2.getNumber();
    }

    public void setUrl1(String text) {
        this.myUrl1 = text;
    }

    public void setUrl2(String text) {
        this.myUrl2 = text;
    }

    public void setRevision1(SVNRevision rev) {
        this.myRevision1 = rev;
    }

    public void setRevision2(SVNRevision rev) {
        this.myRevision2 = rev;
    }

    public String getUrlString1() {
        return this.myUrl1;
    }

    public String getUrlString2() {
        return this.myUrl2;
    }
}

