/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.parser;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.parser.GroovyParser;
import org.jetbrains.plugins.groovy.lang.parser.GroovyPsiCreator;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrStubFileElementType;

public class GroovyParserDefinition
implements ParserDefinition {
    public static final IStubFileElementType GROOVY_FILE = new GrStubFileElementType(GroovyFileType.GROOVY_FILE_TYPE.getLanguage());

    @NotNull
    public Lexer createLexer(Project project) {
        GroovyLexer groovyLexer = new GroovyLexer();
        if (groovyLexer == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/parser/GroovyParserDefinition.createLexer must not return null");
        }
        return groovyLexer;
    }

    public PsiParser createParser(Project project) {
        return new GroovyParser();
    }

    public IFileElementType getFileNodeType() {
        return GROOVY_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = TokenSets.WHITE_SPACE_TOKEN_SET;
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/parser/GroovyParserDefinition.getWhitespaceTokens must not return null");
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = TokenSets.COMMENTS_TOKEN_SET;
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/parser/GroovyParserDefinition.getCommentTokens must not return null");
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSets.STRING_LITERALS;
        if (tokenSet == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/parser/GroovyParserDefinition.getStringLiteralElements must not return null");
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        PsiElement psiElement = GroovyPsiCreator.createElement(node);
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/parser/GroovyParserDefinition.createElement must not return null");
        }
        return psiElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new GroovyFileImpl(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        if (right.getElementType() == GroovyElementTypes.kIMPORT && left.getElementType() != GroovyElementTypes.mWS) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        if (left.getElementType() == GroovyElementTypes.MODIFIERS && right.getElementType() == GroovyElementTypes.MODIFIERS) {
            return ParserDefinition.SpaceRequirements.MUST;
        }
        if (left.getElementType() == GroovyElementTypes.mSEMI || left.getElementType() == GroovyElementTypes.mSL_COMMENT) {
            return ParserDefinition.SpaceRequirements.MUST_LINE_BREAK;
        }
        GroovyLexer lexer = new GroovyLexer();
        ParserDefinition.SpaceRequirements spaceRequirements = LanguageUtil.canStickTokensTogetherByLexer((ASTNode)left, (ASTNode)right, (Lexer)lexer);
        return spaceRequirements;
    }
}

