/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.untypedUnresolvedAccess;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.annotator.GroovyAnnotator;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;

public class GroovyUnresolvedAccessInspection
extends BaseInspection {
    @Override
    protected BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Probable bugs" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GroovyUnresolvedAccessInspection.getGroupDisplayName must not return null");
        }
        return "Probable bugs";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Access to unresolved expression" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/untypedUnresolvedAccess/GroovyUnresolvedAccessInspection.getDisplayName must not return null");
        }
        return "Access to unresolved expression";
    }

    @Override
    protected String buildErrorString(Object ... args) {
        return "Can not resolve symbol '#ref'";
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitReferenceExpression(GrReferenceExpression refExpr) {
            GrExpression qualifier;
            super.visitReferenceExpression(refExpr);
            GroovyResolveResult resolveResult = refExpr.advancedResolve();
            PsiElement resolved = resolveResult.getElement();
            if (resolved != null ? GroovyAnnotator.isDeclarationAssignment(refExpr) || resolved instanceof PsiPackage : (qualifier = refExpr.getQualifierExpression()) == null && GroovyAnnotator.isDeclarationAssignment(refExpr)) {
                return;
            }
            if (resolved == null) {
                PsiElement refNameElement = refExpr.getReferenceNameElement();
                this.registerError(refNameElement == null ? refExpr : refNameElement);
            }
        }
    }
}

