#!/bin/sh
echo 'name: type-level
version: 0.2.4
id: type-level-0.2.4-0be9562a2dda7db63dcc31d35882213b

license: BSD3
copyright: Copyright (c) 2008 Alfonso Acosta, Oleg Kiselyov, Wolfgang Jeltsch
           and KTH'\''s SAM group
maintainer: alfonso.acosta@gmail.com
stability: alpha
homepage: http://code.haskell.org/type-level
package-url: http://code.haskell.org/type-level
description: This library permits performing computations on the type-level. Type-level
             functions are implemented using functional dependencies of multi
             parameter type classes.
             To date, Booleans and Numerals (Naturals and Positives) are
             supported. With regard to Numerals, there is support for common
             arithmetic operations (addition, substraction, multiplication,
             division, exponientation, logarithm, maximum, comparison, GCD)
             over natural numbers (using a decimal representation to make
             compile-time errors friendlier).
             Although making use of type-level computations might seem devious and
             obfuscated at first sight, it is indeed useful in practice to implement
             lightweight dependent types such us number-parameterized types (e.g. an array
             type parameterized by the array'\''s size or a modular group type Zn
             parameterized by the modulus).
             Here is a tutorial on type-level numerals and how to use them to
             implement numerically-parameterized vectors: <http://www.ict.kth.se/forsyde/files/tutorial/tutorial.html#FSVec>
category: Data
author: Alfonso Acosta
pkgpath: devel/hs-type-level
exposed: True
exposed-modules: Data.TypeLevel Data.TypeLevel.Bool
                 Data.TypeLevel.Num Data.TypeLevel.Num.Reps
                 Data.TypeLevel.Num.Aliases Data.TypeLevel.Num.Sets
                 Data.TypeLevel.Num.Ops Data.TypeLevel.Num.Aliases.TH
hidden-modules:
import-dirs: /usr/local/lib/ghc/type-level-0.2.4
library-dirs: /usr/local/lib/ghc/type-level-0.2.4
hs-libraries: HStype-level-0.2.4
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.3.1.0-e1ba2d2213b66179f3e0c901a27d3a96
         syb-0.3-8a51ec8e05a2a260bc0e1bb18be953b0
         template-haskell-2.5.0.0-2ccdf1e9ca6c0f55d47fb724a693009c
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-type-level-0.2.4/html/type-level.haddock
haddock-html: /usr/local/share/doc/hs-type-level-0.2.4/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-conf' "$@"
