/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CertificateType;
import gnu.javax.net.ssl.provider.Handshake;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import javax.net.ssl.SSLProtocolException;

final class Certificate
implements Handshake.Body {
    private final X509Certificate[] certs;

    Certificate(X509Certificate[] x509CertificateArray) {
        if (x509CertificateArray == null) {
            throw new NullPointerException();
        }
        this.certs = x509CertificateArray;
    }

    static Certificate read(InputStream inputStream, CertificateType certificateType) throws IOException {
        if (certificateType == CertificateType.X509) {
            int n;
            int n2;
            int n3 = (inputStream.read() & 0xFF) << 16 | (inputStream.read() & 0xFF) << 8 | inputStream.read() & 0xFF;
            byte[] byArray = new byte[n3];
            for (n = 0; n < n3; n += n2) {
                n2 = inputStream.read(byArray, n, n3 - n);
                if (n2 != -1) continue;
                throw new EOFException("unexpected end of stream");
            }
            try {
                int n4;
                LinkedList linkedList = new LinkedList();
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                for (n = 0; n < n3; n += n4 + 3) {
                    n4 = (byteArrayInputStream.read() & 0xFF) << 16 | (byteArrayInputStream.read() & 0xFF) << 8 | byteArrayInputStream.read() & 0xFF;
                    linkedList.add(certificateFactory.generateCertificate(byteArrayInputStream));
                }
                return new Certificate((X509Certificate[])linkedList.toArray(new X509Certificate[linkedList.size()]));
            }
            catch (CertificateException certificateException) {
                SSLProtocolException sSLProtocolException = new SSLProtocolException(certificateException.getMessage());
                sSLProtocolException.initCause(certificateException);
                throw sSLProtocolException;
            }
        }
        if (certificateType == CertificateType.OPEN_PGP) {
            throw new UnsupportedOperationException("not yet implemented");
        }
        throw new Error("unsupported certificate type " + certificateType);
    }

    public void write(OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            for (int i = 0; i < this.certs.length; ++i) {
                byte[] byArray = this.certs[i].getEncoded();
                byteArrayOutputStream.write(byArray.length >>> 16 & 0xFF);
                byteArrayOutputStream.write(byArray.length >>> 8 & 0xFF);
                byteArrayOutputStream.write(byArray.length & 0xFF);
                byteArrayOutputStream.write(byArray);
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new Error("cannot encode certificates");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        outputStream.write(byteArrayOutputStream.size() >>> 16 & 0xFF);
        outputStream.write(byteArrayOutputStream.size() >>> 8 & 0xFF);
        outputStream.write(byteArrayOutputStream.size() & 0xFF);
        byteArrayOutputStream.writeTo(outputStream);
    }

    X509Certificate[] getCertificates() {
        return this.certs;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("struct {");
        printWriter.println("  certificateList =");
        for (int i = 0; i < this.certs.length; ++i) {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(this.certs[i].toString()));
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    printWriter.print("    ");
                    printWriter.println(string);
                }
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        printWriter.println("} Certificate;");
        return stringWriter.toString();
    }
}

