/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig.dss;

import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.sig.ISignatureCodec;
import gnu.java.security.util.DerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.util.ArrayList;

public class DSSSignatureX509Codec
implements ISignatureCodec {
    public int getFormatID() {
        return 2;
    }

    public byte[] encodeSignature(Object object) {
        byte[] byArray;
        BigInteger[] bigIntegerArray = (BigInteger[])object;
        DERValue dERValue = new DERValue(2, bigIntegerArray[0]);
        DERValue dERValue2 = new DERValue(2, bigIntegerArray[1]);
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(dERValue);
        arrayList.add(dERValue2);
        DERValue dERValue3 = new DERValue(48, arrayList);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DERWriter.write(byteArrayOutputStream, dERValue3);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            InvalidParameterException invalidParameterException = new InvalidParameterException();
            invalidParameterException.initCause(iOException);
            throw invalidParameterException;
        }
        return byArray;
    }

    public Object decodeSignature(byte[] byArray) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        if (byArray == null) {
            throw new InvalidParameterException("Input bytes MUST NOT be null");
        }
        DERReader dERReader = new DERReader(byArray);
        try {
            DERValue dERValue = dERReader.read();
            DerUtil.checkIsConstructed(dERValue, "Wrong Dss-Sig-Value field");
            DERValue dERValue2 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue2, "Wrong R field");
            bigInteger2 = (BigInteger)dERValue2.getValue();
            dERValue2 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue2, "Wrong S field");
            bigInteger = (BigInteger)dERValue2.getValue();
        }
        catch (IOException iOException) {
            InvalidParameterException invalidParameterException = new InvalidParameterException();
            invalidParameterException.initCause(iOException);
            throw invalidParameterException;
        }
        return new BigInteger[]{bigInteger2, bigInteger};
    }
}

