#ifndef FELDSPAR_ARRAY_H
#define FELDSPAR_ARRAY_H

struct array
{
    void* buffer;       /* pointer to the buffer of elements */
    unsigned int length;    /* number of elements in the array */
    int elemSize;       /* size of elements in bytes; (-1) for nested arrays */
};

/* Deep array copy */
void copyArray(struct array *to, struct array from);

/* Deep array copy to a given position */
void copyArrayPos(struct array *to, unsigned pos, struct array from);

/* Deep array copy with a given length */
void copyArrayLen(struct array *to, struct array from, unsigned len);

/* Array length */
unsigned length(struct array arr);

/* (Re)set array length */
void setLength(struct array *arr, unsigned len);

/* Reset array length by increasing it */
void increaseLength(struct array *arr, unsigned len);

/* Indexing into an array: */
/* Result: element of type 'type' */
#define at(type,arr,idx) (((type*)((arr).buffer))[idx])

#endif
