/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.search.JavaSearchPageScoreComputer;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.search.ui.ISearchPageScoreComputer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public class EditorInputAdapterFactory
implements IAdapterFactory {
    private static Class[] PROPERTIES = new Class[]{IJavaElement.class};
    private Object fSearchPageScoreComputer;

    public Class[] getAdapterList() {
        this.updateLazyLoadedAdapters();
        return PROPERTIES;
    }

    public Object getAdapter(Object element, Class key) {
        this.updateLazyLoadedAdapters();
        if (this.fSearchPageScoreComputer != null && ISearchPageScoreComputer.class.equals((Object)key)) {
            return this.fSearchPageScoreComputer;
        }
        if (IJavaElement.class.equals((Object)key) && element instanceof IEditorInput) {
            ICompilationUnit je = JavaUI.getWorkingCopyManager().getWorkingCopy((IEditorInput)element);
            if (je != null) {
                return je;
            }
            if (element instanceof IStorageEditorInput) {
                try {
                    return ((IStorageEditorInput)element).getStorage().getAdapter(key);
                }
                catch (CoreException coreException) {}
            }
        }
        return null;
    }

    private void updateLazyLoadedAdapters() {
        if (this.fSearchPageScoreComputer == null && SearchUtil.isSearchPlugInActivated()) {
            this.createSearchPageScoreComputer();
        }
    }

    private void createSearchPageScoreComputer() {
        this.fSearchPageScoreComputer = new JavaSearchPageScoreComputer();
        PROPERTIES = new Class[]{ISearchPageScoreComputer.class, IJavaElement.class};
    }
}

