/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.Iterator;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.debug.core.IJavaArrayType;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectActionDelegate;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.util.OpenTypeHierarchyUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class OpenTypeAction
extends ObjectActionDelegate {
    public void run(IAction action) {
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null) {
            return;
        }
        Iterator itr = selection.iterator();
        try {
            while (itr.hasNext()) {
                Object element = itr.next();
                Object sourceElement = this.resolveSourceElement(element);
                if (sourceElement != null) {
                    this.openInEditor(sourceElement);
                    continue;
                }
                Status status = new Status(1, IJavaDebugUIConstants.PLUGIN_ID, 150, ActionMessages.OpenTypeAction_0, null);
                throw new CoreException((IStatus)status);
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.errorDialog(ActionMessages.OpenTypeAction_1, e.getStatus());
        }
    }

    protected abstract IDebugElement getDebugElement(IAdaptable var1);

    protected abstract IJavaType getTypeToOpen(IDebugElement var1) throws CoreException;

    protected Object resolveSourceElement(Object e) throws CoreException {
        IType source = null;
        IAdaptable element = (IAdaptable)e;
        IDebugElement dbgElement = this.getDebugElement(element);
        if (dbgElement != null) {
            IJavaType type = this.getTypeToOpen(dbgElement);
            while (type instanceof IJavaArrayType) {
                type = ((IJavaArrayType)type).getComponentType();
            }
            if (type != null && (source = JavaDebugUtils.resolveType((IJavaType)type)) == null) {
                source = OpenTypeAction.findTypeInWorkspace(type.getName());
            }
        }
        return source;
    }

    protected void openInEditor(Object sourceElement) throws CoreException {
        if (this.isHierarchy()) {
            if (sourceElement instanceof IJavaElement) {
                OpenTypeHierarchyUtil.open((IJavaElement)((IJavaElement)sourceElement), (IWorkbenchWindow)this.getWorkbenchWindow());
            } else {
                this.typeHierarchyError();
            }
        } else {
            IEditorPart part = EditorUtility.openInEditor((Object)sourceElement);
            if (part != null && sourceElement instanceof IJavaElement) {
                EditorUtility.revealInEditor((IEditorPart)part, (IJavaElement)((IJavaElement)sourceElement));
            }
        }
    }

    protected boolean isHierarchy() {
        return false;
    }

    public static IType findTypeInWorkspace(String typeName) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)root).getJavaProjects();
        int i = 0;
        while (i < projects.length) {
            IType type = OpenTypeAction.findType(projects[i], typeName);
            if (type != null) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private static IType findType(IJavaProject jproject, String fullyQualifiedName) throws CoreException {
        IJavaElement jelement = JavaDebugUtils.findElement((String)fullyQualifiedName, (IJavaProject)jproject);
        if (jelement instanceof ICompilationUnit) {
            String simpleName = Signature.getSimpleName((String)fullyQualifiedName);
            return ((ICompilationUnit)jelement).getType(simpleName);
        }
        if (jelement instanceof IClassFile) {
            return ((IClassFile)jelement).getType();
        }
        return null;
    }

    protected void typeHierarchyError() {
        this.showErrorMessage(ActionMessages.ObjectActionDelegate_Unable_to_display_type_hierarchy__The_selected_source_element_is_not_contained_in_the_workspace__1);
    }
}

