/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.ide;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.internal.proxy.common.MethodHelper;
import org.eclipse.jem.internal.proxy.core.Expression;
import org.eclipse.jem.internal.proxy.core.ExpressionProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeExpressionProxy;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IProxy;
import org.eclipse.jem.internal.proxy.core.IProxyBeanType;
import org.eclipse.jem.internal.proxy.core.IProxyField;
import org.eclipse.jem.internal.proxy.core.IProxyMethod;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBeanProxy;
import org.eclipse.jem.internal.proxy.ide.IDEBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEFieldProxy;
import org.eclipse.jem.internal.proxy.ide.IDEInitErrorBeanTypeProxy;
import org.eclipse.jem.internal.proxy.ide.IDEMethodProxy;
import org.eclipse.jem.internal.proxy.ide.IDEMethodProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IDEProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.ide.IDEStandardBeanTypeProxyFactory;
import org.eclipse.jem.internal.proxy.ide.IDEThrowableProxy;
import org.eclipse.jem.internal.proxy.initParser.tree.ExpressionProcesser;
import org.eclipse.jem.internal.proxy.initParser.tree.InfixOperator;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalConditionalOperandType;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalExpressionProxy;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalIfElseOperandType;
import org.eclipse.jem.internal.proxy.initParser.tree.InternalInfixOperandType;
import org.eclipse.jem.internal.proxy.initParser.tree.NoExpressionValueException;
import org.eclipse.jem.internal.proxy.initParser.tree.PrefixOperator;

public class IDEExpression
extends Expression {
    private final IDEStandardBeanTypeProxyFactory beantypefactory;
    protected final ExpressionProcesser eproc;
    protected Map methodExpressionProxies;
    protected Map fieldExpressionProxies;
    protected Map beanTypeCache;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private void processExpressionError() throws ThrowableProxy, NoExpressionValueException {
        if (!this.eproc.noErrors()) {
            if (this.eproc.isNoExpressionValue()) {
                throw (NoExpressionValueException)this.eproc.getErrorThrowable();
            }
            Throwable t = this.eproc.getErrorThrowable();
            if (t instanceof ThrowableProxy) {
                throw (ThrowableProxy)t;
            }
            throw new IDEThrowableProxy(this.eproc.getErrorThrowable(), this.beantypefactory.getBeanTypeProxy(t.getClass()));
        }
    }

    public IDEExpression(ProxyFactoryRegistry registry) {
        super(registry);
        boolean useTracing = !this.isTraceSet() ? "true".equalsIgnoreCase(Platform.getDebugOption((String)(String.valueOf(ProxyPlugin.getPlugin().getBundle().getSymbolicName()) + "/debug/traceexpressions"))) : this.isTrace();
        long threshold = Long.getLong(Platform.getDebugOption((String)(String.valueOf(ProxyPlugin.getPlugin().getBundle().getSymbolicName()) + "/debug/traceexpressionstimethreshold")), -1L);
        this.eproc = new ExpressionProcesser(useTracing, threshold);
        this.beantypefactory = (IDEStandardBeanTypeProxyFactory)registry.getBeanTypeProxyFactory();
    }

    protected final IDEProxyFactoryRegistry getIDERegistry() {
        return (IDEProxyFactoryRegistry)this.registry;
    }

    protected final IDEStandardBeanTypeProxyFactory getIDEBeanTypeFactory() {
        return this.beantypefactory;
    }

    protected void pushToProxy(IProxy proxy) {
        if (proxy == null) {
            this.eproc.pushExpression(null, MethodHelper.NULL_TYPE);
        } else if (proxy.isBeanProxy()) {
            this.eproc.pushExpression(((IDEBeanProxy)proxy).getBean(), ((IDEBeanTypeProxy)((IBeanProxy)proxy).getTypeProxy()).getTypeClass());
        } else {
            this.eproc.pushExpressionProxy(((ExpressionProxy)proxy).getProxyID());
        }
    }

    protected void closeProxy() {
        this.fieldExpressionProxies = null;
        this.methodExpressionProxies = null;
        this.eproc.close();
    }

    protected IBeanProxy pullProxyValue(int proxycount, List expressionProxies) throws ThrowableProxy, NoExpressionValueException {
        this.processExtensionProxies(proxycount, expressionProxies);
        this.processExpressionError();
        Object[] result = new Object[2];
        this.eproc.pullValue(result);
        IBeanProxy resultProxy = this.getIDERegistry().getBeanProxy((Class)result[1], result[0]);
        return resultProxy;
    }

    private void processExtensionProxies(int proxycount, List expressionProxies) {
        if (proxycount > 0) {
            int len = expressionProxies.size();
            Object[] proxyResolution = new Object[2];
            int i = 0;
            while (i < len) {
                ExpressionProxy ep = (ExpressionProxy)expressionProxies.get(i);
                if (ep != null) {
                    try {
                        this.eproc.pullExpressionProxyValue(ep.getProxyID(), proxyResolution);
                        if (proxyResolution[1] != Void.TYPE) {
                            this.fireProxyResolved(ep, this.getIDERegistry().getBeanProxy((Class)proxyResolution[1], proxyResolution[0]));
                        } else {
                            this.fireProxyVoid(ep);
                        }
                    }
                    catch (NoExpressionValueException noExpressionValueException) {
                        this.fireProxyNotResolved(ep);
                    }
                }
                ++i;
            }
        }
    }

    protected void pushCastToProxy(IProxyBeanType type) {
        try {
            this.eproc.pushCast(this.getIDEBeanTypeProxy(type).getTypeClass());
        }
        catch (ThrowableProxy e) {
            this.eproc.processException(e);
        }
    }

    protected void pushInstanceofToProxy(IProxyBeanType type) {
        try {
            this.eproc.pushInstanceof(this.getIDEBeanTypeProxy(type).getTypeClass());
        }
        catch (ThrowableProxy e) {
            this.eproc.processException(e);
        }
    }

    protected IDEBeanTypeProxy getIDEBeanTypeProxy(IProxyBeanType type) throws ThrowableProxy {
        IDEBeanTypeProxy typeProxy = type.isExpressionProxy() ? ((IDEBeanTypeExpressionProxy)type).getBeanTypeProxy() : (IDEBeanTypeProxy)type;
        if (!typeProxy.isValid()) {
            Exception exception = new Exception(typeProxy.getInitializationError());
            IDEStandardBeanTypeProxyFactory iDEStandardBeanTypeProxyFactory = this.getIDEBeanTypeFactory();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Exception");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new IDEThrowableProxy(exception, iDEStandardBeanTypeProxyFactory.getBeanTypeProxy(clazz));
        }
        return typeProxy;
    }

    protected IDEBeanTypeProxy getIDEBeanTypeProxy(String type) throws ThrowableProxy {
        return (IDEBeanTypeProxy)this.registry.getBeanTypeProxyFactory().getBeanTypeProxy(type);
    }

    protected void pushPrefixToProxy(PrefixOperator operator) {
        this.eproc.pushPrefix(operator);
    }

    protected void pushInfixToProxy(InfixOperator operator, InternalInfixOperandType operandType) {
        this.eproc.pushInfix(operator, operandType);
    }

    protected void pushArrayAccessToProxy(int indexCount) {
        this.eproc.pushArrayAccess(indexCount);
    }

    protected void pushArrayCreationToProxy(IProxyBeanType type, int dimensionCount) {
        try {
            this.eproc.pushArrayCreation(this.getIDEBeanTypeProxy(type).getTypeClass(), dimensionCount);
        }
        catch (ThrowableProxy e) {
            this.eproc.processException(e);
        }
    }

    protected void pushArrayInitializerToProxy(IProxyBeanType type, int stripCount, int expressionCount) {
        try {
            this.eproc.pushArrayInitializer(this.getIDEBeanTypeProxy(type).getTypeClass(), stripCount, expressionCount);
        }
        catch (ThrowableProxy e) {
            this.eproc.processException(e);
        }
    }

    protected void pushClassInstanceCreationToProxy(IProxyBeanType type, int argumentCount) {
        try {
            this.eproc.pushClassInstanceCreation(this.getIDEBeanTypeProxy(type).getTypeClass(), argumentCount);
        }
        catch (ThrowableProxy e) {
            this.eproc.processException(e);
        }
    }

    protected void pushTypeReceiverToProxy(IProxyBeanType type) {
        try {
            Class c = this.getIDEBeanTypeProxy(type).getTypeClass();
            this.eproc.pushExpression(c, c);
        }
        catch (ThrowableProxy e) {
            this.eproc.processException(e);
        }
        catch (RuntimeException e) {
            this.eproc.processException(e);
        }
    }

    protected void pushFieldAccessToProxy(Object field, boolean hasReceiver) {
        boolean isString = field instanceof String;
        try {
            this.eproc.pushFieldAccess(isString ? field : this.getIDEFieldProxy((IProxyField)field).getBean(), isString, hasReceiver);
        }
        catch (ThrowableProxy e) {
            this.eproc.processException(e);
        }
    }

    protected void pushMethodInvocationToProxy(Object method, boolean hasReceiver, int argCount) {
        boolean isString = method instanceof String;
        try {
            this.eproc.pushMethodInvocation(isString ? method : this.getIDEMethodProxy((IProxyMethod)method).getBean(), isString, hasReceiver, argCount);
        }
        catch (ThrowableProxy e) {
            this.eproc.processException(e);
        }
    }

    protected void pushConditionalToProxy(InternalConditionalOperandType expressionType) {
        this.eproc.pushConditional(expressionType);
    }

    protected void pushInvoke(int proxycount, List expressionProxies) throws ThrowableProxy, NoExpressionValueException {
        this.processExtensionProxies(proxycount, expressionProxies);
        this.processExpressionError();
    }

    protected ExpressionProxy createExpressionProxy(int proxyType, int proxyID) {
        switch (proxyType) {
            default: {
                return new IDEExpressionProxy(proxyID, 0, this);
            }
            case 1: {
                return new IDEBeanTypeExpressionProxy(proxyID, this);
            }
            case 2: {
                return new IDEMethodExpressionProxy(proxyID, this);
            }
            case 3: 
        }
        return new IDEFieldExpressionProxy(proxyID, this);
    }

    protected void pushAssignmentToProxy(ExpressionProxy proxy) {
        this.eproc.pushAssignment((InternalExpressionProxy)((Object)proxy));
    }

    protected void pushAssignmentToProxy() {
        this.eproc.pushAssignment();
    }

    protected void pushBlockBeginToProxy(int blockNumber) {
        this.eproc.pushBlockBegin(blockNumber);
    }

    protected void pushBlockEndToProxy(int blockNumber) {
        this.eproc.pushBlockEnd(blockNumber);
    }

    protected void pushBlockBreakToProxy(int blockNumber) {
        this.eproc.pushBlockBreak(blockNumber);
    }

    protected void pushTryBeginToProxy(int tryNumber) {
        this.eproc.pushTryBegin(tryNumber);
    }

    protected void pushTryCatchClauseToProxy(int tryNumber, IProxyBeanType exceptionType, ExpressionProxy ep) {
        try {
            this.eproc.pushTryCatchClause(tryNumber, this.getIDEBeanTypeProxy(exceptionType).getTypeClass(), (InternalExpressionProxy)((Object)ep));
        }
        catch (ThrowableProxy e) {
            this.eproc.processException(e);
        }
    }

    protected void pushTryFinallyClauseToProxy(int tryNumber) {
        this.eproc.pushTryFinallyClause(tryNumber);
    }

    protected void pushTryEndToProxy(int tryNumber) {
        this.eproc.pushTryEnd(tryNumber);
    }

    protected void pushThrowToProxy() {
        this.eproc.pushThrowException();
    }

    protected void pushRethrowToProxy(int tryNumber) {
        this.eproc.pushTryRethrow(tryNumber);
    }

    protected void pushBeanTypeToProxy(IBeanTypeExpressionProxy proxy) {
        block6: {
            try {
                IDEBeanTypeExpressionProxy ep = (IDEBeanTypeExpressionProxy)proxy;
                IDEBeanTypeProxy typeProxy = this.getIDEBeanTypeProxy(proxy.getTypeName());
                ep.setProxy(typeProxy);
                this.eproc.allocateExpressionProxy(ep);
                if (typeProxy.isValid()) break block6;
                Throwable cause = ((IDEInitErrorBeanTypeProxy)typeProxy).getCause();
                if (cause == null) {
                    Exception exception = new Exception(typeProxy.getInitializationError());
                    IDEStandardBeanTypeProxyFactory iDEStandardBeanTypeProxyFactory = this.getIDEBeanTypeFactory();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.lang.Exception");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    throw new IDEThrowableProxy(exception, iDEStandardBeanTypeProxyFactory.getBeanTypeProxy(clazz));
                }
                throw new IDEThrowableProxy(cause, this.getIDEBeanTypeFactory().getBeanTypeProxy(cause.getClass()));
            }
            catch (ThrowableProxy e) {
                this.eproc.processException(e);
            }
        }
    }

    public IProxyBeanType getBeanType(String beanTypeName) {
        if (this.beanTypeCache == null) {
            this.beanTypeCache = new HashMap();
        }
        return (IProxyBeanType)this.beanTypeCache.get(beanTypeName);
    }

    public void addBeanType(String beanTypeName, IProxyBeanType beantype) {
        this.beanTypeCache.put(beanTypeName, beantype);
    }

    public void removeBeanType(String beanTypeName) {
        this.beanTypeCache.remove(beanTypeName);
    }

    protected void pushMethodToProxy(ExpressionProxy proxy, IProxyBeanType declaringType, String methodName, IProxyBeanType[] parameterTypes) {
        try {
            Class[] parameterClasses;
            final Map methods = this.getMethods(declaringType);
            final Object key = this.getMethodKey(methodName, parameterTypes);
            methods.put(key, proxy);
            proxy.addProxyListener(new ExpressionProxy.ProxyAdapter(){

                public void proxyNotResolved(ExpressionProxy.ProxyEvent event) {
                    methods.remove(key);
                }
            });
            IDEMethodExpressionProxy ep = (IDEMethodExpressionProxy)proxy;
            ep.setMethodName(methodName);
            Class declaringClass = this.getIDEBeanTypeProxy(declaringType).getTypeClass();
            if (parameterTypes == null || parameterTypes.length == 0) {
                parameterClasses = null;
            } else {
                parameterClasses = new Class[parameterTypes.length];
                int i = 0;
                while (i < parameterClasses.length) {
                    parameterClasses[i] = this.getIDEBeanTypeProxy(parameterTypes[i]).getTypeClass();
                    ++i;
                }
            }
            IDEMethodProxy methodProxy = ((IDEMethodProxyFactory)this.registry.getMethodProxyFactory()).getMethodProxy(declaringClass, methodName, parameterClasses);
            if (methodProxy == null) {
                String parms = "";
                if (parameterTypes != null && parameterTypes.length > 0) {
                    StringBuffer st = new StringBuffer(100);
                    int i = 0;
                    while (i < parameterClasses.length) {
                        if (i > 0) {
                            st.append(',');
                        }
                        st.append(parameterTypes[i].getTypeName());
                        ++i;
                    }
                    parms = st.toString();
                }
                NoSuchMethodException noSuchMethodException = new NoSuchMethodException("No method: " + declaringType + '.' + methodName + "(" + parms + ')');
                IDEStandardBeanTypeProxyFactory iDEStandardBeanTypeProxyFactory = this.getIDEBeanTypeFactory();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.NoSuchMethodException");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new IDEThrowableProxy(noSuchMethodException, iDEStandardBeanTypeProxyFactory.getBeanTypeProxy(clazz));
            }
            ep.setProxy(methodProxy);
            this.eproc.allocateExpressionProxy(ep);
        }
        catch (ThrowableProxy e) {
            ((IDEMethodExpressionProxy)proxy).setThrowable(e);
            this.eproc.processException(e);
        }
    }

    private Map getMethods(IProxyBeanType classtype) {
        HashMap methods;
        if (this.methodExpressionProxies == null) {
            this.methodExpressionProxies = new HashMap();
        }
        if ((methods = (HashMap)this.methodExpressionProxies.get(classtype.getTypeName())) == null) {
            methods = new HashMap();
            this.methodExpressionProxies.put(classtype.getTypeName(), methods);
        }
        return methods;
    }

    private Object getMethodKey(String methodName, IProxyBeanType[] parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            return methodName;
        }
        return new MethodKey(methodName, parameterTypes);
    }

    private Map getFields(IProxyBeanType classtype) {
        HashMap fields;
        if (this.fieldExpressionProxies == null) {
            this.fieldExpressionProxies = new HashMap();
        }
        if ((fields = (HashMap)this.fieldExpressionProxies.get(classtype.getTypeName())) == null) {
            fields = new HashMap();
            this.fieldExpressionProxies.put(classtype.getTypeName(), fields);
        }
        return fields;
    }

    IProxyMethod getMethodExpressionProxy(IProxyBeanType declaringType, String methodName, IProxyBeanType[] parameterTypes) {
        Map methods = this.getMethods(declaringType);
        Object key = this.getMethodKey(methodName, parameterTypes);
        return (IProxyMethod)methods.get(key);
    }

    IProxyField getFieldExpressionProxy(IProxyBeanType declaringType, String fieldName) {
        Map fields = this.getFields(declaringType);
        return (IProxyField)fields.get(fieldName);
    }

    protected IDEMethodProxy getIDEMethodProxy(IProxyMethod method) throws ThrowableProxy {
        IDEMethodProxy methodProxy = method.isExpressionProxy() ? ((IDEMethodExpressionProxy)method).getMethodProxy() : (IDEMethodProxy)method;
        return methodProxy;
    }

    protected void pushFieldToProxy(ExpressionProxy proxy, IProxyBeanType declaringType, final String fieldName) {
        try {
            final Map fields = this.getFields(declaringType);
            fields.put(fieldName, proxy);
            proxy.addProxyListener(new ExpressionProxy.ProxyAdapter(){

                public void proxyNotResolved(ExpressionProxy.ProxyEvent event) {
                    fields.remove(fieldName);
                }
            });
            IDEFieldExpressionProxy ep = (IDEFieldExpressionProxy)proxy;
            IDEFieldProxy fieldProxy = (IDEFieldProxy)this.getIDEBeanTypeProxy(declaringType).getFieldProxy(fieldName);
            if (fieldProxy == null) {
                NoSuchFieldException noSuchFieldException = new NoSuchFieldException("No field: " + declaringType + '.' + fieldName);
                IDEStandardBeanTypeProxyFactory iDEStandardBeanTypeProxyFactory = this.getIDEBeanTypeFactory();
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.NoSuchFieldException");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw new IDEThrowableProxy(noSuchFieldException, iDEStandardBeanTypeProxyFactory.getBeanTypeProxy(clazz));
            }
            ep.setProxy(fieldProxy);
            this.eproc.allocateExpressionProxy(ep);
        }
        catch (ThrowableProxy e) {
            ((IDEFieldExpressionProxy)proxy).setThrowable(e);
            this.eproc.processException(e);
        }
    }

    protected IDEFieldProxy getIDEFieldProxy(IProxyField field) throws ThrowableProxy {
        IDEFieldProxy fieldProxy = field.isExpressionProxy() ? ((IDEFieldExpressionProxy)field).getFieldProxy() : (IDEFieldProxy)field;
        return fieldProxy;
    }

    protected void pushIfTestToProxy() {
        this.eproc.pushIfElse();
    }

    protected void pushIfElseToProxy(InternalIfElseOperandType clauseType) {
        this.eproc.pushIfElse(clauseType);
    }

    protected void pushNewInstanceToProxy(String initializationString, IProxyBeanType resultType) {
        try {
            this.eproc.pushNewInstanceFromString(initializationString, this.getIDEBeanTypeProxy(resultType).getTypeClass(), this.getIDERegistry().fClassLoader);
        }
        catch (ThrowableProxy e) {
            this.eproc.processException(e);
        }
    }

    protected void pushMarkToProxy(int markID) {
        this.eproc.pushMark(markID);
    }

    protected void pushEndmarkToProxy(int markID, boolean restore) {
        this.eproc.pushEndmark(markID, restore);
    }

    protected void pushBeginTransferThreadToProxy() {
    }

    protected void pushTransferThreadToProxy() {
    }

    protected void pushSubexpressionBeginToProxy(int subexpressionNumber) {
        this.eproc.pushSubexpressionBegin(subexpressionNumber);
    }

    protected void pushSubexpressionEndToProxy(int subexpressionNumber) {
        this.eproc.pushSubexpressionEnd(subexpressionNumber);
    }

    protected static class IDEBeanTypeExpressionProxy
    extends IDEExpressionProxy
    implements IBeanTypeExpressionProxy {
        private String typeName;
        private IDEBeanTypeProxy resolvedProxy;
        static /* synthetic */ Class class$0;

        public IDEBeanTypeExpressionProxy(int proxyid, Expression expression) {
            super(proxyid, 1, expression);
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String toString() {
            return String.valueOf(super.toString()) + " - " + this.getTypeName();
        }

        void setProxy(IDEBeanTypeProxy beantypeProxy) {
            this.resolvedProxy = beantypeProxy;
            Class clazz = this.resolvedProxy.getTypeClass();
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.Class");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.setProxy(clazz, clazz2);
        }

        IDEBeanTypeProxy getBeanTypeProxy() {
            return this.resolvedProxy;
        }

        public IProxyMethod getMethodProxy(IExpression expression, String methodName, IProxyBeanType[] parameterTypes) {
            IProxyMethod method = ((IDEExpression)expression).getMethodExpressionProxy(this, methodName, parameterTypes);
            if (method == null) {
                method = ((Expression)expression).createMethodExpressionProxy(this, methodName, parameterTypes);
            }
            return method;
        }

        public IProxyMethod getMethodProxy(IExpression expression, String methodName, String[] parameterTypes) {
            return ((IDEMethodProxyFactory)expression.getRegistry().getMethodProxyFactory()).getMethodProxy(expression, this, methodName, parameterTypes);
        }

        public IProxyMethod getMethodProxy(IExpression expression, String methodName) {
            return this.getMethodProxy(expression, methodName, (IProxyBeanType[])null);
        }

        public IProxyField getFieldProxy(IExpression expression, String fieldName) {
            IProxyField field = ((IDEExpression)expression).getFieldExpressionProxy(this, fieldName);
            if (field == null) {
                field = ((Expression)expression).createFieldExpressionProxy(this, fieldName);
            }
            return field;
        }
    }

    protected static class IDEExpressionProxy
    extends ExpressionProxy
    implements InternalExpressionProxy {
        private Object value;
        private Class type;
        private boolean set;

        protected IDEExpressionProxy(int proxyid, int proxyType, Expression expression) {
            super(proxyid, proxyType, expression);
        }

        protected void dispose() {
            super.dispose();
            this.value = null;
            this.type = null;
            this.set = false;
        }

        public Class getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setProxy(Object value, Class type) {
            this.value = value;
            this.type = type;
            this.set = true;
        }

        public boolean isSet() {
            return this.set;
        }
    }

    protected static class IDEFieldExpressionProxy
    extends IDEExpressionProxy
    implements IProxyField {
        private String fieldName;
        private IDEFieldProxy resolvedProxy;
        private ThrowableProxy errorThrowable;
        static /* synthetic */ Class class$0;

        public IDEFieldExpressionProxy(int proxyid, Expression expression) {
            super(proxyid, 3, expression);
        }

        void setField(String fieldName) {
            this.fieldName = fieldName;
        }

        public String toString() {
            return String.valueOf(super.toString()) + " - " + this.fieldName;
        }

        void setProxy(IDEFieldProxy fieldProxy) {
            this.resolvedProxy = fieldProxy;
            Object object = this.resolvedProxy.getBean();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Class");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.setProxy(object, clazz);
        }

        void setThrowable(ThrowableProxy errorThrowable) {
            this.errorThrowable = errorThrowable;
        }

        IDEFieldProxy getFieldProxy() throws ThrowableProxy {
            if (this.errorThrowable != null) {
                throw this.errorThrowable;
            }
            return this.resolvedProxy;
        }
    }

    protected static class IDEMethodExpressionProxy
    extends IDEExpressionProxy
    implements IProxyMethod {
        private String methodName;
        private IDEMethodProxy resolvedProxy;
        private ThrowableProxy errorThrowable;
        static /* synthetic */ Class class$0;

        public IDEMethodExpressionProxy(int proxyid, Expression expression) {
            super(proxyid, 2, expression);
        }

        void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public String toString() {
            return String.valueOf(super.toString()) + " - " + this.methodName;
        }

        void setProxy(IDEMethodProxy methodProxy) {
            this.resolvedProxy = methodProxy;
            Object object = this.resolvedProxy.getBean();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Class");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.setProxy(object, clazz);
        }

        void setThrowable(ThrowableProxy errorThrowable) {
            this.errorThrowable = errorThrowable;
        }

        IDEMethodProxy getMethodProxy() throws ThrowableProxy {
            if (this.errorThrowable != null) {
                throw this.errorThrowable;
            }
            return this.resolvedProxy;
        }
    }

    private static class MethodKey {
        public String methodName;
        public IProxyBeanType[] parmTypes;

        public MethodKey(String methodName, IProxyBeanType[] parmTypes) {
            this.methodName = methodName;
            this.parmTypes = parmTypes;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            try {
                return ((MethodKey)obj).compareParms(this.parmTypes);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            int h = this.methodName.hashCode();
            int i = 0;
            while (i < this.parmTypes.length) {
                h += this.parmTypes[i].getTypeName().hashCode();
                ++i;
            }
            return h;
        }

        protected boolean compareParms(IProxyBeanType[] parms) {
            if (parms.length != this.parmTypes.length) {
                return false;
            }
            int i = 0;
            while (i < parms.length) {
                if (!this.parmTypes[i].getTypeName().equals(parms[i].getTypeName())) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

