/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.utilities;

import java.io.UnsupportedEncodingException;
import org.eclipse.wst.common.internal.emf.utilities.InvalidPasswordCipherException;
import org.eclipse.wst.common.internal.emf.utilities.InvalidPasswordDecodingException;
import org.eclipse.wst.common.internal.emf.utilities.InvalidPasswordEncodingException;
import org.eclipse.wst.common.internal.emf.utilities.PasswordCipherUtil;
import org.eclipse.wst.common.internal.emf.utilities.UnsupportedCryptoAlgorithmException;

public class PasswordUtil {
    public static final String STRING_CONVERSION_CODE = "UTF8";
    public static final String EMPTY_STRING = "";
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final String DEFAULT_CRYPTO_ALGORITHM;
    private static final String[] SUPPORTED_CRYPTO_ALGORITHMS;
    private static final byte[] BASE64_ENCODE_MAP;
    private static final byte[] BASE64_DECODE_MAP;

    static {
        SUPPORTED_CRYPTO_ALGORITHMS = PasswordCipherUtil.getSupportedCryptoAlgorithms();
        DEFAULT_CRYPTO_ALGORITHM = SUPPORTED_CRYPTO_ALGORITHMS[0];
        byte[] abyte0 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        BASE64_ENCODE_MAP = abyte0;
        BASE64_DECODE_MAP = new byte[128];
        int i = 0;
        while (i < BASE64_DECODE_MAP.length) {
            PasswordUtil.BASE64_DECODE_MAP[i] = -1;
            ++i;
        }
        int j = 0;
        while (j < BASE64_ENCODE_MAP.length) {
            PasswordUtil.BASE64_DECODE_MAP[PasswordUtil.BASE64_ENCODE_MAP[j]] = (byte)j;
            ++j;
        }
    }

    public static String decode(String s) throws InvalidPasswordDecodingException, UnsupportedCryptoAlgorithmException {
        if (s == null) {
            throw new InvalidPasswordDecodingException();
        }
        String s1 = PasswordUtil.getCryptoAlgorithm(s);
        if (s1 == null) {
            throw new InvalidPasswordDecodingException();
        }
        if (!PasswordUtil.isValidCryptoAlgorithm(s1)) {
            throw new UnsupportedCryptoAlgorithmException();
        }
        String s2 = PasswordUtil.decode_password(PasswordUtil.removeCryptoAlgorithmTag(s), s1);
        if (s2 == null) {
            throw new InvalidPasswordDecodingException();
        }
        return s2;
    }

    public static String encode(String s) throws InvalidPasswordEncodingException, UnsupportedCryptoAlgorithmException {
        return PasswordUtil.encode(s, DEFAULT_CRYPTO_ALGORITHM);
    }

    public static String encode(String s, String s1) throws InvalidPasswordEncodingException, UnsupportedCryptoAlgorithmException {
        if (!PasswordUtil.isValidCryptoAlgorithm(s1)) {
            throw new UnsupportedCryptoAlgorithmException();
        }
        if (s == null) {
            throw new InvalidPasswordEncodingException();
        }
        if (PasswordUtil.getCryptoAlgorithm(s) != null) {
            throw new InvalidPasswordEncodingException();
        }
        String s2 = PasswordUtil.encode_password(s.trim(), s1.trim());
        if (s2 == null) {
            throw new InvalidPasswordEncodingException();
        }
        return s2;
    }

    public static String getCryptoAlgorithm(String s) {
        int j;
        int i;
        String s1 = null;
        if (s != null && (s = s.trim()).length() >= 2 && (i = s.indexOf("{")) == 0 && (j = s.indexOf("}", ++i)) > 0) {
            s1 = i < j ? s.substring(i, j).trim() : EMPTY_STRING;
        }
        return s1;
    }

    public static String getCryptoAlgorithmTag(String s) {
        String s1 = null;
        String s2 = PasswordUtil.getCryptoAlgorithm(s);
        if (s2 != null) {
            StringBuffer stringbuffer = new StringBuffer("{");
            if (s2.length() > 0) {
                stringbuffer.append(s2);
            }
            stringbuffer.append("}");
            s1 = stringbuffer.toString();
        }
        return s1;
    }

    public static boolean isValidCryptoAlgorithm(String s) {
        if (s != null) {
            if ((s = s.trim()).length() == 0) {
                return true;
            }
            int i = 0;
            while (i < SUPPORTED_CRYPTO_ALGORITHMS.length) {
                if (s.equalsIgnoreCase(SUPPORTED_CRYPTO_ALGORITHMS[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isValidCryptoAlgorithmTag(String s) {
        return PasswordUtil.isValidCryptoAlgorithm(PasswordUtil.getCryptoAlgorithm(s));
    }

    public static String passwordDecode(String s) {
        if (s == null) {
            return null;
        }
        String s1 = PasswordUtil.getCryptoAlgorithm(s);
        if (s1 == null) {
            return s;
        }
        if (!PasswordUtil.isValidCryptoAlgorithm(s1)) {
            return null;
        }
        return PasswordUtil.decode_password(PasswordUtil.removeCryptoAlgorithmTag(s), s1);
    }

    public static String passwordEncode(String s) {
        return PasswordUtil.passwordEncode(s, DEFAULT_CRYPTO_ALGORITHM);
    }

    public static String passwordEncode(String s, String s1) {
        if (!PasswordUtil.isValidCryptoAlgorithm(s1)) {
            return null;
        }
        if (s == null) {
            return null;
        }
        String s2 = PasswordUtil.getCryptoAlgorithm(s);
        if (s2 != null) {
            if (s2.equalsIgnoreCase(s1.trim())) {
                return s.trim();
            }
            return null;
        }
        return PasswordUtil.encode_password(s.trim(), s1.trim());
    }

    public static String removeCryptoAlgorithmTag(String s) {
        int j;
        int i;
        String s1 = null;
        if (s != null && (s = s.trim()).length() >= 2 && (i = s.indexOf("{")) == 0 && (j = s.indexOf("}", ++i)) > 0) {
            s1 = ++j < s.length() ? s.substring(j).trim() : EMPTY_STRING;
        }
        return s1;
    }

    private static byte[] convert_to_bytes(String s) {
        byte[] abyte0 = null;
        if (s != null) {
            if (s.length() == 0) {
                abyte0 = EMPTY_BYTE_ARRAY;
            } else {
                try {
                    abyte0 = s.getBytes(STRING_CONVERSION_CODE);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    abyte0 = null;
                }
            }
        }
        return abyte0;
    }

    private static String convert_to_string(byte[] abyte0) {
        String s = null;
        if (abyte0 != null) {
            if (abyte0.length == 0) {
                s = EMPTY_STRING;
            } else {
                try {
                    s = new String(abyte0, STRING_CONVERSION_CODE);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    s = null;
                }
            }
        }
        return s;
    }

    private static byte[] convert_viewable_to_bytes(String s) {
        byte[] abyte0 = null;
        if (s != null) {
            if (s.length() == 0) {
                abyte0 = EMPTY_BYTE_ARRAY;
            } else {
                try {
                    abyte0 = PasswordUtil.base64Decode(PasswordUtil.convert_to_bytes(s));
                }
                catch (Exception exception) {
                    abyte0 = null;
                }
            }
        }
        return abyte0;
    }

    private static byte[] base64Decode(byte[] abyte0) {
        int i = abyte0.length;
        while (abyte0[--i] == 61) {
        }
        byte[] abyte1 = new byte[i + 1 - abyte0.length / 4];
        int j = 0;
        while (j < abyte0.length) {
            abyte0[j] = BASE64_DECODE_MAP[abyte0[j]];
            ++j;
        }
        int k = abyte1.length - 2;
        int l = 0;
        int i1 = 0;
        while (l < k) {
            abyte1[l] = (byte)(abyte0[i1] << 2 & 0xFF | abyte0[i1 + 1] >>> 4 & 3);
            abyte1[l + 1] = (byte)(abyte0[i1 + 1] << 4 & 0xFF | abyte0[i1 + 2] >>> 2 & 0xF);
            abyte1[l + 2] = (byte)(abyte0[i1 + 2] << 6 & 0xFF | abyte0[i1 + 3] & 0x3F);
            l += 3;
            i1 += 4;
        }
        if (l < abyte1.length) {
            abyte1[l++] = (byte)(abyte0[i1] << 2 & 0xFF | abyte0[i1 + 1] >>> 4 & 3);
            if (l < abyte1.length) {
                abyte1[l] = (byte)(abyte0[i1 + 1] << 4 & 0xFF | abyte0[i1 + 2] >>> 2 & 0xF);
            }
        }
        return abyte1;
    }

    private static String convert_viewable_to_string(byte[] abyte0) {
        String s = null;
        if (abyte0 != null) {
            if (abyte0.length == 0) {
                s = EMPTY_STRING;
            } else {
                try {
                    s = PasswordUtil.convert_to_string(PasswordUtil.base64Encode(abyte0));
                }
                catch (Exception exception) {
                    s = null;
                }
            }
        }
        return s;
    }

    private static byte[] base64Encode(byte[] abyte0) {
        byte[] abyte1 = new byte[(abyte0.length + 2) / 3 * 4];
        int i = 0;
        int j = 0;
        while (i < abyte0.length - 2) {
            abyte1[j++] = BASE64_ENCODE_MAP[abyte0[i] >>> 2 & 0x3F];
            abyte1[j++] = BASE64_ENCODE_MAP[abyte0[i + 1] >>> 4 & 0xF | abyte0[i] << 4 & 0x3F];
            abyte1[j++] = BASE64_ENCODE_MAP[abyte0[i + 2] >>> 6 & 3 | abyte0[i + 1] << 2 & 0x3F];
            abyte1[j++] = BASE64_ENCODE_MAP[abyte0[i + 2] & 0x3F];
            i += 3;
        }
        if (i < abyte0.length) {
            abyte1[j++] = BASE64_ENCODE_MAP[abyte0[i] >>> 2 & 0x3F];
            if (i < abyte0.length - 1) {
                abyte1[j++] = BASE64_ENCODE_MAP[abyte0[i + 1] >>> 4 & 0xF | abyte0[i] << 4 & 0x3F];
                abyte1[j++] = BASE64_ENCODE_MAP[abyte0[i + 1] << 2 & 0x3F];
            } else {
                abyte1[j++] = BASE64_ENCODE_MAP[abyte0[i] << 4 & 0x3F];
            }
        }
        while (j < abyte1.length) {
            abyte1[j] = 61;
            ++j;
        }
        return abyte1;
    }

    private static String decode_password(String s, String s1) {
        StringBuffer stringbuffer = new StringBuffer();
        if (s1.length() == 0) {
            stringbuffer.append(s);
        } else {
            String s2 = null;
            if (s.length() > 0) {
                byte[] abyte0 = PasswordUtil.convert_viewable_to_bytes(s);
                if (abyte0 == null) {
                    return null;
                }
                if (abyte0.length > 0) {
                    byte[] abyte1 = null;
                    try {
                        abyte1 = PasswordCipherUtil.decipher(abyte0, s1);
                    }
                    catch (InvalidPasswordCipherException invalidPasswordCipherException) {
                        return null;
                    }
                    catch (UnsupportedCryptoAlgorithmException unsupportedCryptoAlgorithmException) {
                        return null;
                    }
                    if (abyte1 != null && abyte1.length > 0) {
                        s2 = PasswordUtil.convert_to_string(abyte1);
                    }
                }
            }
            if (s2 != null && s2.length() > 0) {
                stringbuffer.append(s2);
            }
        }
        return stringbuffer.toString();
    }

    private static String encode_password(String s, String s1) {
        StringBuffer stringbuffer = new StringBuffer("{");
        if (s1.length() == 0) {
            stringbuffer.append("}").append(s);
        } else {
            byte[] abyte0;
            stringbuffer.append(s1).append("}");
            String s2 = null;
            if (s.length() > 0 && (abyte0 = PasswordUtil.convert_to_bytes(s)).length > 0) {
                byte[] abyte1 = null;
                try {
                    abyte1 = PasswordCipherUtil.encipher(abyte0, s1);
                }
                catch (InvalidPasswordCipherException invalidPasswordCipherException) {
                    return null;
                }
                catch (UnsupportedCryptoAlgorithmException unsupportedCryptoAlgorithmException) {
                    return null;
                }
                if (abyte1 != null && abyte1.length > 0 && (s2 = PasswordUtil.convert_viewable_to_string(abyte1)) == null) {
                    return null;
                }
            }
            if (s2 != null && s2.length() > 0) {
                stringbuffer.append(s2);
            }
        }
        return stringbuffer.toString();
    }
}

